/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets;

import jadex.tools.jadexdoc.doclets.MessageRetriever;
import jadex.tools.jadexdoc.doclets.standard.StandardConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Group {
    private Map regExpGroupMap = new HashMap();
    private List sortedRegExpList = new ArrayList();
    private List groupList = new ArrayList();
    private Map pkgNameGroupMap = new HashMap();
    private final StandardConfiguration configuration;

    public Group(StandardConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean checkPackageGroups(String groupname, String pkgNameFormList) {
        StringTokenizer strtok = new StringTokenizer(pkgNameFormList, ":");
        if (this.groupList.contains(groupname)) {
            this.msg().printError(this.msg().getText("doclet.Groupname_already_used", groupname));
            return false;
        }
        this.groupList.add(groupname);
        while (strtok.hasMoreTokens()) {
            String id = strtok.nextToken();
            if (id.length() == 0) {
                this.msg().printError(this.msg().getText("doclet.Error_in_packagelist", groupname, pkgNameFormList));
                return false;
            }
            if (id.endsWith("*")) {
                if (this.foundGroupFormat(this.regExpGroupMap, id = id.substring(0, id.length() - 1))) {
                    return false;
                }
                this.regExpGroupMap.put(id, groupname);
                this.sortedRegExpList.add(id);
                continue;
            }
            if (this.foundGroupFormat(this.pkgNameGroupMap, id)) {
                return false;
            }
            this.pkgNameGroupMap.put(id, groupname);
        }
        Collections.sort(this.sortedRegExpList, new MapKeyComparator());
        return true;
    }

    boolean foundGroupFormat(Map map, String pkgFormat) {
        if (map.containsKey(pkgFormat)) {
            this.msg().printError(this.msg().getText("doclet.Same_package_name_used", pkgFormat));
            return true;
        }
        return false;
    }

    public Map groupPackages(String[] packages) {
        String defaultGroupName;
        HashMap groupPackageMap = new HashMap();
        String string = defaultGroupName = this.pkgNameGroupMap.isEmpty() && this.regExpGroupMap.isEmpty() ? this.msg().getText("doclet.Packages") : this.msg().getText("doclet.Other_Packages");
        if (!this.groupList.contains(defaultGroupName)) {
            this.groupList.add(defaultGroupName);
        }
        for (int i = 0; i < packages.length; ++i) {
            String pkgName = packages[i];
            String groupName = (String)this.pkgNameGroupMap.get(pkgName);
            if (groupName == null) {
                groupName = this.regExpGroupName(pkgName);
            }
            if (groupName == null) {
                groupName = defaultGroupName;
            }
            this.getPkgList(groupPackageMap, groupName).add(pkgName);
        }
        return groupPackageMap;
    }

    String regExpGroupName(String pkgName) {
        for (int j = 0; j < this.sortedRegExpList.size(); ++j) {
            String regexp = (String)this.sortedRegExpList.get(j);
            if (!pkgName.startsWith(regexp)) continue;
            return (String)this.regExpGroupMap.get(regexp);
        }
        return null;
    }

    List getPkgList(Map map, String groupname) {
        ArrayList list = (ArrayList)map.get(groupname);
        if (list == null) {
            list = new ArrayList();
            map.put(groupname, list);
        }
        return list;
    }

    public List getGroupList() {
        return this.groupList;
    }

    public MessageRetriever msg() {
        return this.configuration.standardmessage;
    }

    private static class MapKeyComparator
    implements Comparator {
        private MapKeyComparator() {
        }

        public int compare(Object key1, Object key2) {
            return ((String)key2).length() - ((String)key1).length();
        }
    }
}

