/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc.doclets;

import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.doclets.ElementNameComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class AgentTree {
    private List baseagents = new AgentList();
    private Map subcapabilities = new AgentMap();
    private List basecapabilities = new AgentList();
    private Map supercapabilities = new AgentMap();
    private Map implementingclasses = new AgentMap();

    public AgentTree(Configuration configuration) {
        configuration.message.notice("doclet.Building_Tree");
        this.buildTree(configuration.cmdLineAgents);
    }

    public AgentTree(List agents) {
        this.buildTree(agents);
    }

    private void buildTree(List agents) {
        for (int i = 0; i < agents.size(); ++i) {
            this.processClass((IMCapability)agents.get(i));
            this.processInterface((IMCapability)agents.get(i));
        }
        Collections.sort(this.baseagents, new ElementNameComparator());
        Collections.sort(this.basecapabilities, new ElementNameComparator());
        Iterator it = this.supercapabilities.values().iterator();
        while (it.hasNext()) {
            Collections.sort((List)it.next(), new ElementNameComparator());
        }
        it = this.subcapabilities.values().iterator();
        while (it.hasNext()) {
            Collections.sort((List)it.next(), new ElementNameComparator());
        }
    }

    private void processClass(IMCapability cd) {
        if (cd instanceof IMBDIAgent) {
            this.baseagents.add(cd);
        }
        IMCapabilityReference[] caprefs = cd.getCapabilityReferences();
        for (int i = 0; i < caprefs.length; ++i) {
            IMCapability cap = caprefs[i].getCapability();
            if (!this.add(this.subcapabilities, cd, cap)) {
                return;
            }
            this.processClass(cap);
        }
    }

    private void processInterface(IMCapability cd) {
        boolean containing = false;
        IMCapabilityReference[] intfacs = cd.getCapabilityReferences();
        if (intfacs.length > 0) {
            for (int i = 0; i < intfacs.length; ++i) {
                IMCapability cap = intfacs[i].getCapability();
                if (!this.add(this.supercapabilities, cap, cd)) {
                    return;
                }
                this.processInterface(cap);
            }
        } else if (!(cd instanceof IMBDIAgent) && !this.basecapabilities.contains(cd)) {
            this.basecapabilities.add(cd);
        }
    }

    private boolean add(Map map, IMCapability supercap, IMCapability cd) {
        List list = (List)map.get(supercap);
        if (list == null) {
            list = new AgentList();
            map.put(supercap, list);
        }
        if (list.contains(cd)) {
            return false;
        }
        list.add(cd);
        return true;
    }

    private List get(Map map, IMCapability cd) {
        List list = (List)map.get(cd);
        if (list == null) {
            return new AgentList();
        }
        return list;
    }

    public List subcapabilities(IMCapability cd) {
        return this.get(this.subcapabilities, cd);
    }

    public List supercapabilities(IMCapability cd) {
        return this.get(this.supercapabilities, cd);
    }

    public List implementingagents(IMCapability cd) {
        List result = this.get(this.implementingclasses, cd);
        List subinterfaces = this.allSubs(cd);
        ListIterator subInterfacesIter = subinterfaces.listIterator();
        while (subInterfacesIter.hasNext()) {
            ListIterator implementingClassesIter = this.implementingagents((IMCapability)subInterfacesIter.next()).listIterator();
            while (implementingClassesIter.hasNext()) {
                IMCapability c = (IMCapability)implementingClassesIter.next();
                if (result.contains(c)) continue;
                result.add(c);
            }
        }
        return result;
    }

    public List allSubs(IMCapability cd) {
        List list = this.get(cd instanceof IMBDIAgent ? this.subcapabilities : this.supercapabilities, cd);
        for (int i = 0; i < list.size(); ++i) {
            cd = (IMCapability)list.get(i);
            List tlist = this.get(cd instanceof IMBDIAgent ? this.subcapabilities : this.supercapabilities, cd);
            for (int j = 0; j < tlist.size(); ++j) {
                IMCapability tcd = (IMCapability)tlist.get(j);
                if (list.contains(tcd)) continue;
                list.add(tcd);
            }
        }
        Collections.sort(list, new ElementNameComparator());
        return list;
    }

    public List baseagents() {
        return this.baseagents;
    }

    public List basecapabilities() {
        return this.basecapabilities;
    }

    private static class AgentMap
    extends HashMap {
        private AgentMap() {
        }

        public Object get(Object key) {
            Object ret = super.get(key);
            if (ret != null) {
                return ret;
            }
            Set keyset = super.keySet();
            Iterator iterator = keyset.iterator();
            while (iterator.hasNext()) {
                String name2;
                Object k = iterator.next();
                String name1 = ((IMCapability)key).getFullName();
                if (!name1.equals(name2 = ((IMCapability)k).getFullName()) || !key.getClass().equals(k.getClass())) continue;
                return super.get(k);
            }
            return null;
        }
    }

    private static class AgentList
    extends ArrayList {
        private AgentList() {
        }

        public boolean contains(Object elem) {
            boolean ret = super.contains(elem);
            if (ret) {
                return true;
            }
            for (int i = 0; i < this.size(); ++i) {
                String name2;
                String name1 = ((IMCapability)elem).getFullName();
                if (!name1.equals(name2 = ((IMCapability)this.get(i)).getFullName()) || !elem.getClass().equals(this.get(i).getClass())) continue;
                return true;
            }
            return false;
        }
    }
}

