/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.model.IMCapability;
import jadex.tools.jadexdoc.Configuration;
import jadex.tools.jadexdoc.doclets.DocletAbortException;
import java.io.File;

public class PathManager {
    public static final String urlfileseparator = "/";
    public static final String fileseparator = File.separator;

    private PathManager() {
    }

    public static String getDirectoryPath(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuffer pathstr = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '.') {
                pathstr.append(fileseparator);
                continue;
            }
            pathstr.append(ch);
        }
        return pathstr.toString();
    }

    public static String getPath(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        StringBuffer pathstr = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '.') {
                pathstr.append(urlfileseparator);
                continue;
            }
            pathstr.append(ch);
        }
        return pathstr.toString();
    }

    public static String getRelativePath(String from, String to) {
        StringBuffer pathstr = new StringBuffer();
        pathstr.append(PathManager.getRelativePath(from));
        pathstr.append(PathManager.getPath(to));
        pathstr.append(urlfileseparator);
        return pathstr.toString();
    }

    public static String getRelativePath(String from) {
        if (from == null || from.length() == 0) {
            return "";
        }
        StringBuffer pathstr = new StringBuffer();
        for (int i = 0; i < from.length(); ++i) {
            char ch = from.charAt(i);
            if (ch != '.') continue;
            pathstr.append("../");
        }
        pathstr.append("../");
        return pathstr.toString();
    }

    public static String getPathNoTrailingSlash(String path) {
        if (path.equals("")) {
            return ".";
        }
        if (path.equals(urlfileseparator)) {
            return "/.";
        }
        if (path.endsWith(urlfileseparator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getBackPath(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        StringBuffer backpath = new StringBuffer();
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (ch != '/') continue;
            backpath.append("..");
            backpath.append(urlfileseparator);
        }
        return backpath.toString();
    }

    public static void createDirectory(Configuration configuration, String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        File dir = new File(path);
        if (dir.exists()) {
            return;
        }
        if (dir.mkdirs()) {
            return;
        }
        configuration.message.error("doclet.Unable_to_create_directory_0", path);
        throw new DocletAbortException();
    }

    public static String getPathToPackage(Package pd, String filename) {
        StringBuffer buf = new StringBuffer();
        String pathstr = PathManager.getPath(pd.getName());
        if (pathstr.length() > 0) {
            buf.append(pathstr);
            buf.append(urlfileseparator);
        }
        buf.append(filename);
        return buf.toString();
    }

    public static String getPathToAgent(IMCapability agent, String filename) {
        StringBuffer buf = new StringBuffer();
        String pathstr = PathManager.getPath(agent.getPackage());
        if (pathstr.length() > 0) {
            buf.append(pathstr);
            buf.append(urlfileseparator);
        }
        buf.append(filename);
        return buf.toString();
    }

    public static String getPathToClass(Class cd) {
        return PathManager.getPath(cd.getName()) + ".html";
    }
}

