/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messager {
    private static Messager instance;
    public PrintWriter errWriter;
    public PrintWriter warnWriter;
    public PrintWriter noticeWriter;
    private final int MaxErrors = 100;
    private final int MaxWarnings = 100;
    private boolean promptOnError;
    private boolean emitWarnings;
    private int nerrors = 0;
    private int nwarnings = 0;
    private final String programName;
    private ResourceBundle messageRB = null;

    public static Messager getInstance() {
        if (instance == null) {
            instance = new Messager("default");
        }
        return instance;
    }

    public static void setInstance(Messager messager) {
        instance = messager;
    }

    protected Messager(String programName) {
        this(programName, null, null, null);
    }

    protected Messager(String programName, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        this.errWriter = errWriter;
        this.warnWriter = warnWriter;
        this.noticeWriter = noticeWriter;
        this.programName = programName;
    }

    public void reset() {
        this.messageRB = null;
    }

    private String getString(String key) {
        ResourceBundle messageRB = this.messageRB;
        if (messageRB == null) {
            try {
                this.messageRB = messageRB = ResourceBundle.getBundle("jadex.tools.jadexdoc.resources.jadexdoc");
            }
            catch (MissingResourceException e) {
                throw new Error("Fatal: Resource for jadexdoc is missing");
            }
        }
        return messageRB.getString(key);
    }

    String getText(String key) {
        return this.getText(key, null);
    }

    String getText(String key, String a1) {
        return this.getText(key, a1, null);
    }

    String getText(String key, String a1, String a2) {
        return this.getText(key, a1, a2, null);
    }

    String getText(String key, String a1, String a2, String a3) {
        return this.getText(key, a1, a2, a3, null);
    }

    String getText(String key, String a1, String a2, String a3, String a4) {
        try {
            String message = this.getString(key);
            String[] args = new String[]{a1, a2, a3, a4};
            return MessageFormat.format(message, args);
        }
        catch (MissingResourceException e) {
            return "********** Resource for jadexdoc is broken. There is no " + key + " key in resource.";
        }
    }

    public void printError(String msg) {
        if (this.errWriter != null) {
            this.errWriter.println(this.programName + ": " + msg);
            this.errWriter.flush();
        } else {
            System.err.println(this.programName + ": " + msg);
        }
        this.prompt();
        ++this.nerrors;
    }

    public void printWarning(String msg) {
        if (this.warnWriter != null) {
            this.warnWriter.println(this.programName + ": warning - " + msg);
            this.warnWriter.flush();
        } else {
            System.err.println(this.programName + ": warning - " + msg);
        }
        ++this.nwarnings;
    }

    public void printNotice(String msg) {
        if (this.noticeWriter != null) {
            this.noticeWriter.println(this.programName + ": " + msg);
            this.noticeWriter.flush();
        } else {
            System.out.println(this.programName + ": " + msg);
        }
    }

    public void error(String key) {
        this.printError(this.getText(key));
    }

    public void error(String key, String a1) {
        this.printError(this.getText(key, a1));
    }

    public void error(String key, String a1, String a2) {
        this.printError(this.getText(key, a1, a2));
    }

    public void error(String key, String a1, String a2, String a3) {
        this.printError(this.getText(key, a1, a2, a3));
    }

    public void warning(String key) {
        this.printWarning(this.getText(key));
    }

    public void warning(String key, String a1) {
        this.printWarning(this.getText(key, a1));
    }

    public void warning(String key, String a1, String a2) {
        this.printWarning(this.getText(key, a1, a2));
    }

    public void warning(String key, String a1, String a2, String a3) {
        this.printWarning(this.getText(key, a1, a2, a3));
    }

    public void warning(String key, String a1, String a2, String a3, String a4) {
        this.printWarning(this.getText(key, a1, a2, a3, a4));
    }

    public void notice(String key) {
        this.printNotice(this.getText(key));
    }

    public void notice(String key, String a1) {
        this.printNotice(this.getText(key, a1));
    }

    public void notice(String key, String a1, String a2) {
        this.printNotice(this.getText(key, a1, a2));
    }

    public void notice(String key, String a1, String a2, String a3) {
        this.printNotice(this.getText(key, a1, a2, a3));
    }

    public int nerrors() {
        return this.nerrors;
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public void exitNotice() {
        if (this.nerrors > 0) {
            this.notice(this.nerrors > 1 ? "main.errors" : "main.error", "" + this.nerrors);
        }
        if (this.nwarnings > 0) {
            this.notice(this.nwarnings > 1 ? "main.warnings" : "main.warning", "" + this.nwarnings);
        }
    }

    public void flush() {
        if (this.errWriter != null) {
            this.errWriter.flush();
        }
        if (this.warnWriter != null) {
            this.warnWriter.flush();
        }
        if (this.noticeWriter != null) {
            this.noticeWriter.flush();
        }
    }

    public void prompt() {
        if (this.isPromptOnError()) {
            System.err.println(this.getText("jadexdoc.resume.abort"));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isPromptOnError() {
        return this.promptOnError;
    }

    public void setPromptOnError(boolean promptOnError) {
        this.promptOnError = promptOnError;
    }

    public boolean isEmitWarnings() {
        return this.emitWarnings;
    }

    public void setEmitWarnings(boolean emitWarnings) {
        this.emitWarnings = emitWarnings;
    }

    public int getNerrors() {
        return this.nerrors;
    }

    public void setNerrors(int nerrors) {
        this.nerrors = nerrors;
    }

    public int getNwarnings() {
        return this.nwarnings;
    }

    public void setNwarnings(int nwarnings) {
        this.nwarnings = nwarnings;
    }
}

