/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.config.Configuration;
import jadex.tools.jadexdoc.CommandLine;
import jadex.tools.jadexdoc.DocletInvoker;
import jadex.tools.jadexdoc.JadexdocTool;
import jadex.tools.jadexdoc.Messager;
import jadex.tools.jadexdoc.doclets.MessageRetriever;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class Main {
    protected static final String JADEXDOC_NAME = "jadexdoc";
    protected static final String STANDARD_DOCLET_CLASSNAME = "jadex.tools.jadexdoc.doclets.standard.Standard";
    protected static final String RESOURCE_LOCATION = "jadex.tools.jadexdoc.resources.jadexdoc";
    protected final String defaultDocletClassName;
    protected List options = new ArrayList();
    protected Messager msg;
    protected MessageRetriever messager;
    protected DocletInvoker docletInvoker;
    protected JadexdocTool jadexdocTool;
    protected boolean rejectWarnings = false;

    Main(String programName, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter, String defaultDocletClassName) {
        this.msg = new Messager(programName, errWriter, warnWriter, noticeWriter);
        Messager.setInstance(this.msg);
        this.messager = new MessageRetriever(this.msg, RESOURCE_LOCATION);
        this.defaultDocletClassName = defaultDocletClassName;
    }

    Main(String programName, String defaultDocletClassName) {
        this.msg = new Messager(programName);
        Messager.setInstance(this.msg);
        this.messager = new MessageRetriever(this.msg, RESOURCE_LOCATION);
        this.defaultDocletClassName = defaultDocletClassName;
    }

    Main(String programName) {
        this(programName, STANDARD_DOCLET_CLASSNAME);
    }

    Main() {
        this(JADEXDOC_NAME);
    }

    public static void main(String[] args) {
        System.exit(Main.execute(args));
    }

    public static int execute(String[] args) {
        Configuration.setFallbackConfiguration((String)"jadex/config/batch_conf.properties");
        Main jdoc = new Main();
        return jdoc.begin(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int begin(String[] argv) {
        boolean failed = false;
        try {
            failed = !this.parseAndExecute(argv);
        }
        catch (ExitJadexdoc exc) {
        }
        catch (OutOfMemoryError ee) {
            this.messager.error("main.out.of.memory");
            failed = true;
        }
        catch (Error ee) {
            ee.printStackTrace();
            this.messager.error("main.fatal.error");
            failed = true;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            this.messager.error("main.fatal.exception");
            failed = true;
        }
        finally {
            this.messager.exitNotice();
            this.messager.flush();
        }
        failed |= this.messager.nerrors() > 0;
        return (failed |= this.rejectWarnings && this.messager.nwarnings() > 0) ? 1 : 0;
    }

    protected boolean parseAndExecute(String[] argv) {
        long tm = System.currentTimeMillis();
        try {
            argv = CommandLine.parse(argv);
        }
        catch (FileNotFoundException e) {
            this.messager.error("File_Read_Error", e.getMessage());
            this.exit();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.exit();
        }
        this.setDocletInvoker(argv);
        ArrayList<String> jadexNames = new ArrayList<String>();
        ArrayList subPackages = new ArrayList();
        ArrayList excludedPackages = new ArrayList();
        HashMap<String, String> compOpts = new HashMap<String, String>();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-subpackages")) {
                this.oneArg(argv, i++);
                this.addToList(subPackages, argv[i]);
                continue;
            }
            if (arg.equals("-exclude")) {
                this.oneArg(argv, i++);
                this.addToList(excludedPackages, argv[i]);
                continue;
            }
            if (arg.equals("-verbose")) {
                this.setOption(arg);
                compOpts.put("-verbose", "");
                continue;
            }
            if (arg.equals("-encoding")) {
                this.oneArg(argv, i++);
                compOpts.put("-encoding", argv[i]);
                continue;
            }
            if (arg.equals("-breakiterator")) {
                this.setOption("-breakiterator");
                continue;
            }
            if (arg.equals("-help")) {
                this.usage();
                this.exit();
                continue;
            }
            if (arg.equals("-prompt")) {
                compOpts.put("-prompt", "-prompt");
                this.messager.setPromptOnError(true);
                continue;
            }
            if (arg.equals("-overview")) {
                this.oneArg(argv, i++);
                continue;
            }
            if (arg.equals("-doclet")) {
                ++i;
                continue;
            }
            if (arg.equals("-docletpath")) {
                ++i;
                continue;
            }
            if (arg.startsWith("-")) {
                int optionLength = this.docletInvoker.optionLength(arg);
                if (optionLength < 0) {
                    this.exit();
                    continue;
                }
                if (optionLength == 0) {
                    this.usageError("main.invalid_flag", arg);
                    continue;
                }
                if (i + optionLength > argv.length) {
                    this.usageError("main.requires_argument", arg);
                }
                ArrayList<String> args = new ArrayList<String>();
                for (int j = 0; j < optionLength - 1; ++j) {
                    args.add(argv[++i]);
                }
                this.setOption(arg, args);
                continue;
            }
            jadexNames.add(arg);
        }
        if (jadexNames.isEmpty() && subPackages.isEmpty()) {
            this.usageError("main.No_packages_or_agents_specified");
        }
        if (!this.docletInvoker.validOptions(this.options)) {
            this.exit();
        }
        this.docletInvoker.setOptions(this.options);
        this.jadexdocTool = new JadexdocTool(this.messager, this.options);
        this.jadexdocTool.setJadexNames(jadexNames, subPackages, excludedPackages);
        this.docletInvoker.setAgents(this.jadexdocTool.getAgents());
        this.docletInvoker.setPackages(this.jadexdocTool.getPackages());
        boolean ok = this.docletInvoker.start();
        if (compOpts.get("-verbose") != null) {
            tm = System.currentTimeMillis() - tm;
            this.messager.notice("main.done_in", Long.toString(tm));
        }
        return ok;
    }

    protected void setDocletInvoker(String[] argv) {
        String docletClassName = null;
        String docletPath = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.equals("-doclet")) {
                this.oneArg(argv, i++);
                if (docletClassName != null) {
                    this.usageError("main.more_than_one_doclet_specified_0_and_1", docletClassName, argv[i]);
                }
                docletClassName = argv[i];
                continue;
            }
            if (!arg.equals("-docletpath")) continue;
            this.oneArg(argv, i++);
            docletPath = docletPath == null ? argv[i] : docletPath + File.pathSeparator + argv[i];
        }
        if (docletClassName == null) {
            docletClassName = this.defaultDocletClassName;
        }
        try {
            this.docletInvoker = new DocletInvoker(this.messager, docletClassName, docletPath);
        }
        catch (ClassNotFoundException e) {
            this.messager.error("main.doclet_class_not_found", docletClassName);
            this.exit();
        }
        catch (IllegalAccessException e) {
            this.messager.error("main.exception_thrown", docletClassName, e.toString());
            this.exit();
        }
        catch (InstantiationException e) {
            this.messager.error("main.exception_thrown", docletClassName, e.toString());
            this.exit();
        }
    }

    protected void oneArg(String[] args, int index) {
        if (index + 1 < args.length) {
            this.setOption(args[index], args[index + 1]);
        } else {
            this.usageError("main.requires_argument", args[index]);
        }
    }

    protected void addToList(List list, String str) {
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            list.add(current);
        }
    }

    protected void usageError(String key) {
        this.messager.error(key);
        this.usage();
        this.exit();
    }

    protected void usageError(String key, String a1) {
        this.messager.error(key, a1);
        this.usage();
        this.exit();
    }

    protected void usageError(String key, String a1, String a2) {
        this.messager.error(key, a1, a2);
        this.usage();
        this.exit();
    }

    protected void setOption(String opt) {
        String[] option = new String[]{opt};
        this.options.add(option);
    }

    protected void setOption(String opt, String argument) {
        String[] option = new String[]{opt, argument};
        this.options.add(option);
    }

    protected void setOption(String opt, List arguments) {
        String[] args = new String[arguments.size() + 1];
        int k = 0;
        args[k++] = opt;
        for (int i = 0; i < arguments.size(); ++i) {
            args[k++] = (String)arguments.get(i);
        }
        this.options.add(args);
    }

    protected void usage() {
        this.messager.notice("main.usage");
        if (this.docletInvoker != null) {
            this.docletInvoker.optionLength("-help");
        }
    }

    protected void exit() {
        throw new ExitJadexdoc();
    }

    protected class ExitJadexdoc
    extends Error {
    }
}

