/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.model.IMCapability;
import jadex.model.SXML;
import jadex.tools.jadexdoc.doclets.MessageRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JadexdocTool {
    private final MessageRetriever messager;
    private static final char pathSep = File.pathSeparatorChar;
    public static final String pathSeparator = File.pathSeparator;
    private String classPath;
    private String sourceClassPath;
    private List agents;
    private List packages;

    protected JadexdocTool(MessageRetriever messager, List options) {
        this.messager = messager;
        this.setPaths(options);
    }

    public boolean setJadexNames(List jadexNames, List subPackages, List excludedPackages) {
        int i;
        ArrayList<String> pkgnames = new ArrayList<String>();
        HashSet<String> packages = new HashSet<String>();
        HashSet<IMCapability> agents = new HashSet<IMCapability>();
        for (i = 0; i < jadexNames.size(); ++i) {
            String name = (String)jadexNames.get(i);
            if (SXML.isJadexFilename((String)name)) {
                this.messager.notice("main.Loading_source_file", name);
                IMCapability model = this.loadCapability(name);
                if (model == null) continue;
                agents.add(model);
                packages.add(model.getPackage() == null ? "" : model.getPackage());
                continue;
            }
            pkgnames.add(name);
        }
        this.searchSubPackages(subPackages, pkgnames, excludedPackages);
        for (i = 0; i < pkgnames.size(); ++i) {
            String pack = (String)pkgnames.get(i);
            this.parsePackageClasses(pack, agents, packages, excludedPackages);
        }
        this.messager.notice("main.Building_jadexdoc");
        this.agents = new ArrayList(agents);
        this.packages = new ArrayList(packages);
        return this.messager.nerrors() == 0;
    }

    private void parsePackageClasses(String pkgname, Set agents, Set packages, List excludedPackages) {
        if (excludedPackages.contains(pkgname)) {
            return;
        }
        boolean hasFiles = false;
        String path = this.sourceClassPath;
        if (path == null) {
            path = this.classPath;
        }
        int plen = path.length();
        int i = 0;
        this.messager.notice("main.Loading_source_files_for_package", pkgname);
        pkgname = pkgname.replace('.', File.separatorChar);
        while (i < plen) {
            int end = path.indexOf(pathSep, i);
            String pathname = path.substring(i, end);
            File f = new File(pathname, pkgname);
            String[] names = f.list();
            if (names != null) {
                String dir = f.getAbsolutePath();
                if (!dir.endsWith(File.separator)) {
                    dir = dir + File.separator;
                }
                for (int j = 0; j < names.length; ++j) {
                    String fn;
                    IMCapability model;
                    if (!SXML.isJadexFilename((String)names[j]) || (model = this.loadCapability(fn = dir + names[j])) == null) continue;
                    agents.add(model);
                    packages.add(model.getPackage() == null ? "" : model.getPackage());
                    hasFiles = true;
                }
            }
            i = end + 1;
        }
        if (!hasFiles) {
            this.messager.warning("main.no_source_files_for_package", pkgname.replace(File.separatorChar, '.'));
        }
    }

    private void searchSubPackages(List subPackages, List packages, List excludedPackages) {
        for (int i = 0; i < subPackages.size(); ++i) {
            String subpack = (String)subPackages.get(i);
            this.searchSubPackages(subpack, packages, excludedPackages);
        }
    }

    private void searchSubPackages(String name, List packages, List excludedPackages) {
        if (excludedPackages.contains(name)) {
            return;
        }
        String path = this.sourceClassPath + pathSep + this.classPath;
        int plen = path.length();
        int i = 0;
        String packageName = name.replace('.', File.separatorChar);
        boolean addedPackage = false;
        while (i < plen) {
            int end = path.indexOf(pathSep, i);
            String pathname = path.substring(i, end);
            File f = new File(pathname, packageName);
            String[] names = f.list();
            if (names != null) {
                for (int j = 0; j < names.length; ++j) {
                    if (!addedPackage && SXML.isJadexFilename((String)names[j]) && !packages.contains(name)) {
                        packages.add(name);
                        addedPackage = true;
                        continue;
                    }
                    if (!new File(f.getPath(), names[j]).isDirectory()) continue;
                    this.searchSubPackages(name + "." + names[j], packages, excludedPackages);
                }
            }
            i = end + 1;
        }
    }

    private static boolean isValidClassName(String clazzName) {
        if (clazzName.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(clazzName.charAt(0))) {
            return false;
        }
        for (int i = 1; i < clazzName.length(); ++i) {
            if (Character.isJavaIdentifierPart(clazzName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void setPaths(List optlist) {
        String[][] options = (String[][])optlist.toArray((T[])new String[optlist.size()][]);
        String cp = null;
        String sp = null;
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-classpath")) {
                cp = os[1];
            }
            if (!opt.equals("-sourcepath")) continue;
            sp = os[1];
        }
        if (cp == null) {
            cp = System.getProperty("env.class.path");
        }
        if (cp == null && System.getProperty("application.home") == null) {
            cp = System.getProperty("java.class.path");
        }
        if (cp == null) {
            cp = ".";
        }
        this.classPath = this.terminate(cp);
        this.sourceClassPath = sp != null ? this.terminate(sp) : null;
    }

    private String terminate(String s) {
        return s.endsWith(pathSeparator) ? s : s + pathSeparator;
    }

    public List getAgents() {
        return this.agents;
    }

    public List getPackages() {
        return this.packages;
    }

    protected IMCapability loadCapability(String xml) {
        IMCapability ret = null;
        try {
            ret = (IMCapability)SXML.loadModel((String)xml, (String)"jadex/tools/jadexdoc/resources/jadexdoc.xsl");
        }
        catch (Exception e) {
            this.messager.error("jadexdoc.File_Parse_Error", xml);
        }
        return ret;
    }
}

