/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.model.SXML;
import jadex.tools.common.ModelExplorer;
import jadex.tools.common.PopupBuilder;
import jadex.tools.common.ToolTipAction;
import jadex.tools.common.plugin.IControlCenter;
import jadex.tools.jadexdoc.JadexdocPanel;
import jadex.tools.jcc.AbstractJCCPlugin;
import jadex.tools.starter.DirNode;
import jadex.tools.starter.FileNode;
import jadex.tools.starter.RootNode;
import jadex.tools.starter.StarterPlugin;
import jadex.util.SGUI;
import jadex.util.collection.SCollection;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.tree.TreeNode;

public class JadexdocPlugin
extends AbstractJCCPlugin {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"scanning_on", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_refresh_anim.gif"), "jadexdoc", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_jadexdoc.png"), "jadexdoc_sel", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_jadexdoc_sel.png"), "add_package", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_add_package.png"), "remove_package", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_remove_package.png"), "add_all_packages", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_add_all_packages.png"), "remove_all_packages", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_remove_all_packages.png"), "add_file", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_add_agent_big.png"), "remove_file", SGUI.makeIcon((Class)JadexdocPlugin.class, (String)"/jadex/tools/common/images/new_remove_agent_big.png")});
    protected static final FileFilter ADF_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory() || SXML.isJadexFilename((String)pathname.getName());
        }
    };
    private JadexdocPanel jpanel;
    private ModelExplorer mpanel;
    private JSplitPane csplit;
    public final Action ADD_ALL_PACKAGES = new ToolTipAction("Add All Packages", icons.getIcon("add_all_packages"), "Add all packages recursively starting with this package"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                List all = JadexdocPlugin.this.findRecursivePackages((FileNode)node);
                for (int i = 0; i < all.size(); ++i) {
                    JadexdocPlugin.this.jpanel.addEntry((String)all.get(i));
                }
            }
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof DirNode) {
                DirNode dn = (DirNode)node;
                for (int i = 0; !ret && i < dn.getChildCount(); ++i) {
                    if (!(dn.getChildAt(i) instanceof DirNode)) continue;
                    ret = true;
                }
                if (ret) {
                    ret = false;
                    List all = JadexdocPlugin.this.findRecursivePackages(dn);
                    all.remove(JadexdocPlugin.this.getEntryName(dn));
                    for (int i = 0; !ret && i < all.size(); ++i) {
                        if (JadexdocPlugin.this.jpanel.containsEntry((String)all.get(i))) continue;
                        ret = true;
                    }
                }
            }
            return ret;
        }
    };
    public final Action REMOVE_ALL_PACKAGES = new ToolTipAction("Remove All Packages", icons.getIcon("remove_all_packages"), "Remove all packages recursively starting with this package"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                List all = JadexdocPlugin.this.findRecursivePackages((FileNode)node);
                for (int i = 0; i < all.size(); ++i) {
                    JadexdocPlugin.this.jpanel.removeEntry((String)all.get(i));
                }
            }
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof DirNode) {
                DirNode dn = (DirNode)node;
                for (int i = 0; !ret && i < dn.getChildCount(); ++i) {
                    if (!(dn.getChildAt(i) instanceof DirNode)) continue;
                    ret = true;
                }
                if (ret) {
                    ret = false;
                    List all = JadexdocPlugin.this.findRecursivePackages(dn);
                    all.remove(JadexdocPlugin.this.getEntryName(dn));
                    for (int i = 0; !ret && i < all.size(); ++i) {
                        if (!JadexdocPlugin.this.jpanel.containsEntry((String)all.get(i))) continue;
                        ret = true;
                    }
                }
            }
            return ret;
        }
    };
    public final Action ADD_PACKAGE = new ToolTipAction("Add Package", icons.getIcon("add_package"), "Add a package"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                JadexdocPlugin.this.jpanel.addEntry(JadexdocPlugin.this.getEntryName((FileNode)node));
            }
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof DirNode) {
                DirNode dn = (DirNode)node;
                ret = !JadexdocPlugin.this.jpanel.containsEntry(JadexdocPlugin.this.getEntryName(dn));
            }
            return ret;
        }
    };
    public final Action REMOVE_PACKAGE = new ToolTipAction("Remove Package", icons.getIcon("remove_package"), "Remove a package"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                JadexdocPlugin.this.jpanel.removeEntry(JadexdocPlugin.this.getEntryName((FileNode)node));
            }
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof DirNode) {
                DirNode dn = (DirNode)node;
                ret = JadexdocPlugin.this.jpanel.containsEntry(JadexdocPlugin.this.getEntryName(dn));
            }
            return ret;
        }
    };
    public final Action ADD_FILE = new ToolTipAction("Add File", icons.getIcon("add_file"), "Add a file"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                JadexdocPlugin.this.jpanel.addEntry(JadexdocPlugin.this.getEntryName((FileNode)node));
            }
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                FileNode fn = (FileNode)node;
                ret = SXML.isJadexFilename((String)fn.getFile().getName()) && !JadexdocPlugin.this.jpanel.containsEntry(JadexdocPlugin.this.getEntryName(fn));
            }
            return ret;
        }
    };
    public final Action REMOVE_FILE = new ToolTipAction("Remove File", icons.getIcon("remove_file"), "Remove a file"){

        public void actionPerformed(ActionEvent e) {
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                JadexdocPlugin.this.jpanel.removeEntry(JadexdocPlugin.this.getEntryName((FileNode)node));
            }
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreeNode node = (TreeNode)JadexdocPlugin.this.mpanel.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                FileNode fn = (FileNode)node;
                ret = SXML.isJadexFilename((String)fn.getFile().getName()) && JadexdocPlugin.this.jpanel.containsEntry(JadexdocPlugin.this.getEntryName(fn));
            }
            return ret;
        }
    };

    public void init(IControlCenter jcc) {
        super.init(jcc);
    }

    public String getName() {
        return "Jadexdoc";
    }

    public JToolBar getToolBar() {
        JToolBar bar = new JToolBar();
        JButton b = new JButton(this.mpanel.ADD_PATH);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.mpanel.REMOVE_PATH);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.mpanel.REFRESH);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.ADD_ALL_PACKAGES);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.REMOVE_ALL_PACKAGES);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        return bar;
    }

    public JComponent getPanel() {
        this.csplit = new JSplitPane(1, true);
        this.csplit.setOneTouchExpandable(true);
        JLabel refreshcomp = new JLabel(icons.getIcon("scanning_on"));
        refreshcomp.setToolTipText("Loading/checking agent models.");
        this.mpanel = new ModelExplorer(this.getJCC(), new RootNode(ADF_FILTER), refreshcomp, null);
        this.mpanel.setPopupBuilder(new PopupBuilder(new Object[]{this.mpanel.ADD_PATH, this.mpanel.REMOVE_PATH, this.mpanel.REFRESH, this.mpanel.REFRESH_ALL, this.ADD_FILE, this.REMOVE_FILE, this.ADD_PACKAGE, this.REMOVE_PACKAGE, this.ADD_ALL_PACKAGES, this.REMOVE_ALL_PACKAGES}));
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Object node;
                int row = JadexdocPlugin.this.mpanel.getRowForLocation(e.getX(), e.getY());
                if (row != -1 && e.getClickCount() == 2 && (node = JadexdocPlugin.this.mpanel.getLastSelectedPathComponent()) instanceof FileNode) {
                    List all = JadexdocPlugin.this.findRecursivePackages((FileNode)node);
                    for (int i = 0; i < all.size(); ++i) {
                        JadexdocPlugin.this.jpanel.addEntry((String)all.get(i));
                    }
                }
            }
        };
        this.mpanel.addMouseListener(ml);
        this.csplit.add(new JScrollPane(this.mpanel));
        this.jpanel = new JadexdocPanel(this, null);
        this.csplit.add(this.jpanel);
        this.csplit.setDividerLocation(180);
        return this.csplit;
    }

    protected List findRecursivePackages(FileNode node) {
        ArrayList ret = SCollection.createArrayList();
        if (node.getParent() != node.getRootNode()) {
            FileNode tmp = node;
            FileNode[] nodes = this.getAllChildren(tmp);
            ret.add(this.getEntryName(tmp));
            for (int i = 0; i < nodes.length; ++i) {
                if (!(nodes[i] instanceof DirNode)) continue;
                ret.add(this.getEntryName(nodes[i]));
            }
        }
        return ret;
    }

    protected String getEntryName(FileNode node) {
        String name = node.getFile().getAbsolutePath();
        if (!SXML.isJadexFilename((String)name)) {
            FileNode tmp = node;
            name = tmp.getFile().getName();
            while (tmp.getParent() instanceof FileNode && tmp.getParent().getParent() != tmp.getRootNode()) {
                tmp = (FileNode)tmp.getParent();
                name = tmp.getFile().getName() + "." + name;
            }
        }
        return name;
    }

    protected FileNode[] getAllChildren(FileNode node) {
        ArrayList todo = SCollection.createArrayList();
        todo.add(node);
        for (int i = 0; i < todo.size(); ++i) {
            FileNode tmp = (FileNode)todo.get(i);
            for (int j = 0; j < tmp.getChildCount(); ++j) {
                todo.add(tmp.getChildAt(j));
            }
        }
        todo.remove(node);
        return todo.toArray(new FileNode[todo.size()]);
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("jadexdoc_sel") : icons.getIcon("jadexdoc");
    }

    public JMenuBar createMenuBar() {
        return this.mpanel.createMenuBar();
    }

    public void setProperties(Properties props) {
        this.mpanel.setProperties(props);
        this.jpanel.setProperties(props);
        try {
            int msdl = Integer.parseInt(props.getProperty("mainsplit.location"));
            this.csplit.setDividerLocation(msdl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getProperties(Properties props) {
        this.mpanel.getProperties(props);
        this.jpanel.getProperties(props);
        props.put("mainsplit.location", Integer.toString(this.csplit.getDividerLocation()));
    }

    protected Component getCpanel() {
        return this.csplit;
    }

    protected JadexdocPanel getJadexdocPanel() {
        return this.jpanel;
    }

    public void reset() {
        this.mpanel.reset();
    }

    public void shutdown() {
        this.mpanel.close();
    }

    public String getHelpID() {
        return "tools.jadexdoc";
    }
}

