/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.model.SXML;
import jadex.tools.common.EditableList;
import jadex.tools.common.GuiProperties;
import jadex.tools.jadexdoc.GenerateOptions;
import jadex.tools.jadexdoc.JadexdocPlugin;
import jadex.util.BrowserLauncher;
import jadex.util.DynamicURLClassLoader;
import jadex.util.SGUI;
import jadex.util.SUtil;
import jadex.util.StreamCopy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class JadexdocPanel
extends JPanel {
    protected static UIDefaults icons = new UIDefaults(new Object[]{"browse", SGUI.makeIcon((Class)JadexdocPanel.class, (String)"/jadex/tools/common/images/dots_small.png"), "running_javadoc", SGUI.makeIcon((Class)JadexdocPanel.class, (String)"/jadex/tools/common/images/new_javadoc_anim.gif"), "running_jadexdoc", SGUI.makeIcon((Class)JadexdocPanel.class, (String)"/jadex/tools/common/images/new_jadexdoc_anim.gif")});
    protected JadexdocPlugin plugin;
    protected GenerateOptions options;
    protected JTextField output_dir;
    protected JCheckBox include_subs;
    protected JCheckBox gentreecb;
    protected JCheckBox gennavcb;
    protected JCheckBox genindexcb;
    protected JCheckBox gensplitindexcb;
    protected JCheckBox overviewcb;
    protected JTextField overviewtf;
    protected JCheckBox doctitlecb;
    protected JTextField doctitletf;
    protected JCheckBox generatejavadoc;
    protected JCheckBox generatejadexdoc;
    protected JTextField javadocloctf;
    protected JTextField javaloctf;
    protected JTextField extraoptionsjavadoctf;
    protected JTextField extraoptionsjadexdoctf;
    protected JButton startbut;
    protected EditableList sourcepaths;
    protected EditableList classpaths;
    protected EditableList packages;
    protected EditableList links;
    protected JSplitPane center;
    protected JTabbedPane lists;
    protected boolean running;
    protected boolean abort;

    public JadexdocPanel(JadexdocPlugin plugin, GenerateOptions options) {
        this.plugin = plugin;
        this.options = options;
        if (options == null) {
            this.options = new GenerateOptions();
        }
        JPanel settings = new JPanel(new GridBagLayout());
        settings.setBorder(new TitledBorder(new EtchedBorder(), "Settings"));
        this.include_subs = new JCheckBox("Include subpackages");
        int y = 0;
        settings.add((Component)this.include_subs, new GridBagConstraints(0, y, 3, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        JLabel outlab = new JLabel("Output directory:");
        this.output_dir = new JTextField();
        JButton browse_outdir = new JButton(icons.getIcon("browse"));
        final JFileChooser outchooser = new JFileChooser(".");
        outchooser.setFileSelectionMode(1);
        browse_outdir.setMargin(new Insets(0, 0, 0, 0));
        browse_outdir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (outchooser.showDialog(JadexdocPanel.this, "Select") == 0) {
                    JadexdocPanel.this.output_dir.setText(outchooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        settings.add((Component)outlab, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)this.output_dir, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)browse_outdir, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.overviewcb = new JCheckBox("Overview page:");
        final JFileChooser overviewchooser = new JFileChooser(".");
        overviewchooser.setAcceptAllFileFilterUsed(true);
        FileFilter filter = new FileFilter(){

            public String getDescription() {
                return "HTMLs";
            }

            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".html");
            }
        };
        overviewchooser.addChoosableFileFilter(filter);
        this.overviewtf = new JTextField();
        this.overviewtf.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                if (!"".equals(JadexdocPanel.this.overviewtf.getText()) && !JadexdocPanel.this.overviewcb.isSelected()) {
                    JadexdocPanel.this.overviewcb.setSelected(true);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if ("".equals(JadexdocPanel.this.overviewtf.getText()) && JadexdocPanel.this.overviewcb.isSelected()) {
                    JadexdocPanel.this.overviewcb.setSelected(false);
                }
            }
        });
        JButton browse_overview = new JButton(icons.getIcon("browse"));
        browse_overview.setMargin(new Insets(0, 0, 0, 0));
        browse_overview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (overviewchooser.showDialog(JadexdocPanel.this, "Load") == 0) {
                    JadexdocPanel.this.overviewtf.setText(overviewchooser.getSelectedFile().getAbsolutePath());
                    JadexdocPanel.this.overviewcb.setSelected(true);
                }
            }
        });
        settings.add((Component)this.overviewcb, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)this.overviewtf, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)browse_overview, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.doctitlecb = new JCheckBox("Document title:");
        this.doctitletf = new JTextField();
        this.doctitletf.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                if (!"".equals(JadexdocPanel.this.doctitletf.getText()) && !JadexdocPanel.this.doctitlecb.isSelected()) {
                    JadexdocPanel.this.doctitlecb.setSelected(true);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if ("".equals(JadexdocPanel.this.doctitletf.getText()) && JadexdocPanel.this.doctitlecb.isSelected()) {
                    JadexdocPanel.this.doctitlecb.setSelected(false);
                }
            }
        });
        settings.add((Component)this.doctitlecb, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)this.doctitletf, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel basicoptions = new JPanel(new GridBagLayout());
        basicoptions.setBorder(new TitledBorder(new EtchedBorder(), "Basic options"));
        this.gentreecb = new JCheckBox("Generate hierarchy tree");
        this.gennavcb = new JCheckBox("Generate navigation bar");
        this.genindexcb = new JCheckBox("Generate index");
        this.gensplitindexcb = new JCheckBox("Generate index per letter");
        basicoptions.add((Component)this.gentreecb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        basicoptions.add((Component)this.gennavcb, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        basicoptions.add((Component)this.genindexcb, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        basicoptions.add((Component)this.gensplitindexcb, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(2, 12, 2, 2), 0, 0));
        settings.add((Component)basicoptions, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.generatejavadoc = new JCheckBox("Generate Javadoc");
        settings.add((Component)this.generatejavadoc, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JLabel cmdlinelab = new JLabel("Extra options Javadoc:");
        this.extraoptionsjavadoctf = new JTextField();
        settings.add((Component)cmdlinelab, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)this.extraoptionsjavadoctf, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.javadocloctf = new JTextField();
        final JFileChooser javadocfc = new JFileChooser(".");
        JButton browse_javadoc = new JButton(icons.getIcon("browse"));
        browse_javadoc.setMargin(new Insets(0, 0, 0, 0));
        browse_javadoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (javadocfc.showDialog(JadexdocPanel.this, "Locate Javadoc") == 0) {
                    JadexdocPanel.this.javadocloctf.setText(javadocfc.getSelectedFile().getAbsolutePath());
                    JadexdocPanel.this.generatejavadoc.setSelected(true);
                }
            }
        });
        settings.add((Component)new JLabel("Javadoc program location: "), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)this.javadocloctf, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)browse_javadoc, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.generatejadexdoc = new JCheckBox("Generate Jadexdoc");
        settings.add((Component)this.generatejadexdoc, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JLabel cmdlinelabjadex = new JLabel("Extra options Jadexdoc:");
        this.extraoptionsjadexdoctf = new JTextField();
        settings.add((Component)cmdlinelabjadex, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)this.extraoptionsjadexdoctf, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.javaloctf = new JTextField();
        final JFileChooser javalocfc = new JFileChooser(".");
        JButton browse_java = new JButton(icons.getIcon("browse"));
        browse_java.setMargin(new Insets(0, 0, 0, 0));
        browse_java.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (javalocfc.showDialog(JadexdocPanel.this, "Locate Java") == 0) {
                    JadexdocPanel.this.javaloctf.setText(javalocfc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        settings.add((Component)new JLabel("Java program location for Jadexdoc: "), new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)this.javaloctf, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        settings.add((Component)browse_java, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.startbut = new JButton("Abort");
        this.startbut.putClientProperty("auto-adjust", Boolean.TRUE);
        JPanel setbuts = new JPanel(new GridBagLayout());
        this.startbut.setText("Start");
        this.startbut.setToolTipText("Start the documentation generation");
        JButton helpbut = new JButton("Help");
        helpbut.putClientProperty("auto-adjust", Boolean.TRUE);
        helpbut.setToolTipText("Invoke the JavaHelp for Jadexdoc");
        JButton openbrowser = new JButton("Show");
        openbrowser.putClientProperty("auto-adjust", Boolean.TRUE);
        openbrowser.setToolTipText("Open documentation from output dir in browser");
        settings.add((Component)openbrowser, new GridBagConstraints(0, ++y, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        openbrowser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JadexdocPanel.this.updateModel();
                JadexdocPanel.openDocInBrowser(JadexdocPanel.this.options);
            }
        });
        setbuts.add((Component)this.startbut, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        setbuts.add((Component)openbrowser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        setbuts.add((Component)helpbut, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        settings.add((Component)setbuts, new GridBagConstraints(0, ++y, 3, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.startbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!JadexdocPanel.this.running) {
                    JadexdocPanel.this.startbut.setText("Abort");
                    JadexdocPanel.this.startbut.setToolTipText("Abort the documentation generation");
                    JadexdocPanel.this.running = true;
                    JadexdocPanel.this.generate();
                } else if (!JadexdocPanel.this.abort) {
                    JadexdocPanel.this.abort = true;
                    JadexdocPanel.this.startbut.setText("Start");
                    JadexdocPanel.this.startbut.setToolTipText("Start the documentation generation");
                }
            }
        });
        this.lists = new JTabbedPane();
        JPanel packview = new JPanel(new BorderLayout());
        this.packages = new EditableList("Packages to document", true);
        JScrollPane scroll = new JScrollPane(this.packages);
        this.packages.setPreferredScrollableViewportSize(new Dimension(400, 200));
        JPanel buts = new JPanel(new GridBagLayout());
        JButton clear = new JButton("Clear");
        clear.putClientProperty("auto-adjust", Boolean.TRUE);
        buts.add((Component)clear, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        clear.setToolTipText("Clear the package list");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JadexdocPanel.this.packages.removeEntries();
            }
        });
        packview.add("Center", scroll);
        packview.add("South", buts);
        this.lists.add("Packages", packview);
        JPanel sourceview = new JPanel(new BorderLayout());
        this.sourcepaths = new EditableList("Source Paths", true);
        scroll = new JScrollPane(this.sourcepaths);
        this.sourcepaths.setPreferredScrollableViewportSize(new Dimension(400, 200));
        buts = new JPanel(new GridBagLayout());
        JButton add = new JButton("Add");
        add.putClientProperty("auto-adjust", Boolean.TRUE);
        clear = new JButton("Clear");
        clear.putClientProperty("auto-adjust", Boolean.TRUE);
        buts.add((Component)add, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)clear, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        add.setToolTipText("Add a source path entry");
        clear.setToolTipText("Clear the source path list");
        final JFileChooser chooser = new JFileChooser(".");
        chooser.setFileSelectionMode(1);
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (chooser.showDialog(SGUI.getWindowParent((Component)JadexdocPanel.this), "Load") == 0) {
                    File file = chooser.getSelectedFile();
                    JadexdocPanel.this.sourcepaths.addEntry("" + file);
                }
            }
        });
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JadexdocPanel.this.sourcepaths.removeEntries();
            }
        });
        sourceview.add("Center", scroll);
        sourceview.add("South", buts);
        this.lists.add("Source Paths", sourceview);
        JPanel classview = new JPanel(new BorderLayout());
        this.classpaths = new EditableList("Class Paths", true);
        scroll = new JScrollPane(this.classpaths);
        this.classpaths.setPreferredScrollableViewportSize(new Dimension(400, 200));
        buts = new JPanel(new GridBagLayout());
        add = new JButton("Add");
        add.putClientProperty("auto-adjust", Boolean.TRUE);
        JButton fetch = new JButton("Fetch");
        fetch.putClientProperty("auto-adjust", Boolean.TRUE);
        clear = new JButton("Clear");
        clear.putClientProperty("auto-adjust", Boolean.TRUE);
        add.setToolTipText("Add a class path entry");
        clear.setToolTipText("Clear the class path list");
        fetch.setToolTipText("Fetch all entries from current class path");
        buts.add((Component)add, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)clear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)fetch, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        final JFileChooser cchooser = new JFileChooser(".");
        cchooser.setFileSelectionMode(1);
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cchooser.showDialog(SGUI.getWindowParent((Component)JadexdocPanel.this), "Load") == 0) {
                    File file = cchooser.getSelectedFile();
                    JadexdocPanel.this.classpaths.addEntry("" + file);
                }
            }
        });
        fetch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JadexdocPanel.this.classpaths.removeEntries();
                List entries = JadexdocPanel.this.fetchClasspath();
                for (int i = 0; i < entries.size(); ++i) {
                    JadexdocPanel.this.classpaths.addEntry((String)entries.get(i));
                }
            }
        });
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JadexdocPanel.this.classpaths.removeEntries();
            }
        });
        classview.add("Center", scroll);
        classview.add("South", buts);
        this.lists.add("Class Paths", classview);
        JPanel linksview = new JPanel(new BorderLayout());
        this.links = new EditableList("URL links", true);
        scroll = new JScrollPane(this.links);
        this.links.setPreferredScrollableViewportSize(new Dimension(400, 200));
        buts = new JPanel(new GridBagLayout());
        add = new JButton("Add");
        add.putClientProperty("auto-adjust", Boolean.TRUE);
        fetch = new JButton("Fetch");
        fetch.putClientProperty("auto-adjust", Boolean.TRUE);
        clear = new JButton("Clear");
        clear.putClientProperty("auto-adjust", Boolean.TRUE);
        add.setToolTipText("Add a file URL");
        clear.setToolTipText("Clear the links list");
        fetch.setToolTipText("Fetch the J2SE link");
        buts.add((Component)add, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)clear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)fetch, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        final JFileChooser lchooser = new JFileChooser(".");
        lchooser.setFileSelectionMode(2);
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File file;
                if (lchooser.showDialog(SGUI.getWindowParent((Component)JadexdocPanel.this), "Load") == 0 && (file = lchooser.getSelectedFile()) != null) {
                    try {
                        JadexdocPanel.this.links.addEntry("" + file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        fetch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JadexdocPanel.this.links.addEntry("http://java.sun.com/javase/6/docs/api/");
            }
        });
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JadexdocPanel.this.links.removeEntries();
            }
        });
        linksview.add("Center", scroll);
        linksview.add("South", buts);
        this.lists.add("URL Links", linksview);
        this.setLayout(new BorderLayout());
        this.center = new JSplitPane(1);
        this.center.setOneTouchExpandable(true);
        this.center.setDividerLocation(200);
        this.center.add(this.lists);
        JScrollPane scrollx = new JScrollPane(settings);
        scrollx.setBorder(null);
        this.center.add(scrollx);
        this.add("Center", this.center);
        SGUI.adjustComponentSizes((Container)this);
        this.updateView();
        HelpBroker hb = GuiProperties.setupHelp(this, "tools.jadexdoc");
        if (hb != null) {
            helpbut.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
        }
    }

    protected void updateView() {
        int i;
        this.include_subs.setSelected(this.options.includesubpackages);
        this.packages.removeEntries();
        for (i = 0; i < this.options.files.size(); ++i) {
            this.packages.addEntry((String)this.options.files.get(i));
        }
        for (i = 0; i < this.options.packages.size(); ++i) {
            this.packages.addEntry((String)this.options.packages.get(i));
        }
        this.sourcepaths.removeEntries();
        for (i = 0; i < this.options.sourcepath.size(); ++i) {
            this.sourcepaths.addEntry((String)this.options.sourcepath.get(i));
        }
        this.classpaths.removeEntries();
        for (i = 0; i < this.options.classpath.size(); ++i) {
            this.classpaths.addEntry((String)this.options.classpath.get(i));
        }
        this.links.removeEntries();
        for (i = 0; i < this.options.links.size(); ++i) {
            this.links.addEntry((String)this.options.links.get(i));
        }
        this.output_dir.setText(this.options.destdirname);
        this.gentreecb.setSelected(this.options.createtree);
        this.gennavcb.setSelected(!this.options.nonavbar);
        this.genindexcb.setSelected(this.options.createindex);
        this.gensplitindexcb.setSelected(this.options.splitindex);
        this.output_dir.setText(this.options.destdirname);
        this.overviewcb.setSelected(this.options.overview);
        this.overviewtf.setText(this.options.overviewfile);
        this.doctitlecb.setSelected(this.options.createdoctitle);
        this.doctitletf.setText(this.options.doctitle);
        this.generatejavadoc.setSelected(this.options.javadoc);
        this.generatejadexdoc.setSelected(this.options.jadexdoc);
        this.javadocloctf.setText(this.options.javadocloc);
        this.javaloctf.setText(this.options.javaloc);
        this.extraoptionsjavadoctf.setText(this.options.extraoptionsjavadoc);
        this.extraoptionsjadexdoctf.setText(this.options.extraoptionsjadexdoc);
        if (this.genindexcb.isSelected()) {
            this.gensplitindexcb.setEnabled(true);
        } else {
            this.gensplitindexcb.setEnabled(false);
        }
    }

    protected void updateModel() {
        this.options.packages.clear();
        this.options.files.clear();
        String[] paths = this.packages.getEntries();
        for (int i = 0; i < paths.length; ++i) {
            if (SXML.isJadexFilename((String)paths[i]) || paths[i].toLowerCase().endsWith(".java")) {
                this.options.files.add(paths[i]);
                continue;
            }
            this.options.packages.add(paths[i]);
        }
        this.options.includesubpackages = this.include_subs.isSelected();
        this.options.destdirname = this.output_dir.getText();
        this.options.overview = this.overviewcb.isSelected();
        this.options.overviewfile = this.overviewtf.getText();
        this.options.createdoctitle = this.doctitlecb.isSelected();
        this.options.doctitle = this.doctitletf.getText();
        this.options.createtree = this.gentreecb.isSelected();
        this.options.nonavbar = !this.gennavcb.isSelected();
        this.options.createindex = this.genindexcb.isSelected();
        this.options.splitindex = this.gensplitindexcb.isSelected();
        this.options.extraoptionsjavadoc = this.extraoptionsjavadoctf.getText();
        this.options.extraoptionsjadexdoc = this.extraoptionsjadexdoctf.getText();
        this.options.javadoc = this.generatejavadoc.isSelected();
        this.options.jadexdoc = this.generatejadexdoc.isSelected();
        this.options.javadocloc = this.javadocloctf.getText();
        this.options.javaloc = this.javaloctf.getText();
        this.options.sourcepath.clear();
        String[] sps = this.sourcepaths.getEntries();
        for (int i = 0; i < sps.length; ++i) {
            this.options.sourcepath.add(sps[i]);
        }
        this.options.classpath.clear();
        String[] cps = this.classpaths.getEntries();
        for (int i = 0; i < cps.length; ++i) {
            this.options.classpath.add(cps[i]);
        }
        this.options.links.clear();
        String[] lks = this.links.getEntries();
        for (int i = 0; i < lks.length; ++i) {
            this.options.links.add(lks[i]);
        }
    }

    public void generate() {
        this.updateModel();
        Thread gen = new Thread(new Runnable(){

            public void run() {
                boolean success = true;
                boolean toshow = true;
                boolean toactivate = true;
                if (JadexdocPanel.this.plugin != null) {
                    boolean bl = toshow = !JadexdocPanel.this.plugin.getJCC().isConsoleShown();
                    if (toshow) {
                        JadexdocPanel.this.plugin.getJCC().showConsole(true);
                    }
                    boolean bl2 = toactivate = !JadexdocPanel.this.plugin.getJCC().isConsoleEnabled();
                    if (toactivate) {
                        JadexdocPanel.this.plugin.getJCC().setConsoleEnabled(true);
                    }
                }
                GenerateOptions javaoptions = (GenerateOptions)JadexdocPanel.this.options.clone();
                GenerateOptions jadexoptions = (GenerateOptions)JadexdocPanel.this.options.clone();
                javaoptions.destdirname = javaoptions.destdirname + File.separatorChar + "javaapi";
                try {
                    String javadest = "" + new File(javaoptions.destdirname).toURI().toURL();
                    if (jadexoptions.javadoc) {
                        jadexoptions.links.add("" + javadest);
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                try {
                    if (!JadexdocPanel.this.abort && JadexdocPanel.this.options.javadoc) {
                        JadexdocPanel.this.generateJavadoc(javaoptions);
                    }
                }
                catch (Exception e) {
                    success = false;
                    SGUI.showMessageDialog((Component)SGUI.getWindowParent((Component)JadexdocPanel.this), (Object)SUtil.wrapText((String)e.getMessage()), (String)"Javadoc Error", (int)1);
                }
                try {
                    if (!JadexdocPanel.this.abort && JadexdocPanel.this.options.jadexdoc) {
                        JadexdocPanel.this.generateJadexdoc(jadexoptions);
                    }
                }
                catch (Exception e) {
                    success = false;
                    SGUI.showMessageDialog((Component)SGUI.getWindowParent((Component)JadexdocPanel.this), (Object)SUtil.wrapText((String)e.getMessage()), (String)"Jadexdoc Error", (int)1);
                }
                JadexdocPanel.this.running = false;
                JadexdocPanel.this.abort = false;
                JadexdocPanel.this.startbut.setText("Start");
                JadexdocPanel.this.startbut.setToolTipText("Start the documentation generation");
                if (JadexdocPanel.this.plugin != null) {
                    if (success && toshow) {
                        JadexdocPanel.this.plugin.getJCC().showConsole(false);
                    }
                    if (toactivate) {
                        JadexdocPanel.this.plugin.getJCC().setConsoleEnabled(false);
                    }
                }
            }
        });
        gen.start();
    }

    public void setOptions(GenerateOptions options) {
        this.options = options;
        this.updateView();
    }

    public GenerateOptions getOptions() {
        this.updateModel();
        return this.options;
    }

    public void addEntry(String entry) {
        this.lists.setSelectedIndex(0);
        this.packages.addEntry(entry);
    }

    public void removeEntry(String entry) {
        this.packages.removeEntry(entry);
    }

    public boolean containsEntry(String entry) {
        return this.packages.containsEntry(entry);
    }

    public void setProperties(Properties props) {
        this.setOptions(GenerateOptions.create(props));
        if (props.getProperty("listssplit.location") != null) {
            int msdl = Integer.parseInt(props.getProperty("listssplit.location"));
            this.center.setDividerLocation(msdl);
        }
    }

    public void getProperties(Properties props) {
        props.putAll((Map<?, ?>)this.getOptions().toProperties());
        props.put("listssplit.location", Integer.toString(this.center.getDividerLocation()));
    }

    public void generateJavadoc(GenerateOptions options) {
        if (options.packages.size() == 0 && options.files.size() == 0) {
            throw new RuntimeException("No sources selected for documentation, documentation impossible");
        }
        JLabel run = new JLabel(icons.getIcon("running_javadoc"));
        this.plugin.getJCC().addStatusComponent(this, run);
        try {
            String cmd = options.javadocloc == null || options.javadocloc.length() == 0 ? "javadoc" : options.javadocloc;
            String[] cmds = options.toCommandLineString(true);
            String cmdline = "";
            for (int i = 0; i < cmds.length; ++i) {
                cmdline = cmdline + " " + cmds[i];
            }
            File newcurdir = new File(options.destdirname);
            newcurdir.mkdirs();
            Process proc = Runtime.getRuntime().exec(cmd + " " + cmdline, null, newcurdir);
            new Thread((Runnable)new StreamCopy(proc.getInputStream(), (OutputStream)System.out)).start();
            new Thread((Runnable)new StreamCopy(proc.getErrorStream(), (OutputStream)System.out)).start();
            boolean finished = false;
            while (!finished && !this.abort) {
                try {
                    Thread.sleep(300L);
                    if (proc.exitValue() != 0) {
                        throw new RuntimeException("Javadoc returned an error or could not be invoked.");
                    }
                    finished = true;
                }
                catch (IllegalThreadStateException ie) {
                    if (!this.abort) continue;
                    proc.destroy();
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not process Javadoc. Reason: " + ex.getMessage());
        }
        this.plugin.getJCC().removeStatusComponent(this);
    }

    public void generateJadexdoc(GenerateOptions options) {
        JLabel run = new JLabel(icons.getIcon("running_jadexdoc"));
        this.plugin.getJCC().addStatusComponent(this, run);
        try {
            String cmd = options.javaloc == null || options.javaloc.length() == 0 ? "java" : options.javaloc;
            List cps = this.fetchClasspath();
            for (int i = 0; i < cps.size(); ++i) {
                cmd = i == 0 ? cmd + " -cp " : cmd + File.pathSeparator;
                cmd = cmd + "\"" + cps.get(i) + "\"";
            }
            cmd = cmd + " jadex.tools.jadexdoc.Main";
            String[] cmds = options.toCommandLineString(false);
            String cmdline = "";
            for (int i = 0; i < cmds.length; ++i) {
                cmdline = cmdline + " " + cmds[i];
            }
            File newcurdir = new File(options.destdirname);
            newcurdir.mkdirs();
            Process proc = Runtime.getRuntime().exec(cmd + " " + cmdline, null, newcurdir);
            new Thread((Runnable)new StreamCopy(proc.getInputStream(), (OutputStream)System.out)).start();
            new Thread((Runnable)new StreamCopy(proc.getErrorStream(), (OutputStream)System.out)).start();
            boolean finished = false;
            while (!finished && !this.abort) {
                try {
                    Thread.sleep(300L);
                    if (proc.exitValue() != 0) {
                        throw new RuntimeException("Jadexdoc returned an error or could not be invoked.");
                    }
                    finished = true;
                }
                catch (IllegalThreadStateException ie) {
                    if (!this.abort) continue;
                    proc.destroy();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process Jadexdoc. Reason: " + e.getMessage());
        }
        this.plugin.getJCC().removeStatusComponent(this);
    }

    protected List fetchClasspath() {
        ArrayList<String> entries = new ArrayList<String>();
        ClassLoader cl = DynamicURLClassLoader.getInstance();
        if (!(cl instanceof DynamicURLClassLoader)) {
            throw new RuntimeException("No URLClassLoader found");
        }
        List cps = ((DynamicURLClassLoader)cl).getAllClasspathURLs();
        for (int i = 0; i < cps.size(); ++i) {
            File newfile;
            URL url = (URL)cps.get(i);
            String file = url.getFile();
            File f = new File(file);
            if (!f.exists() && (newfile = new File(new File("."), file)).exists()) {
                f = newfile;
            }
            entries.add(f.getAbsolutePath());
        }
        return entries;
    }

    public static void openDocInBrowser(GenerateOptions options) {
        try {
            String path = new File(options.destdirname).getCanonicalPath();
            BrowserLauncher.openURL((String)("file:///" + path + "/index.html"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        GenerateOptions go = new GenerateOptions();
        go.destdirname = "c:/projects/test4711";
        go.packages.add("jadex.examples.blackjack");
        final String file = args.length == 0 ? "./jadexdoc.properties" : args[0];
        try {
            FileInputStream fis = new FileInputStream(file);
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            go = GenerateOptions.create(props);
        }
        catch (Exception e) {
            System.out.println("Failed to load properties from: " + file);
        }
        final JadexdocPanel jp = new JadexdocPanel(null, go);
        final JFrame f = new JFrame();
        f.add("Center", jp);
        f.pack();
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    Properties props = jp.getOptions().toProperties();
                    props.store(fos, null);
                    fos.close();
                    System.out.println("Saved properties in: " + file);
                }
                catch (Exception e) {
                    System.out.println("Failed to save properties in: " + file);
                }
                f.dispose();
            }
        });
    }

    static class MethodInvocation
    implements Runnable {
        protected Method exe;
        protected Object[] args;
        public Boolean success;

        public MethodInvocation(Method exe, Object[] args) {
            this.exe = exe;
            this.args = args;
        }

        public void run() {
            try {
                this.success = (Integer)this.exe.invoke(null, this.args) != 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

