/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.model.SXML;
import jadex.util.SUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class GenerateOptions
implements Cloneable {
    public static final String SEPARATOR = ",";
    public static final String PREPEND = "doc.";
    public static final String INCLUDESUBPACKAGES = "includesubpackages";
    public static final String PACKAGES = "packages";
    public static final String FILES = "files";
    public static final String SPLITINDEX = "splitindex";
    public static final String CREATEINDEX = "createindex";
    public static final String CREATETREE = "createtree";
    public static final String NONAVBAR = "nonavbar";
    public static final String OVERVIEW = "overview";
    public static final String OVERVIEWFILE = "overviewfile";
    public static final String DESTDIRNAME = "destdirname";
    public static final String CREATEDOCTITLE = "createdoctitle";
    public static final String DOCTITLE = "doctitle";
    public static final String EXTRAOPTIONSJAVADOC = "extraoptionsjavadoc";
    public static final String EXTRAOPTIONSJADEXDOC = "extraoptionsjadexdoc";
    public static final String JAVADOC = "javadoc";
    public static final String JADEXDOC = "jadexdoc";
    public static final String JAVADOCLOC = "javadocloc";
    public static final String JAVALOC = "javaloc";
    public static final String OPENBROWSER = "openbroswer";
    public static final String LINKS = "links";
    public static final String SOURCEPATH = "sourcepath";
    public static final String CLASSPATH = "classpath";
    public boolean includesubpackages = true;
    public List packages = new ArrayList();
    public List files = new ArrayList();
    public boolean splitindex = false;
    public boolean createindex = true;
    public boolean createtree = true;
    public boolean nonavbar = false;
    public boolean overview = false;
    public String overviewfile = null;
    public String destdirname = ".";
    public boolean createdoctitle = false;
    public String doctitle;
    public String extraoptionsjavadoc;
    public String extraoptionsjadexdoc;
    public boolean jadexdoc = true;
    public boolean javadoc = true;
    public String javadocloc;
    public String javaloc;
    public List links = new ArrayList();
    public List sourcepath = new ArrayList();
    public List classpath = new ArrayList();

    public static GenerateOptions create(Properties props) {
        GenerateOptions ret = new GenerateOptions();
        String[] keys = props.keySet().toArray(new String[props.size()]);
        for (int i = 0; i < keys.length; ++i) {
            StringTokenizer stok;
            if (keys[i].equals("doc.includesubpackages")) {
                ret.includesubpackages = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.packages")) {
                stok = new StringTokenizer(props.getProperty(keys[i]), SEPARATOR);
                while (stok.hasMoreTokens()) {
                    ret.packages.add(stok.nextToken());
                }
                continue;
            }
            if (keys[i].equals("doc.files")) {
                stok = new StringTokenizer(props.getProperty(keys[i]), SEPARATOR);
                while (stok.hasMoreTokens()) {
                    ret.files.add(stok.nextToken());
                }
                continue;
            }
            if (keys[i].equals("doc.splitindex")) {
                ret.splitindex = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.createindex")) {
                ret.createindex = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.createtree")) {
                ret.createtree = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.nonavbar")) {
                ret.nonavbar = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.overview")) {
                ret.overview = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.overviewfile")) {
                ret.overviewfile = props.getProperty(keys[i]);
                continue;
            }
            if (keys[i].equals("doc.destdirname")) {
                ret.destdirname = props.getProperty(keys[i]);
                continue;
            }
            if (keys[i].equals("doc.createdoctitle")) {
                ret.createdoctitle = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.doctitle")) {
                ret.doctitle = props.getProperty(keys[i]);
                continue;
            }
            if (keys[i].equals("doc.extraoptionsjavadoc")) {
                ret.extraoptionsjavadoc = props.getProperty(keys[i]);
                continue;
            }
            if (keys[i].equals("doc.extraoptionsjadexdoc")) {
                ret.extraoptionsjadexdoc = props.getProperty(keys[i]);
                continue;
            }
            if (keys[i].equals("doc.jadexdoc")) {
                ret.jadexdoc = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.javadoc")) {
                ret.javadoc = new Boolean(props.getProperty(keys[i]));
                continue;
            }
            if (keys[i].equals("doc.javadocloc")) {
                ret.javadocloc = props.getProperty(keys[i]);
                continue;
            }
            if (keys[i].equals("doc.javaloc")) {
                ret.javaloc = props.getProperty(keys[i]);
                continue;
            }
            if (keys[i].equals("doc.links")) {
                stok = new StringTokenizer(props.getProperty(keys[i]), SEPARATOR);
                while (stok.hasMoreTokens()) {
                    ret.links.add(stok.nextToken());
                }
                continue;
            }
            if (keys[i].equals("doc.sourcepath")) {
                stok = new StringTokenizer(props.getProperty(keys[i]), SEPARATOR);
                while (stok.hasMoreTokens()) {
                    ret.sourcepath.add(stok.nextToken());
                }
                continue;
            }
            if (!keys[i].equals("doc.classpath")) continue;
            stok = new StringTokenizer(props.getProperty(keys[i]), SEPARATOR);
            while (stok.hasMoreTokens()) {
                ret.classpath.add(stok.nextToken());
            }
        }
        return ret;
    }

    public Properties toProperties() {
        int i;
        String tmp;
        Properties ret = new Properties();
        ret.setProperty("doc.includesubpackages", "" + this.includesubpackages);
        if (this.packages.size() > 0) {
            tmp = "";
            for (i = 0; i < this.packages.size(); ++i) {
                tmp = tmp + this.packages.get(i);
                if (i + 1 >= this.packages.size()) continue;
                tmp = tmp + SEPARATOR;
            }
            ret.setProperty("doc.packages", tmp);
        }
        if (this.files.size() > 0) {
            tmp = "";
            for (i = 0; i < this.files.size(); ++i) {
                tmp = tmp + this.files.get(i);
                if (i + 1 >= this.files.size()) continue;
                tmp = tmp + SEPARATOR;
            }
            ret.setProperty("doc.files", tmp);
        }
        ret.setProperty("doc.splitindex", "" + this.splitindex);
        ret.setProperty("doc.createindex", "" + this.createindex);
        ret.setProperty("doc.createtree", "" + this.createtree);
        ret.setProperty("doc.nonavbar", "" + this.nonavbar);
        ret.setProperty("doc.overview", "" + this.overview);
        if (this.overviewfile != null) {
            ret.setProperty("doc.overviewfile", this.overviewfile);
        }
        if (this.destdirname != null) {
            ret.setProperty("doc.destdirname", this.destdirname);
        }
        ret.setProperty("doc.createdoctitle", "" + this.createdoctitle);
        if (this.doctitle != null) {
            ret.setProperty("doc.doctitle", this.doctitle);
        }
        if (this.extraoptionsjavadoc != null) {
            ret.setProperty("doc.extraoptionsjavadoc", this.extraoptionsjavadoc);
        }
        if (this.extraoptionsjadexdoc != null) {
            ret.setProperty("doc.extraoptionsjadexdoc", this.extraoptionsjadexdoc);
        }
        ret.setProperty("doc.jadexdoc", "" + this.jadexdoc);
        ret.setProperty("doc.javadoc", "" + this.javadoc);
        if (this.javadocloc != null) {
            ret.setProperty("doc.javadocloc", this.javadocloc);
        }
        if (this.javaloc != null) {
            ret.setProperty("doc.javaloc", this.javaloc);
        }
        if (this.links.size() > 0) {
            tmp = "";
            for (i = 0; i < this.links.size(); ++i) {
                tmp = tmp + this.links.get(i);
                if (i + 1 >= this.links.size()) continue;
                tmp = tmp + SEPARATOR;
            }
            ret.setProperty("doc.links", tmp);
        }
        if (this.sourcepath.size() > 0) {
            tmp = "";
            for (i = 0; i < this.sourcepath.size(); ++i) {
                tmp = tmp + this.sourcepath.get(i);
                if (i + 1 >= this.sourcepath.size()) continue;
                tmp = tmp + SEPARATOR;
            }
            ret.setProperty("doc.sourcepath", tmp);
        }
        if (this.classpath.size() > 0) {
            tmp = "";
            for (i = 0; i < this.classpath.size(); ++i) {
                tmp = tmp + this.classpath.get(i);
                if (i + 1 >= this.classpath.size()) continue;
                tmp = tmp + SEPARATOR;
            }
            ret.setProperty("doc.classpath", tmp);
        }
        return ret;
    }

    public String[] toCommandLineString(boolean genjavadoc) {
        int i;
        int i2;
        ArrayList<String> ret = new ArrayList<String>();
        for (i2 = 0; i2 < this.files.size(); ++i2) {
            if (!genjavadoc && SXML.isJadexFilename((String)((String)this.files.get(i2)))) {
                ret.add("\"" + this.adaptRelativeEntry((String)this.files.get(i2)) + "\"");
                continue;
            }
            if (!genjavadoc || SXML.isJadexFilename((String)((String)this.files.get(i2)))) continue;
            ret.add("\"" + this.adaptRelativeEntry((String)this.files.get(i2)) + "\"");
        }
        if (this.includesubpackages && this.packages.size() > 0) {
            ret.add("-subpackages");
        }
        for (i2 = 0; i2 < this.packages.size(); ++i2) {
            ret.add("\"" + this.adaptRelativeEntry((String)this.packages.get(i2)) + "\"");
        }
        if (this.sourcepath.size() > 0) {
            ret.add("-sourcepath");
            String sp = "";
            for (i = 0; i < this.sourcepath.size(); ++i) {
                sp = sp + "\"" + this.adaptRelativeEntry((String)this.sourcepath.get(i)) + "\"";
                if (i + 1 >= this.sourcepath.size()) continue;
                sp = sp + File.pathSeparator;
            }
            ret.add(sp);
        }
        if (this.classpath.size() > 0) {
            ret.add("-classpath");
            String cp = "";
            for (i = 0; i < this.classpath.size(); ++i) {
                cp = cp + "\"" + this.adaptRelativeEntry((String)this.classpath.get(i)) + "\"";
                if (i + 1 >= this.classpath.size()) continue;
                cp = cp + File.pathSeparator;
            }
            ret.add(cp);
        }
        if (this.overview) {
            ret.add("-overview");
            ret.add("\"" + this.adaptRelativeEntry(this.overviewfile) + "\"");
        }
        if (this.createdoctitle) {
            ret.add("-doctitle");
            ret.add(this.doctitle);
        }
        if (!this.createtree) {
            ret.add("-notree");
        }
        if (this.nonavbar) {
            ret.add("-nonavbar");
        }
        if (this.createindex) {
            if (this.splitindex) {
                ret.add("-splitindex");
            }
        } else {
            ret.add("-noindex");
        }
        for (int i3 = 0; i3 < this.links.size(); ++i3) {
            ret.add("-link");
            ret.add("\"" + this.adaptRelativeEntry((String)this.links.get(i3)) + "\"");
        }
        if (this.extraoptionsjavadoc != null && genjavadoc) {
            StringTokenizer stok = new StringTokenizer(this.extraoptionsjavadoc, " ");
            while (stok.hasMoreTokens()) {
                ret.add(stok.nextToken());
            }
        }
        if (this.extraoptionsjadexdoc != null && !genjavadoc) {
            StringTokenizer stok = new StringTokenizer(this.extraoptionsjadexdoc, " ");
            while (stok.hasMoreTokens()) {
                ret.add(stok.nextToken());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public List getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List classpath) {
        this.classpath = classpath;
    }

    public boolean isCreatedoctitle() {
        return this.createdoctitle;
    }

    public void setCreatedoctitle(boolean createdoctitle) {
        this.createdoctitle = createdoctitle;
    }

    public boolean isCreateindex() {
        return this.createindex;
    }

    public void setCreateindex(boolean createindex) {
        this.createindex = createindex;
    }

    public boolean isCreatetree() {
        return this.createtree;
    }

    public void setCreatetree(boolean createtree) {
        this.createtree = createtree;
    }

    public String getDestdirname() {
        return this.destdirname;
    }

    public void setDestdirname(String destdirname) {
        this.destdirname = destdirname;
    }

    public String getDoctitle() {
        return this.doctitle;
    }

    public void setDoctitle(String doctitle) {
        this.doctitle = doctitle;
    }

    public String getExtraoptionsJavadoc() {
        return this.extraoptionsjavadoc;
    }

    public void setExtraoptionsJavadoc(String extraoptionsjavadoc) {
        this.extraoptionsjavadoc = extraoptionsjavadoc;
    }

    public String getExtraoptionsJadexdoc() {
        return this.extraoptionsjadexdoc;
    }

    public void setExtraoptionsJadexdoc(String extraoptionsJadexdoc) {
        this.extraoptionsjadexdoc = this.extraoptionsjadexdoc;
    }

    public List getFiles() {
        return this.files;
    }

    public void setFiles(List files) {
        this.files = files;
    }

    public boolean isIncludesubpackages() {
        return this.includesubpackages;
    }

    public void setIncludesubpackages(boolean includesubpackages) {
        this.includesubpackages = includesubpackages;
    }

    public boolean isJadexdoc() {
        return this.jadexdoc;
    }

    public void setJadexdoc(boolean jadexdoc) {
        this.jadexdoc = jadexdoc;
    }

    public boolean isJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(boolean javadoc) {
        this.javadoc = javadoc;
    }

    public String getJavadocloc() {
        return this.javadocloc;
    }

    public void setJavadocloc(String javadocloc) {
        this.javadocloc = javadocloc;
    }

    public String getJavaloc() {
        return this.javaloc;
    }

    public void setJavaloc(String javaloc) {
        this.javaloc = javaloc;
    }

    public List getLinks() {
        return this.links;
    }

    public void setLinks(List links) {
        this.links = links;
    }

    public boolean isNonavbar() {
        return this.nonavbar;
    }

    public void setNonavbar(boolean nonavbar) {
        this.nonavbar = nonavbar;
    }

    public boolean isOverview() {
        return this.overview;
    }

    public void setOverview(boolean overview) {
        this.overview = overview;
    }

    public String getOverviewfile() {
        return this.overviewfile;
    }

    public void setOverviewfile(String overviewfile) {
        this.overviewfile = overviewfile;
    }

    public List getPackages() {
        return this.packages;
    }

    public void setPackages(List packages) {
        this.packages = packages;
    }

    public List getSourcepath() {
        return this.sourcepath;
    }

    public void setSourcepath(List sourcepath) {
        this.sourcepath = sourcepath;
    }

    public boolean isSplitindex() {
        return this.splitindex;
    }

    public void setSplitindex(boolean splitindex) {
        this.splitindex = splitindex;
    }

    public Object clone() {
        GenerateOptions ret = null;
        try {
            ret = (GenerateOptions)super.clone();
            ret.files = (ArrayList)((ArrayList)this.files).clone();
            ret.packages = (ArrayList)((ArrayList)this.packages).clone();
            ret.links = (ArrayList)((ArrayList)this.links).clone();
            ret.sourcepath = (ArrayList)((ArrayList)this.sourcepath).clone();
            ret.classpath = (ArrayList)((ArrayList)this.classpath).clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String adaptRelativeEntry(String entry) {
        return this.destdirname.equals(".") ? entry : GenerateOptions.adaptRelativeEntry(entry, this.destdirname);
    }

    public static String adaptRelativeEntry(String entry, String destdir) {
        String ret = entry;
        File file = new File(entry);
        if (file.exists() && !file.isAbsolute()) {
            File curdir = new File(".");
            File dest = new File(destdir);
            String rel = SUtil.getRelativePath((String)dest.getAbsolutePath(), (String)curdir.getAbsolutePath());
            ret = rel + file.getPath();
            System.out.println("Adapted file from: " + entry + " " + ret);
        }
        return ret;
    }
}

