/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.tools.jadexdoc.doclets.IJadexDoclet;
import jadex.tools.jadexdoc.doclets.MessageRetriever;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.StringTokenizer;

public class DocletInvoker {
    private final Class docletClass;
    private final ClassLoader appClassLoader;
    private final MessageRetriever messager;
    private final IJadexDoclet doclet;

    public DocletInvoker(MessageRetriever messager, String docletClassName, String docletPath) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.messager = messager;
        String cpString = null;
        cpString = this.appendPath(System.getProperty("env.class.path"), cpString);
        cpString = this.appendPath(System.getProperty("java.class.path"), cpString);
        cpString = this.appendPath(docletPath, cpString);
        URL[] urls = DocletInvoker.pathToURLs(cpString);
        this.appClassLoader = new URLClassLoader(urls);
        this.docletClass = this.appClassLoader.loadClass(docletClassName);
        this.doclet = (IJadexDoclet)this.docletClass.newInstance();
    }

    public boolean start() {
        return this.doclet.start();
    }

    public int optionLength(String option) {
        return this.doclet.getConfiguration().getOptionLength(option);
    }

    public boolean validOptions(List optlist) {
        return this.doclet.getConfiguration().validOptions(optlist);
    }

    public void setOptions(List options) {
        this.doclet.getConfiguration().setOptions(options);
    }

    public void setAgents(List agents) {
        this.doclet.getConfiguration().setAgents(agents);
    }

    public void setPackages(List packages) {
        this.doclet.getConfiguration().setPackages(packages);
    }

    static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = DocletInvoker.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    private String appendPath(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            return path2 == null ? "." : path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        return path1 + File.pathSeparator + path2;
    }

    public class DocletInvokeException
    extends Exception {
    }
}

