/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.model.IMCapability;
import jadex.tools.jadexdoc.Messager;
import jadex.tools.jadexdoc.doclets.MessageRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Configuration {
    public static final int DEFAULT_TAB_STOP_LENGTH = 8;
    public static final String SOURCE_OUTPUT_DIR_NAME = "src-html/";
    public int linksourcetab = 8;
    public boolean genSrc = false;
    public boolean nosince = false;
    public boolean copydocfilesubdirs = false;
    public String charset = "";
    protected Set excludedDocFileDirs;
    protected Set excludedQualifiers;
    public String destdirname = "";
    public String docencoding = null;
    public String encoding = null;
    public boolean showauthor = false;
    public boolean showversion = false;
    public boolean nodate = false;
    public String sourcepath = "";
    public boolean nodeprecated = false;
    public boolean exported = false;
    public boolean expressions = true;
    public boolean events = true;
    public boolean standardmembers = false;
    public List cmdLineAgents;
    public List cmdLinePackages;
    public List options;
    public MessageRetriever message = new MessageRetriever(Messager.getInstance(), "jadex.tools.jadexdoc.doclets.resources.doclets");
    private static final String DOCLET_RESOURCE_LOCATION = "jadex.tools.jadexdoc.doclets.resources.doclets";

    public abstract int getDocletOptionLength(String var1);

    public abstract boolean validDocletOptions(List var1);

    public abstract void setDocletOptions(List var1);

    public Configuration() {
        this.excludedDocFileDirs = new HashSet();
        this.excludedQualifiers = new HashSet();
    }

    public void setOptions(List optlist) {
        String[][] options = (String[][])optlist.toArray((T[])new String[optlist.size()][]);
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-d")) {
                this.destdirname = this.addTrailingFileSep(os[1]);
                continue;
            }
            if (opt.equals("-docfilessubdirs")) {
                this.copydocfilesubdirs = true;
                continue;
            }
            if (opt.equals("-docencoding")) {
                this.docencoding = os[1];
                continue;
            }
            if (opt.equals("-encoding")) {
                this.encoding = os[1];
                continue;
            }
            if (opt.equals("-author")) {
                this.showauthor = true;
                continue;
            }
            if (opt.equals("-version")) {
                this.showversion = true;
                continue;
            }
            if (opt.equals("-exported")) {
                this.exported = true;
                continue;
            }
            if (opt.equals("-expressions")) {
                this.expressions = true;
                continue;
            }
            if (opt.equals("-events")) {
                this.events = true;
                continue;
            }
            if (opt.equals("-standardmembers")) {
                this.standardmembers = true;
                continue;
            }
            if (opt.equals("-nodeprecated")) {
                this.nodeprecated = true;
                continue;
            }
            if (opt.equals("-xnodate")) {
                this.nodate = true;
                continue;
            }
            if (opt.equals("-sourcepath")) {
                this.sourcepath = os[1];
                continue;
            }
            if (opt.equals("-classpath") && this.sourcepath.length() == 0) {
                this.sourcepath = os[1];
                continue;
            }
            if (opt.equals("-excludedocfilessubdir")) {
                this.addToSet(this.excludedDocFileDirs, os[1]);
                continue;
            }
            if (opt.equals("-noqualifier")) {
                this.addToSet(this.excludedQualifiers, os[1]);
                continue;
            }
            if (opt.equals("-linksource")) {
                this.genSrc = true;
                continue;
            }
            if (!opt.equals("-linksourcetab")) continue;
            this.genSrc = true;
            try {
                this.linksourcetab = Integer.parseInt(os[1]);
            }
            catch (NumberFormatException e) {
                this.linksourcetab = -1;
            }
            if (this.linksourcetab > 0) continue;
            this.message.warning("doclet.linksourcetab_warning");
            this.linksourcetab = 8;
        }
        if (this.sourcepath.length() == 0) {
            this.sourcepath = System.getProperty("env.class.path");
        }
        if (this.docencoding == null) {
            this.docencoding = this.encoding;
        }
        this.setDocletOptions(optlist);
    }

    protected void addToSet(Set s, String str) {
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            s.add(current);
        }
    }

    String addTrailingFileSep(String path) {
        int indexDblfs;
        String fs = System.getProperty("file.separator");
        String dblfs = fs + fs;
        while ((indexDblfs = path.indexOf(dblfs)) >= 0) {
            path = path.substring(0, indexDblfs) + path.substring(indexDblfs + fs.length());
        }
        if (!path.endsWith(fs)) {
            path = path + fs;
        }
        return path;
    }

    public int getOptionLength(String option) {
        if ((option = option.toLowerCase()).equals("-docfilessubdirs") || option.equals("-linksource") || option.equals("-version") || option.equals("-nodeprecated") || option.equals("-exported") || option.equals("-expressions") || option.equals("-events") || option.equals("-standardmembers") || option.equals("-author") || option.equals("-xnodate")) {
            return 1;
        }
        if (option.equals("-docencoding") || option.equals("-encoding") || option.equals("-excludedocfilessubdir") || option.equals("-noqualifier") || option.equals("-sourcepath") || option.equals("-classpath") || option.equals("-d")) {
            return 2;
        }
        return this.getDocletOptionLength(option);
    }

    public boolean validOptions(List optlist) {
        String[][] options = (String[][])optlist.toArray((T[])new String[optlist.size()][]);
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (!opt.equals("-d")) continue;
            String destdirname = this.addTrailingFileSep(os[1]);
            File destDir = new File(destdirname);
            if (!destDir.exists()) {
                new File(destdirname).mkdirs();
                continue;
            }
            if (!destDir.isDirectory()) {
                this.message.error("doclet.destination_directory_not_directory_0", destDir.getPath());
                return false;
            }
            if (destDir.canWrite()) continue;
            this.message.error("doclet.destination_directory_not_writable_0", destDir.getPath());
            return false;
        }
        return this.validDocletOptions(optlist);
    }

    public boolean shouldExcludeDocFileDir(String docfilesubdir) {
        return this.excludedDocFileDirs.contains(docfilesubdir);
    }

    public boolean shouldExcludeQualifier(String qualifier) {
        if (this.excludedQualifiers.contains("all") || this.excludedQualifiers.contains(qualifier)) {
            return true;
        }
        int index = -1;
        while ((index = qualifier.indexOf(".", index + 1)) != -1) {
            if (!this.excludedQualifiers.contains(qualifier.substring(0, index + 1) + "*")) continue;
            return true;
        }
        return false;
    }

    public String[][] options() {
        return (String[][])this.options.toArray((T[])new String[this.options.size()][]);
    }

    public void setPackages(List packages) {
        this.cmdLinePackages = packages;
    }

    public String[] specifiedPackages() {
        return this.cmdLinePackages.toArray(new String[this.cmdLinePackages.size()]);
    }

    public void setAgents(List agents) {
        this.cmdLineAgents = agents;
    }

    public IMCapability[] getSpecifiedAgents() {
        return this.cmdLineAgents.toArray(new IMCapability[this.cmdLineAgents.size()]);
    }

    public List getAgentsForPackage(String pkgname) {
        IMCapability[] arr = this.getSpecifiedAgents();
        ArrayList<IMCapability> agents = new ArrayList<IMCapability>();
        for (int i = 0; i < arr.length; ++i) {
            String agentpackage;
            IMCapability agent = arr[i];
            String string = agentpackage = agent.getPackage() == null ? "" : agent.getPackage();
            if (!agentpackage.equals(pkgname)) continue;
            agents.add(agent);
        }
        return agents;
    }

    public boolean isIncluded(IMCapability cd) {
        boolean isIncluded = false;
        IMCapability[] arr = this.getSpecifiedAgents();
        for (int i = 0; i < arr.length; ++i) {
            IMCapability capability = arr[i];
            if (!this.getQualifiedAgentName(capability).equals(this.getQualifiedAgentName(cd))) continue;
            isIncluded = true;
        }
        return isIncluded;
    }

    public String getAgentName(IMCapability agent) {
        String pd = agent.getPackage();
        if (pd != null && this.shouldExcludeQualifier(pd)) {
            return agent.getName();
        }
        return this.getQualifiedAgentName(agent);
    }

    public String getQualifiedAgentName(IMCapability agent) {
        String pck = agent.getPackage();
        if (pck != null && pck.length() > 0) {
            return agent.getPackage() + "." + agent.getName();
        }
        return agent.getName();
    }

    public String getClassName(Class cd) {
        if (cd == null) {
            return "";
        }
        Package pd = cd.getPackage();
        String cl = cd.getName();
        if (cl.lastIndexOf(46) != -1) {
            cl = cl.substring(cl.lastIndexOf(46) + 1, cl.length());
        }
        if (pd != null && this.shouldExcludeQualifier(pd.getName())) {
            return cl;
        }
        return cd.getName();
    }
}

