/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.jadexdoc;

import jadex.model.IMElement;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;

public class Comment {
    private String text;
    private final BreakIterator sentenceBreaker;

    public Comment(String commentString) {
        this.text = commentString;
        this.sentenceBreaker = BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public Comment(IMElement element) {
        this(element.getDescription());
    }

    public String getCommentText() {
        return this.text;
    }

    public String getFirstSentence() {
        return this.getFirstSentence(this.text);
    }

    private String getFirstSentence(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        int index = s.indexOf("-->");
        if (s.trim().startsWith("<!--") && index != -1) {
            return this.getFirstSentence(s.substring(index + 3, s.length()));
        }
        this.sentenceBreaker.setText(s.replace('\n', ' '));
        int start = this.sentenceBreaker.first();
        int end = this.sentenceBreaker.next();
        String result = s.substring(start, end);
        StringBuffer res = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(result, "<>", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            if (tok.equals("<")) {
                tok = stok.nextToken();
                if (Character.isWhitespace(tok.charAt(0)) || tok.equals(">")) {
                    res.append("<");
                    res.append(tok);
                    continue;
                }
                while (stok.hasMoreTokens() && !stok.nextToken().equals(">")) {
                }
                continue;
            }
            res.append(tok);
        }
        return res.toString();
    }

    public String toString() {
        return this.text;
    }
}

