/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector.debugger;

import jadex.runtime.SystemEvent;
import jadex.tools.common.GuiProperties;
import jadex.tools.introspector.ToolPanel;
import jadex.tools.introspector.ToolTab;
import jadex.tools.introspector.debugger.AgendaEntryInfo;
import jadex.tools.introspector.debugger.ClassicDebuggerPanel;
import jadex.tools.ontology.ExecuteCommand;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DebuggerTab
extends ToolTab {
    protected GuiListener gl;
    protected JComboBox agendachoice;
    protected JTextField agendastateview;
    protected JButton agendastep;
    protected JComboBox agendasteps;
    protected JTextField actagendasteps;
    protected JTree tree;
    protected JScrollPane treepanel;
    protected JSplitPane content;
    protected ClassicDebuggerPanel cdp;
    boolean agendastepenabled;
    boolean agendastepsenabled;
    boolean actagendastepsenabled;

    public DebuggerTab(ToolPanel tool) {
        super(tool, "Debugger", GuiProperties.getElementIcon("bug_icon"), new String[]{"steppable_"});
        this.createGUI();
        this.createListener();
    }

    public void systemEventsOccurred(SystemEvent[] ces) {
        for (int e = 0; e < ces.length; ++e) {
            SystemEvent ce = ces[e];
            String what = ce.getType();
            if ("steppable_agenda_changed".equals(what) || "steppable_agenda_step_done".equals(what) || "steppable_".equals(what)) {
                ((DefaultTreeModel)this.tree.getModel()).setRoot(this.buildTreeStructure((Map)ce.getSource()));
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
                this.tree.scrollRowToVisible(this.tree.getRowCount() - 1);
                this.treepanel.getVerticalScrollBar().setValue(this.treepanel.getVerticalScrollBar().getMaximum());
            }
            if ("steppable_agenda_step_done".equals(what) || "steppable_".equals(what)) {
                this.agendastateview.setText("step finished");
                Map source = (Map)ce.getSource();
                this.actagendasteps.setText("" + source.get("steps"));
            }
            if ("steppable_agenda_mode_changed".equals(what) || "steppable_".equals(what)) {
                Map source = (Map)ce.getSource();
                String mode = (String)source.get("mode");
                this.agendachoice.removeActionListener(this.gl);
                this.agendachoice.setSelectedItem(mode);
                if (!SUtil.arrayToList((Object)this.agendachoice.getActionListeners()).contains(this.gl) || "steppable_".equals(what)) {
                    this.agendachoice.addActionListener(this.gl);
                }
                this.actagendasteps.setText("" + source.get("steps"));
                if ("step".equals(mode) || "cycle".equals(mode)) {
                    this.agendastep.setEnabled(true);
                    this.agendasteps.setEnabled(true);
                    this.actagendasteps.setEnabled(true);
                } else {
                    this.agendastep.setEnabled(false);
                    this.agendasteps.setEnabled(false);
                    this.actagendasteps.setEnabled(false);
                }
            }
            if (!"steppable_agenda_steps_changed".equals(what) && !"steppable_".equals(what)) continue;
            Map source = (Map)ce.getSource();
            this.actagendasteps.setText("" + source.get("steps"));
        }
    }

    protected List traverseDepthFirst(DefaultMutableTreeNode root, List list) {
        list.add(root.getUserObject());
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.traverseDepthFirst((DefaultMutableTreeNode)root.getChildAt(i), list);
        }
        return list;
    }

    protected void clear() {
    }

    protected void createGUI() {
        Insets insets = new Insets(2, 6, 4, 4);
        this.agendastateview = new JTextField("running");
        this.agendastateview.setEditable(false);
        this.agendachoice = new JComboBox<String>(new String[]{"normal", "cycle", "step"});
        this.agendastep = new JButton();
        this.agendastep.setIcon(GuiProperties.getElementIcon("right"));
        this.agendastep.setToolTipText("Execute a specified number of agenda actions");
        this.agendasteps = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "10", "100"});
        this.agendasteps.setEditable(true);
        this.actagendasteps = new JTextField(3);
        this.actagendasteps.setEditable(false);
        JPanel agenda = new JPanel(new GridBagLayout());
        TitledBorder agendabord = new TitledBorder(new EtchedBorder(1), "Agenda Control");
        agenda.setBorder(agendabord);
        agenda.add((Component)new JLabel("Execution mode"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)this.agendachoice, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)new JLabel("Execute <n> agenda actions"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)this.agendasteps, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)this.agendastep, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 10, 0));
        agenda.add((Component)new JLabel("Open steps"), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)this.actagendasteps, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)new JLabel("Processing state"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)this.agendastateview, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        agenda.add((Component)new JPanel(), new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        DefaultMutableTreeNode root = this.buildTreeStructure(new HashMap());
        this.tree = new JTree(root);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.getRowCount();
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new IntrospectorTreeCellRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node;
                TreePath tp = e.getNewLeadSelectionPath();
                if (tp != null && (node = (DefaultMutableTreeNode)tp.getLastPathComponent()) != null) {
                    AgendaEntryInfo ei = (AgendaEntryInfo)node.getUserObject();
                    DebuggerTab.this.getToolPanel().showElementDetails(ei.getEntryMap());
                }
            }
        });
        this.treepanel = new JScrollPane(this.tree);
        this.agendastep.setMinimumSize(new Dimension(30, (int)this.agendastep.getMinimumSize().getHeight()));
        this.agendastep.setPreferredSize(new Dimension(30, (int)this.agendastep.getPreferredSize().getHeight()));
        this.agendasteps.setMinimumSize(new Dimension(60, (int)this.agendasteps.getMinimumSize().getHeight()));
        this.agendasteps.setPreferredSize(new Dimension(60, (int)this.agendasteps.getPreferredSize().getHeight()));
        this.actagendasteps.setMinimumSize(this.actagendasteps.getPreferredSize());
        this.treepanel.setMinimumSize(new Dimension(130, (int)this.treepanel.getMinimumSize().getHeight()));
        this.treepanel.setPreferredSize(new Dimension(200, (int)this.treepanel.getPreferredSize().getHeight()));
        JPanel top = new JPanel(new GridBagLayout());
        top.add((Component)this.treepanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        top.add((Component)agenda, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, insets, 0, 0));
        this.setLayout(new BorderLayout());
        this.add("Center", top);
        this.add("North", SGUI.createToolBar((String)"Debugger Options", (Action[])this.getActions()));
    }

    public void setActive(boolean active) {
        Color color;
        super.setActive(active);
        if (active) {
            new UIManager();
            color = UIManager.getColor("List.background");
        } else {
            new UIManager();
            color = UIManager.getColor("Panel.background");
        }
        Color background = color;
        this.treepanel.getViewport().setBackground(background);
        this.tree.setBackground(background);
        this.tree.setEnabled(active);
        this.agendachoice.setEnabled(active);
        if (active) {
            this.agendastep.setEnabled(this.agendastepenabled);
            this.agendasteps.setEnabled(this.agendastepsenabled);
            this.actagendasteps.setEnabled(this.actagendastepsenabled);
        } else {
            this.agendastepenabled = this.agendastep.isEnabled();
            this.agendastepsenabled = this.agendasteps.isEnabled();
            this.actagendastepsenabled = this.actagendasteps.isEnabled();
            this.agendastep.setEnabled(false);
            this.agendasteps.setEnabled(false);
            this.actagendasteps.setEnabled(false);
        }
    }

    protected void createListener() {
        this.gl = new GuiListener();
        this.agendachoice.addActionListener(this.gl);
        this.agendastep.addActionListener(this.gl);
    }

    protected DefaultMutableTreeNode buildTreeStructure(Map agenda) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        int i = 0;
        while (agenda != null && agenda.get("" + i) != null) {
            root.add(this.buildTreeStructureForEntry(new AgendaEntryInfo((Map)agenda.get("" + i))));
            ++i;
        }
        Integer anum = (Integer)agenda.get("num");
        return root;
    }

    protected DefaultMutableTreeNode buildTreeStructureForEntry(AgendaEntryInfo entryinfo) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(entryinfo);
        List children = entryinfo.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            DefaultMutableTreeNode tmp = this.buildTreeStructureForEntry((AgendaEntryInfo)children.get(i));
            node.add(tmp);
        }
        return node;
    }

    class IntrospectorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        IntrospectorTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            boolean processed = false;
            if (node.getUserObject() instanceof AgendaEntryInfo) {
                AgendaEntryInfo entry = (AgendaEntryInfo)node.getUserObject();
                processed = entry.isProcessed();
            } else {
                this.setOpenIcon(this.getDefaultOpenIcon());
                this.setClosedIcon(this.getDefaultClosedIcon());
                this.setLeafIcon(this.getDefaultLeafIcon());
            }
            JComponent comp = (JComponent)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (processed) {
                comp.setForeground(Color.lightGray);
            }
            return comp;
        }
    }

    protected class GuiListener
    extends MouseAdapter
    implements ActionListener {
        int i = 0;

        protected GuiListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == DebuggerTab.this.agendachoice) {
                String state = (String)DebuggerTab.this.agendachoice.getSelectedItem();
                if (state.equals("normal")) {
                    DebuggerTab.this.agendastateview.setText("running");
                } else if (state.equals("step") || state.equals("cycle")) {
                    DebuggerTab.this.agendastateview.setText("step finished");
                }
                String cmd = "setAgendaExecutionMode " + state;
                ExecuteCommand com = new ExecuteCommand();
                com.setCommand(cmd);
                DebuggerTab.this.tool.performToolAction(com);
            } else if (source == DebuggerTab.this.agendastep) {
                DebuggerTab.this.agendastateview.setText("step requested");
                int steps = -1;
                try {
                    steps = Integer.parseInt((String)DebuggerTab.this.agendasteps.getSelectedItem());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (steps > -1) {
                    String cmd = "setAgendaSteps " + steps;
                    ExecuteCommand com = new ExecuteCommand();
                    com.setCommand(cmd);
                    DebuggerTab.this.tool.performToolAction(com);
                }
            }
        }
    }
}

