/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector.debugger;

import jadex.tools.common.GuiProperties;
import jadex.tools.introspector.debugger.AgendaEntryInfo;
import jadex.util.SGUI;
import jadex.util.jtable.ObjectTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class ClassicDebuggerPanel
extends JPanel {
    protected static UIDefaults def = new UIDefaults(new Object[]{"right", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/arrowright.png"), "top", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/arrowtop.png"), "up", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/arrowup.png"), "down", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/arrowdown.png"), "bottom", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/arrowbottom.png"), "delete", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/delete.png"), "empty", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/empty.png"), "icon", SGUI.makeIcon((Class)ClassicDebuggerPanel.class, (String)"/jadex/tools/common/images/bug_small.png")});
    protected JComboBox dispchoice;
    protected JTextField dispexestate;
    protected JButton dispstep;
    protected JComboBox dispsteps;
    protected JTextField actdispsteps;
    protected JLabel seleventl;
    protected JTextField selevent;
    protected JComboBox schedchoice;
    protected JTextField schedstateview;
    protected JButton schedstep;
    protected JComboBox schedsteps;
    protected JTextField actschedsteps;
    protected JButton eventtop;
    protected JButton eventup;
    protected JButton eventdown;
    protected JButton eventbottom;
    protected JButton eventdelete;
    protected JButton readytop;
    protected JButton readyup;
    protected JButton readydown;
    protected JButton readybottom;
    protected JButton readydelete;
    protected JTable el;
    protected JTable rl;
    protected JTable al;
    protected JTable sl;
    protected ObjectTableModel elm;
    protected ObjectTableModel rlm;
    protected ObjectTableModel alm;
    protected ObjectTableModel slm;
    protected JSplitPane content;
    protected HashMap listelems;
    protected GuiListener gl;

    public ClassicDebuggerPanel() {
        this.createGUI();
        this.createListener();
        this.listelems = new HashMap();
    }

    public void updateGui(List entries) {
        this.elm.removeAllRows();
        this.rlm.removeAllRows();
        for (int i = 0; i < entries.size(); ++i) {
            if (!(entries.get(i) instanceof AgendaEntryInfo)) continue;
            AgendaEntryInfo entry = (AgendaEntryInfo)entries.get(i);
            if (entry.getActionClassName().equals("ProcessEventAction") && !entry.isProcessed()) {
                this.elm.addRow(new Object[]{GuiProperties.getElementIcon(entry.getActionClassName()), "?"}, (Object)entry);
                continue;
            }
            if (!entry.getActionClassName().equals("ExecutePlanStepAction") || entry.isProcessed()) continue;
            this.rlm.addRow(new Object[]{GuiProperties.getElementIcon(entry.getActionClassName()), "?"}, (Object)entry);
        }
    }

    protected void clear() {
        this.elm.removeAllRows();
        this.rlm.removeAllRows();
        this.alm.removeAllRows();
        this.slm.removeAllRows();
    }

    protected void createGUI() {
        Insets insets = new Insets(2, 6, 4, 4);
        Insets noi = new Insets(2, 0, 2, 4);
        this.elm = new ObjectTableModel(new String[]{"Type", "Event"});
        this.elm.setColumnClass(Icon.class, 0);
        this.eventtop = new JButton();
        this.eventup = new JButton();
        this.eventdown = new JButton();
        this.eventbottom = new JButton();
        this.eventdelete = new JButton();
        this.eventtop.setIcon(def.getIcon("top"));
        this.eventup.setIcon(def.getIcon("up"));
        this.eventdown.setIcon(def.getIcon("down"));
        this.eventbottom.setIcon(def.getIcon("bottom"));
        this.eventdelete.setIcon(def.getIcon("delete"));
        this.el = new JTable((TableModel)this.elm);
        this.el.getSelectionModel().setSelectionMode(0);
        JScrollPane elsp = new JScrollPane(this.el);
        elsp.getViewport().setBackground(Color.WHITE);
        JPanel elp = new JPanel(new GridBagLayout());
        elp.add((Component)elsp, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 10, 1, noi, 0, 0));
        elp.add((Component)this.eventtop, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, noi, 0, 0));
        elp.add((Component)this.eventup, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, noi, 0, 0));
        elp.add((Component)this.eventdown, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, noi, 0, 0));
        elp.add((Component)this.eventbottom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 2, noi, 0, 0));
        elp.add((Component)this.eventdelete, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 15, 2, noi, 0, 0));
        this.rlm = new ObjectTableModel(new String[]{"Type", "Plan Instance"});
        this.rlm.setColumnClass(Icon.class, 0);
        this.readytop = new JButton();
        this.readyup = new JButton();
        this.readydown = new JButton();
        this.readybottom = new JButton();
        this.readydelete = new JButton();
        this.readytop.setIcon(def.getIcon("top"));
        this.readyup.setIcon(def.getIcon("up"));
        this.readydown.setIcon(def.getIcon("down"));
        this.readybottom.setIcon(def.getIcon("bottom"));
        this.readydelete.setIcon(def.getIcon("delete"));
        this.rl = new JTable((TableModel)this.rlm);
        JScrollPane rlsp = new JScrollPane(this.rl);
        rlsp.getViewport().setBackground(Color.WHITE);
        JPanel rlp = new JPanel(new GridBagLayout());
        rlp.add((Component)rlsp, new GridBagConstraints(0, 0, 1, 5, 1.0, 0.0, 10, 1, noi, 0, 0));
        rlp.add((Component)this.readytop, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, noi, 0, 0));
        rlp.add((Component)this.readyup, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 15, 2, noi, 0, 0));
        rlp.add((Component)this.readydown, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, noi, 0, 0));
        rlp.add((Component)this.readybottom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 2, noi, 0, 0));
        rlp.add((Component)this.readydelete, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 15, 2, noi, 0, 0));
        this.alm = new ObjectTableModel(new String[]{"Type", "Candidates"});
        this.alm.setColumnClass(Icon.class, 0);
        this.al = new JTable((TableModel)this.alm);
        JScrollPane alsp = new JScrollPane(this.al);
        alsp.getViewport().setBackground(Color.WHITE);
        this.slm = new ObjectTableModel(new String[]{"Type", "Scheduled Candidates"});
        this.slm.setColumnClass(Icon.class, 0);
        this.sl = new JTable((TableModel)this.slm);
        JScrollPane slsp = new JScrollPane(this.sl);
        slsp.getViewport().setBackground(Color.WHITE);
        this.dispchoice = new JComboBox<String>(new String[]{"normal", "cycle", "step"});
        this.dispstep = new JButton();
        this.dispstep.setIcon(def.getIcon("right"));
        this.dispsteps = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "10", "100"});
        this.dispsteps.setEditable(true);
        this.actdispsteps = new JTextField(3);
        this.actdispsteps.setEditable(false);
        this.dispexestate = new JTextField();
        this.dispexestate.setEditable(false);
        JPanel exe = new JPanel(new GridBagLayout());
        exe.add((Component)new JLabel("Mode"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)this.dispchoice, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)new JLabel("Execute"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)this.dispsteps, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)this.dispstep, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)this.actdispsteps, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)new JLabel("State"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)this.dispexestate, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        exe.add((Component)new JPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel disp = new JPanel(new BorderLayout());
        disp.setBorder(new TitledBorder(new EtchedBorder(1), "Dispatcher Control"));
        disp.add("Center", exe);
        JPanel selep = new JPanel(new GridBagLayout());
        this.selevent = new JTextField();
        this.selevent.setEditable(false);
        this.selevent.setHorizontalAlignment(2);
        this.seleventl = new JLabel("Event");
        this.seleventl.setIcon(def.getIcon("empty"));
        this.seleventl.setHorizontalTextPosition(2);
        selep.add((Component)this.seleventl, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 2, insets, 0, 0));
        selep.add((Component)this.selevent, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 11, 2, insets, 0, 0));
        this.schedstateview = new JTextField("running");
        this.schedstateview.setEditable(false);
        this.schedchoice = new JComboBox<String>(new String[]{"normal", "step"});
        this.schedstep = new JButton();
        this.schedstep.setIcon(def.getIcon("right"));
        this.schedsteps = new JComboBox<String>(new String[]{"1", "2", "3", "4", "5", "10", "100"});
        this.schedsteps.setEditable(true);
        this.actschedsteps = new JTextField(3);
        this.actschedsteps.setEditable(false);
        JPanel sched = new JPanel(new GridBagLayout());
        TitledBorder schedbord = new TitledBorder(new EtchedBorder(1), "Scheduler Control");
        sched.setBorder(schedbord);
        sched.add((Component)new JLabel("Mode"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)this.schedchoice, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)new JLabel("Execute"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)this.schedsteps, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)this.schedstep, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)this.actschedsteps, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)new JLabel("State"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)this.schedstateview, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        sched.add((Component)new JPanel(), new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.eventtop.setMinimumSize(new Dimension(20, 20));
        this.eventup.setMinimumSize(new Dimension(20, 20));
        this.eventdown.setMinimumSize(new Dimension(20, 20));
        this.eventbottom.setMinimumSize(new Dimension(20, 20));
        this.eventdelete.setMinimumSize(new Dimension(20, 20));
        this.eventtop.setPreferredSize(new Dimension(20, 20));
        this.eventup.setPreferredSize(new Dimension(20, 20));
        this.eventdown.setPreferredSize(new Dimension(20, 20));
        this.eventbottom.setPreferredSize(new Dimension(20, 20));
        this.eventdelete.setPreferredSize(new Dimension(20, 20));
        this.readytop.setMinimumSize(new Dimension(20, 20));
        this.readyup.setMinimumSize(new Dimension(20, 20));
        this.readydown.setMinimumSize(new Dimension(20, 20));
        this.readybottom.setMinimumSize(new Dimension(20, 20));
        this.readydelete.setMinimumSize(new Dimension(20, 20));
        this.readytop.setPreferredSize(new Dimension(20, 20));
        this.readyup.setPreferredSize(new Dimension(20, 20));
        this.readydown.setPreferredSize(new Dimension(20, 20));
        this.readybottom.setPreferredSize(new Dimension(20, 20));
        this.readydelete.setPreferredSize(new Dimension(20, 20));
        this.readydelete.setPreferredSize(new Dimension(20, 20));
        this.dispstep.setMinimumSize(new Dimension(30, (int)this.dispstep.getMinimumSize().getHeight()));
        this.dispstep.setPreferredSize(new Dimension(30, (int)this.dispstep.getPreferredSize().getHeight()));
        this.dispsteps.setMinimumSize(new Dimension(60, (int)this.dispsteps.getMinimumSize().getHeight()));
        this.dispsteps.setPreferredSize(new Dimension(60, (int)this.dispsteps.getPreferredSize().getHeight()));
        this.actdispsteps.setMinimumSize(this.actdispsteps.getPreferredSize());
        this.schedstep.setMinimumSize(new Dimension(30, (int)this.schedstep.getMinimumSize().getHeight()));
        this.schedstep.setPreferredSize(new Dimension(30, (int)this.schedstep.getPreferredSize().getHeight()));
        this.schedsteps.setMinimumSize(new Dimension(60, (int)this.schedsteps.getMinimumSize().getHeight()));
        this.schedsteps.setPreferredSize(new Dimension(60, (int)this.schedsteps.getPreferredSize().getHeight()));
        this.actschedsteps.setMinimumSize(this.actschedsteps.getPreferredSize());
        disp.setMinimumSize(disp.getPreferredSize());
        elp.setMinimumSize(new Dimension(130, (int)disp.getMinimumSize().getHeight()));
        elp.setPreferredSize(new Dimension(200, (int)disp.getPreferredSize().getHeight()));
        alsp.setPreferredSize(new Dimension(200, ((int)disp.getPreferredSize().getHeight() - (int)selep.getMinimumSize().getHeight() - 2 * (insets.bottom + insets.top)) / 2));
        slsp.setPreferredSize(new Dimension(200, ((int)disp.getPreferredSize().getHeight() - (int)selep.getMinimumSize().getHeight() - 2 * (insets.bottom + insets.top)) / 2));
        this.el.getColumnModel().getColumn(0).setMaxWidth(40);
        this.al.getColumnModel().getColumn(0).setMaxWidth(40);
        this.sl.getColumnModel().getColumn(0).setMaxWidth(40);
        this.rl.getColumnModel().getColumn(0).setMaxWidth(40);
        JPanel top = new JPanel(new GridBagLayout());
        top.add((Component)disp, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 1, insets, 0, 0));
        JSplitPane right = new JSplitPane(1);
        right.add(elp);
        right.setOneTouchExpandable(true);
        JPanel r1 = new JPanel(new GridBagLayout());
        r1.add((Component)selep, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, insets, 0, 0));
        r1.add((Component)alsp, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, insets, 0, 0));
        r1.add((Component)slsp, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, insets, 0, 0));
        right.add(r1);
        top.add((Component)right, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, insets, 0, 0));
        rlp.setMinimumSize(new Dimension(200, (int)sched.getMinimumSize().getHeight()));
        rlp.setPreferredSize(new Dimension(200, (int)sched.getPreferredSize().getHeight()));
        JPanel middle = new JPanel(new GridBagLayout());
        middle.add((Component)sched, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 1, insets, 0, 0));
        middle.add((Component)rlp, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, insets, 0, 0));
        this.content = new JSplitPane(0, true);
        this.content.setOneTouchExpandable(true);
        this.content.setResizeWeight(0.5);
        this.content.add(top);
        this.content.add(middle);
        this.setLayout(new BorderLayout());
        this.add("Center", this.content);
    }

    protected void createListener() {
        this.gl = new GuiListener();
        this.eventtop.addActionListener(this.gl);
        this.eventup.addActionListener(this.gl);
        this.eventdown.addActionListener(this.gl);
        this.eventbottom.addActionListener(this.gl);
        this.eventdelete.addActionListener(this.gl);
        this.readytop.addActionListener(this.gl);
        this.readyup.addActionListener(this.gl);
        this.readydown.addActionListener(this.gl);
        this.readydelete.addActionListener(this.gl);
        this.dispchoice.addActionListener(this.gl);
        this.dispstep.addActionListener(this.gl);
        this.schedchoice.addActionListener(this.gl);
        this.schedstep.addActionListener(this.gl);
        this.selevent.addMouseListener(this.gl);
        this.el.addMouseListener(this.gl);
        this.rl.addMouseListener(this.gl);
        this.al.addMouseListener(this.gl);
        this.sl.addMouseListener(this.gl);
    }

    public static void main(String[] args) {
        ClassicDebuggerPanel cdp = new ClassicDebuggerPanel();
        JFrame f = new JFrame();
        f.getContentPane().add("Center", cdp);
        f.pack();
        f.setVisible(true);
    }

    protected class GuiListener
    extends MouseAdapter
    implements ActionListener {
        protected GuiListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
        }

        public void mouseClicked(MouseEvent me) {
            Object source = me.getSource();
        }
    }
}

