/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AgendaEntryInfo {
    protected Map entryinfo;
    protected Map cleaninfo;
    protected List children;

    public AgendaEntryInfo(Map entryinfo) {
        this.entryinfo = entryinfo;
        this.cleaninfo = new HashMap();
        this.cleaninfo.putAll(entryinfo);
        this.children = new ArrayList();
        int i = 0;
        while (entryinfo.get("" + i) != null) {
            this.children.add(new AgendaEntryInfo((Map)entryinfo.get("" + i)));
            this.cleaninfo.remove("" + i);
            ++i;
        }
        this.cleaninfo.remove("text");
        this.cleaninfo.remove("hashcode");
    }

    public boolean isProcessed() {
        return new Boolean((String)this.entryinfo.get("processed"));
    }

    public boolean isExecuted() {
        return new Boolean((String)this.entryinfo.get("executed"));
    }

    public boolean isValid() {
        return this.isExecuted() || new Boolean((String)this.entryinfo.get("valid")) != false;
    }

    public String getActionClassName() {
        return "" + this.entryinfo.get("actionclass");
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String getHashcode() {
        return (String)this.entryinfo.get("hashcode");
    }

    public Map getEntryMap() {
        return this.cleaninfo;
    }

    public String toString() {
        String ret = (String)this.entryinfo.get("text");
        if (!this.isValid()) {
            ret = "(invalid) " + ret;
        }
        return ret;
    }
}

