/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector.bdiviewer;

import jadex.runtime.SystemEvent;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.jtreetable.TreeTableModel;
import jadex.tools.introspector.ToolPanel;
import jadex.tools.introspector.bdiviewer.BDITreeTableModel;
import jadex.tools.introspector.bdiviewer.BasePanel;
import java.util.Map;

public class PlanbasePanel
extends BasePanel {
    protected static final String[] TYPES = new String[]{"BDI_plan", "BDI_capability", "agent"};

    public PlanbasePanel(ToolPanel tool) {
        super(tool, "Planbase", NODE_RPLAN.getIcon(null), TYPES);
    }

    public void systemEventsOccurred(SystemEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            if (events[i].instanceOf("BDI_capability") || events[i].instanceOf("agent")) {
                this.handleCapabilityUpdate(events[i]);
                continue;
            }
            if (!events[i].instanceOf("BDI_plan")) continue;
            this.handlePlanUpdate(events[i]);
        }
    }

    protected void handlePlanUpdate(SystemEvent event) {
        Map source = (Map)event.getSource();
        DefaultTreeTableNode base = this.getNode((String)source.get("scope")).getChild("Planbase");
        if (base == null) {
            return;
        }
        if (event.instanceOf("BDI_planAdded")) {
            this.addNode(base, this.createNode(event));
        } else if (event.instanceOf("BDI_planRemoved")) {
            DefaultTreeTableNode plan = base.getChild(source.get("name"));
            if (plan == null) {
                return;
            }
            plan.setValues(source);
            this.removeNode(plan);
        } else if (event.instanceOf("BDI_planChanged")) {
            DefaultTreeTableNode plan = base.getChild(source.get("name"));
            if (plan == null) {
                return;
            }
            plan.setValues(source);
        }
    }

    protected TreeTableModel createModel() {
        DefaultTreeTableNode plans = new DefaultTreeTableNode(NODE_RBDIAGENT, this.tool.getAgentName());
        return new BDITreeTableModel(this.tool, plans, NODE_RPLAN.getColumnNames());
    }

    protected DefaultTreeTableNode createBaseNode() {
        return new DefaultTreeTableNode(NODE_RPLANBASE, "Planbase");
    }
}

