/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector.bdiviewer;

import jadex.runtime.SystemEvent;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.jtreetable.TreeTableModel;
import jadex.tools.common.jtreetable.TreeTableNodeType;
import jadex.tools.introspector.ToolPanel;
import jadex.tools.introspector.bdiviewer.BDITreeTableModel;
import jadex.tools.introspector.bdiviewer.BasePanel;
import jadex.util.SUtil;
import jadex.util.Tuple;
import jadex.util.jtable.ResizeableTableHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GoalbasePanel
extends BasePanel {
    protected static final String[] TYPES = new String[]{"BDI_goal", "BDI_plan", "BDI_capability", "agent"};
    protected Map pgoalnodes;
    protected boolean goalview = false;
    protected TreeTableModel pmodel;
    protected TreeTableModel gmodel = this.goalview ? this.model : this.createModel();
    protected JLabel gvlabel;

    public GoalbasePanel(ToolPanel tool) {
        super(tool, "Goalbase", NODE_RGOAL.getIcon(null), TYPES);
        this.pmodel = !this.goalview ? this.model : this.createModel();
        this.pgoalnodes = new HashMap();
        this.oldmax = 40;
        ((ResizeableTableHeader)this.table.getTableHeader()).setAllColumnWidths(100, -1, -1);
        ((ResizeableTableHeader)this.table.getTableHeader()).setColumnWidths(this.table.getColumnModel().getColumn(0), 200, 100, -1);
        Component toolbar = this.getComponent(0);
        JPanel panel = new JPanel(new BorderLayout());
        this.gvlabel = new JLabel("", 2);
        this.gvlabel.setText(this.goalview ? "Goalview - shows capability/goal structure" : "Planview - shows goal/plan hierarchy");
        this.gvlabel.setIcon(this.goalview ? defaults.getIcon("goalview") : defaults.getIcon("planview"));
        panel.add("South", toolbar);
        panel.add("Center", this.gvlabel);
        this.add("North", panel);
    }

    public void setGoalview(boolean goalview) {
        if (goalview != this.goalview) {
            this.goalview = goalview;
            this.table.setModel(goalview ? this.gmodel : this.pmodel);
            this.gvlabel.setText(goalview ? "Goalview - shows capability/goal structure" : "Planview - shows goal/plan hierarchy");
            this.gvlabel.setIcon(goalview ? defaults.getIcon("goalview") : defaults.getIcon("planview"));
        }
    }

    public void systemEventsOccurred(SystemEvent[] events) {
        ArrayList<SystemEvent> unhandled = null;
        if (events.length > 1) {
            unhandled = new ArrayList<SystemEvent>(events.length);
        }
        for (int i = 0; i < events.length; ++i) {
            if (events[i].instanceOf("BDI_capability") || events[i].instanceOf("agent")) {
                this.handleCapabilityUpdate(events[i]);
                continue;
            }
            if (events[i].instanceOf("BDI_goal")) {
                if (this.handleGoalUpdate(events[i]) || unhandled == null) continue;
                unhandled.add(events[i]);
                continue;
            }
            if (!events[i].instanceOf("BDI_plan") || this.handlePlanUpdate(events[i]) || unhandled == null) continue;
            unhandled.add(events[i]);
        }
        while (unhandled != null && unhandled.size() > 0) {
            ArrayList unhandled2 = new ArrayList(unhandled.size());
            for (int i = 0; i < unhandled.size(); ++i) {
                SystemEvent event = (SystemEvent)unhandled.get(i);
                if (event.instanceOf("BDI_goal")) {
                    if (this.handleGoalUpdate(event)) continue;
                    unhandled2.add(unhandled.get(i));
                    continue;
                }
                if (this.handlePlanUpdate(event)) continue;
                unhandled2.add(unhandled.get(i));
            }
            if (unhandled2.size() != unhandled.size()) {
                unhandled = unhandled2;
                continue;
            }
            System.err.println("Warning: BDIViewer ignoring events (all/unhandled):\n" + SUtil.arrayToString((Object)events) + "\n" + unhandled);
            break;
        }
    }

    protected void handleCapabilityUpdate(SystemEvent event) {
        this.model = this.gmodel;
        super.handleCapabilityUpdate(event);
        this.model = this.goalview ? this.gmodel : this.pmodel;
    }

    protected boolean handleGoalUpdate(SystemEvent event) {
        DefaultTreeTableNode goal;
        Tuple parent;
        Map source = (Map)event.getSource();
        TreeTableNodeType type = this.getNodeType(event);
        DefaultTreeTableNode pbase = null;
        DefaultTreeTableNode gbase = null;
        boolean showinplanview = false;
        if (type == NODE_RACHIEVEGOAL || type == NODE_RMAINTAINGOAL || type == NODE_RPERFORMGOAL || type == NODE_RQUERYGOAL) {
            showinplanview = true;
            if (source.get("realparent") != null) {
                parent = new Tuple(source.get("realparent"), source.get("realparentscope"));
                pbase = (DefaultTreeTableNode)this.pgoalnodes.get(parent);
            } else {
                pbase = (DefaultTreeTableNode)this.pmodel.getRoot();
            }
        } else if (type == NODE_RMETAGOAL) {
            showinplanview = true;
            if (source.get("trigger") != null) {
                parent = new Tuple(source.get("trigger"), source.get("triggerscope"));
                pbase = (DefaultTreeTableNode)this.pgoalnodes.get(parent);
            } else {
                pbase = (DefaultTreeTableNode)this.pmodel.getRoot();
            }
        }
        gbase = this.getNode(this.gmodel, (String)source.get("scope")).getChild("Goalbase");
        if (showinplanview && pbase == null || gbase == null) {
            return false;
        }
        if (event.instanceOf("BDI_goalAdded")) {
            DefaultTreeTableNode gnode = this.createNode(event);
            this.addNode(gbase, gnode);
            if (showinplanview) {
                DefaultTreeTableNode pnode = this.createNode(event);
                this.addNode(pbase, pnode);
                Tuple pgoal = new Tuple(source.get("name"), source.get("scope"));
                this.pgoalnodes.put(pgoal, pnode);
            }
        } else if (event.instanceOf("BDI_goalRemoved")) {
            goal = gbase.getChild(source.get("name"));
            if (goal == null) {
                return false;
            }
            goal = gbase.getChild(source.get("name"));
            goal.setValues(source);
            this.removeNode(goal);
            if (showinplanview) {
                goal = pbase.getChild(source.get("name"));
                goal.setValues(source);
                this.removeNode(goal);
                Tuple pgoal = new Tuple(source.get("name"), source.get("scope"));
                this.pgoalnodes.remove(pgoal);
            }
        } else if (event.instanceOf("BDI_goalChanged")) {
            goal = gbase.getChild(source.get("name"));
            if (goal == null) {
                return false;
            }
            goal.setValues(source);
            if (showinplanview) {
                goal = pbase.getChild(source.get("name"));
                goal.setValues(source);
            }
        }
        return true;
    }

    protected boolean handlePlanUpdate(SystemEvent event) {
        DefaultTreeTableNode pnode;
        Map source = (Map)event.getSource();
        TreeTableNodeType type = this.getNodeType(event);
        DefaultTreeTableNode pbase = null;
        if (source.get("proprietarygoal") != null) {
            Tuple parent = new Tuple(source.get("proprietarygoal"), source.get("proprietarygoalscope"));
            pbase = (DefaultTreeTableNode)this.pgoalnodes.get(parent);
        } else {
            pbase = (DefaultTreeTableNode)this.pmodel.getRoot();
        }
        if (pbase == null) {
            return false;
        }
        if (event.instanceOf("BDI_planAdded")) {
            pnode = this.createNode(event);
            this.addNode(pbase, pnode);
            Tuple pkey = new Tuple(source.get("rootgoal"), source.get("scope"));
            this.pgoalnodes.put(pkey, pnode);
        } else if (event.instanceOf("BDI_planRemoved")) {
            pnode = pbase.getChild(source.get("name"));
            if (pnode == null) {
                return false;
            }
            pnode.setValues(source);
            this.removeNode(pnode);
            Tuple pkey = new Tuple(source.get("rootgoal"), source.get("scope"));
            this.pgoalnodes.remove(pkey);
        } else if (event.instanceOf("BDI_planChanged")) {
            pnode = pbase.getChild(source.get("name"));
            if (pnode == null) {
                return false;
            }
            pnode.setValues(source);
        }
        return true;
    }

    public Action[] getActions() {
        if (this.actions == null) {
            Action[] actions2 = super.getActions();
            this.actions = new Action[actions2.length + 2];
            System.arraycopy(actions2, 0, this.actions, 0, actions2.length);
            this.actions[actions2.length + 1] = new AbstractAction("Toggle Plan-/Goalview", defaults.getIcon("togglegoalview")){

                public void actionPerformed(ActionEvent ae) {
                    this.putValue("SmallIcon", GoalbasePanel.this.goalview ? BasePanel.defaults.getIcon("togglegoalview") : BasePanel.defaults.getIcon("toggleplanview"));
                    GoalbasePanel.this.setGoalview(!GoalbasePanel.this.goalview);
                }
            };
        }
        return this.actions;
    }

    protected TreeTableModel createModel() {
        DefaultTreeTableNode goals = new DefaultTreeTableNode(NODE_RBDIAGENT, this.tool.getAgentName());
        return new BDITreeTableModel(this.tool, goals, NODE_RABSTRACTGOAL.getColumnNames());
    }

    protected DefaultTreeTableNode createBaseNode() {
        return new DefaultTreeTableNode(NODE_RGOALBASE, "Goalbase");
    }

    protected void clear() {
        ((DefaultTreeTableNode)(this.goalview ? this.pmodel : this.gmodel).getRoot()).removeAllChildren();
        super.clear();
        this.pgoalnodes.clear();
    }

    protected int sortNode(DefaultTreeTableNode parent, DefaultTreeTableNode node, int index) {
        if (node.instanceOf(NODE_RGOAL)) {
            while (index > 0) {
                DefaultTreeTableNode sib = (DefaultTreeTableNode)parent.getChildAt(index - 1);
                if (this.oldnodes.containsKey(node) != this.oldnodes.containsKey(sib) || !sib.instanceOf(NODE_RPROCESSGOAL) && ((String)node.getValue(0)).compareTo((String)sib.getValue(0)) >= 0) break;
                --index;
            }
        }
        return index;
    }
}

