/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector.bdiviewer;

import jadex.runtime.SystemEvent;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.jtreetable.SetTreeTableNode;
import jadex.tools.common.jtreetable.TreeTableModel;
import jadex.tools.common.jtreetable.TreeTableNodeType;
import jadex.tools.introspector.ToolPanel;
import jadex.tools.introspector.bdiviewer.BDITreeTableModel;
import jadex.tools.introspector.bdiviewer.BasePanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeliefbasePanel
extends BasePanel {
    protected static final String[] TYPES = new String[]{"BDI_belief", "BDI_factChanged", "BDI_bsfactAdded", "BDI_bsfactRemoved", "BDI_bsfactChanged", "BDI_bsfactsChanged", "BDI_capability", "agent"};

    public BeliefbasePanel(ToolPanel tool) {
        super(tool, "Beliefbase", NODE_RBELIEF.getIcon(null), TYPES);
    }

    public void systemEventsOccurred(SystemEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            if (events[i].instanceOf("BDI_capability") || events[i].instanceOf("agent")) {
                this.handleCapabilityUpdate(events[i]);
                continue;
            }
            if (!events[i].instanceOf("BDI_belief") && !events[i].instanceOf("BDI_factChanged") && !events[i].instanceOf("BDI_bsfact")) continue;
            this.handleBeliefUpdate(events[i]);
        }
    }

    protected void handleBeliefUpdate(SystemEvent event) {
        Map source = (Map)event.getSource();
        if (event.getValue() != null) {
            source.put("value", event.getValue());
        }
        DefaultTreeTableNode base = this.getNode((String)source.get("scope")).getChild("Beliefbase");
        if (event.instanceOf("BDI_beliefAdded")) {
            TreeTableNodeType type = this.getNodeType(event);
            if (type == NODE_RBELIEFSETREFERENCE) {
                type = NODE_RBELIEFSETREFERENCECONTAINER;
            } else if (type == NODE_RBELIEFSET) {
                type = NODE_RBELIEFSETCONTAINER;
            }
            this.addNode(base, new DefaultTreeTableNode(type, source.get("name"), source));
        } else if (event.instanceOf("BDI_beliefRemoved")) {
            DefaultTreeTableNode belief = base.getChild(source.get("name"));
            if (belief == null) {
                System.err.println("Warning: BDIViewer ignoring unknown belief: " + source.get("name") + ", " + source.get("scope"));
                return;
            }
            belief.setValues(source);
            this.removeNode(belief);
        } else if (event.instanceOf("BDI_factChanged")) {
            DefaultTreeTableNode belief = base.getChild(source.get("name"));
            if (belief == null) {
                System.err.println("Warning: BDIViewer ignoring unknown belief: " + source.get("name") + ", " + source.get("scope"));
                return;
            }
            belief.setValues(source);
        } else if (event.instanceOf("BDI_bsfactAdded")) {
            int index = event.getIndex();
            TreeTableNodeType type = this.getNodeType(event);
            DefaultTreeTableNode container = base.getChild(source.get("name"));
            if (container == null || index > container.getChildCount()) {
                System.err.println("Warning: BDIViewer ignoring unknown belief: " + source.get("name") + ", " + source.get("scope"));
                return;
            }
            SetTreeTableNode fact = new SetTreeTableNode(type, source);
            container.insert(fact, index);
        } else if (event.instanceOf("BDI_bsfactChanged")) {
            int index = event.getIndex();
            DefaultTreeTableNode container = base.getChild(source.get("name"));
            if (container == null || index > container.getChildCount()) {
                System.err.println("Warning: BDIViewer ignoring unknown belief: " + source.get("name") + ", " + source.get("scope"));
                return;
            }
            DefaultTreeTableNode belief = (DefaultTreeTableNode)container.getChildAt(index);
            belief.setValues(source);
        } else if (event.instanceOf("BDI_bsfactRemoved")) {
            int index = event.getIndex();
            DefaultTreeTableNode container = base.getChild(source.get("name"));
            if (container == null || index > container.getChildCount()) {
                System.err.println("Warning: BDIViewer ignoring unknown belief: " + source.get("name") + ", " + source.get("scope"));
                return;
            }
            DefaultTreeTableNode belief = (DefaultTreeTableNode)container.getChildAt(index);
            belief.setValues(source);
            this.removeNode(belief);
        } else if (event.instanceOf("BDI_bsfactsChanged")) {
            DefaultTreeTableNode container = base.getChild(source.get("name"));
            if (container == null) {
                System.err.println("Warning: BDIViewer ignoring unknown belief: " + source.get("name") + ", " + source.get("scope"));
                return;
            }
            while (container.getChildCount() > 0) {
                this.removeNode((DefaultTreeTableNode)container.getChildAt(0));
            }
            TreeTableNodeType type = this.getNodeType(event);
            List vals = (List)event.getValue();
            for (int i = 0; i < vals.size(); ++i) {
                HashMap values = new HashMap();
                values.putAll(source);
                values.put("value", vals.get(i));
                SetTreeTableNode fact = new SetTreeTableNode(type, values);
                container.insert(fact, i);
            }
        }
    }

    protected TreeTableModel createModel() {
        DefaultTreeTableNode beliefs = new DefaultTreeTableNode(NODE_RBDIAGENT, this.tool.getAgentName());
        return new BDITreeTableModel(this.tool, beliefs, NODE_RBELIEF.getColumnNames());
    }

    protected DefaultTreeTableNode createBaseNode() {
        return new DefaultTreeTableNode(NODE_RBELIEFBASE, "Beliefbase");
    }

    protected int sortNode(DefaultTreeTableNode parent, DefaultTreeTableNode node, int index) {
        if (node.instanceOf(NODE_RBELIEF)) {
            while (index > 0 && ((DefaultTreeTableNode)parent.getChildAt(index - 1)).instanceOf(NODE_RBELIEFSETCONTAINER)) {
                --index;
            }
        }
        return index;
    }
}

