/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector.bdiviewer;

import jadex.runtime.SystemEvent;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.IValidator;
import jadex.tools.common.JValidatorTextField;
import jadex.tools.common.ParserValidator;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.jtreetable.JTreeTable;
import jadex.tools.common.jtreetable.TreeExpansionHandler;
import jadex.tools.common.jtreetable.TreeTableModel;
import jadex.tools.common.jtreetable.TreeTableModelAdapter;
import jadex.tools.common.jtreetable.TreeTableNodeType;
import jadex.tools.introspector.ToolPanel;
import jadex.tools.introspector.ToolTab;
import jadex.tools.ontology.ElementAction;
import jadex.tools.ontology.PerformAction;
import jadex.util.SGUI;
import jadex.util.jtable.ResizeableTableHeader;
import jadex.util.jtable.VisibilityTableColumnModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class BasePanel
extends ToolTab {
    protected static UIDefaults defaults = new UIDefaults(new Object[]{"resize", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/resize.png"), "clear", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/litter2.png"), "togglegoalview", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/toggle_goalview.png"), "toggleplanview", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/toggle_planview.png"), "goalview", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/cloud2.png"), "planview", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/plan2.png"), "keepold", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/keepold.png"), "removeold", SGUI.makeIcon((Class)BasePanel.class, (String)"/jadex/tools/common/images/removeold.png")});
    protected static final String[] COLUMNS_BELIEFS = new String[]{"name", "valueclass", "value"};
    protected static final String[] NAMES_BELIEFS = new String[]{"Name", "Class", "Value"};
    protected static final String[] COLUMNS_PLANS = new String[]{"name", "state"};
    protected static final String[] NAMES_PLANS = new String[]{"Name", "State"};
    protected static final String[] COLUMNS_GOALS = new String[]{"name", "lifecyclestate", "processingstate", "type"};
    protected static final String[] NAMES_GOALS = new String[]{"Name", "Lifecycle State", "Processing State", "Type"};
    protected static final TreeTableNodeType NODE_RCAPABILITY = new TreeTableNodeType("RCapability", new Icon[]{GuiProperties.getElementIcon("RCapability")}, new String[]{"name"}, new String[]{"Name"});
    protected static final TreeTableNodeType NODE_RBDIAGENT = BasePanel.createNodeType("RBDIAgent", NODE_RCAPABILITY);
    protected static final TreeTableNodeType NODE_RBELIEFBASE = new TreeTableNodeType("RBeliefbase", new Icon[]{GuiProperties.getElementIcon("RBeliefbase")}, new String[]{"name"}, new String[]{"Name"});
    protected static final TreeTableNodeType NODE_RGOALBASE = new TreeTableNodeType("RGoalbase", new Icon[]{GuiProperties.getElementIcon("RGoalbase")}, new String[]{"name"}, new String[]{"Name"});
    protected static final TreeTableNodeType NODE_RPLANBASE = new TreeTableNodeType("RPlanbase", new Icon[]{GuiProperties.getElementIcon("RPlanbase")}, new String[]{"name"}, new String[]{"Name"});
    protected static final TreeTableNodeType NODE_RBELIEF = new TreeTableNodeType("RBelief", new Icon[]{GuiProperties.getElementIcon("RBelief")}, COLUMNS_BELIEFS, NAMES_BELIEFS);
    protected static final TreeTableNodeType NODE_RBELIEFSET = BasePanel.createNodeType("RBeliefSet", NODE_RBELIEF);
    protected static final TreeTableNodeType NODE_RBELIEFSETCONTAINER = new TreeTableNodeType("RBeliefSetContainer", new Icon[]{GuiProperties.getElementIcon("RBeliefSetContainer")}, COLUMNS_BELIEFS, NAMES_BELIEFS);
    protected static final TreeTableNodeType NODE_RBELIEFREFERENCE = BasePanel.createNodeType("RBeliefReference", NODE_RBELIEF);
    protected static final TreeTableNodeType NODE_RBELIEFSETREFERENCE = BasePanel.createNodeType("RBeliefSetReference", NODE_RBELIEFSET);
    protected static final TreeTableNodeType NODE_RBELIEFSETREFERENCECONTAINER = BasePanel.createNodeType("RBeliefSetReferenceContainer", NODE_RBELIEFSETCONTAINER);
    protected static final TreeTableNodeType NODE_RABSTRACTGOAL = new TreeTableNodeType("RAbstractGoal", null, COLUMNS_GOALS, NAMES_GOALS);
    protected static final TreeTableNodeType NODE_RGOAL = BasePanel.createNodeType("RGoal", NODE_RABSTRACTGOAL);
    protected static final TreeTableNodeType NODE_RACHIEVEGOAL = BasePanel.createNodeType("RAchieveGoal", NODE_RGOAL);
    protected static final TreeTableNodeType NODE_RMAINTAINGOAL = BasePanel.createNodeType("RMaintainGoal", NODE_RGOAL);
    protected static final TreeTableNodeType NODE_RPERFORMGOAL = BasePanel.createNodeType("RPerformGoal", NODE_RGOAL);
    protected static final TreeTableNodeType NODE_RQUERYGOAL = BasePanel.createNodeType("RQueryGoal", NODE_RGOAL);
    protected static final TreeTableNodeType NODE_RMETAGOAL = BasePanel.createNodeType("RMetaGoal", NODE_RGOAL);
    protected static final TreeTableNodeType NODE_RACHIEVEGOALREFERENCE = BasePanel.createNodeType("RAchieveGoalReference", NODE_RACHIEVEGOAL);
    protected static final TreeTableNodeType NODE_RMAINTAINGOALREFERENCE = BasePanel.createNodeType("RMaintainGoalReference", NODE_RMAINTAINGOAL);
    protected static final TreeTableNodeType NODE_RPERFORMGOALREFERENCE = BasePanel.createNodeType("RPerformGoalReference", NODE_RPERFORMGOAL);
    protected static final TreeTableNodeType NODE_RQUERYGOALREFERENCE = BasePanel.createNodeType("RQueryGoalReference", NODE_RQUERYGOAL);
    protected static final TreeTableNodeType NODE_RMETAGOALREFERENCE = BasePanel.createNodeType("RMetaGoalReference", NODE_RMETAGOAL);
    protected static final TreeTableNodeType NODE_RPROCESSGOAL = BasePanel.createNodeType("RProcessGoal", NODE_RABSTRACTGOAL);
    protected static final TreeTableNodeType NODE_RPLAN = new TreeTableNodeType("RPlan", new Icon[]{GuiProperties.getElementIcon("RPlan")}, COLUMNS_PLANS, NAMES_PLANS);
    protected static Map nodetypes = new HashMap();
    protected TreeTableModel model;
    protected BDITreeTable table;
    protected JScrollPane scroll;
    protected Map oldnodes = new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() > BasePanel.this.oldmax) {
                if (BasePanel.this.keepold) {
                    DefaultTreeTableNode node = (DefaultTreeTableNode)eldest.getKey();
                    DefaultTreeTableNode parent = (DefaultTreeTableNode)eldest.getValue();
                    parent.remove(node);
                }
                return true;
            }
            return false;
        }
    };
    protected boolean keepold = false;
    protected int oldmax = 20;
    static /* synthetic */ Class class$jadex$tools$common$jtreetable$TreeTableModel;

    protected static TreeTableNodeType createNodeType(String type, TreeTableNodeType base) {
        return new TreeTableNodeType(type, new Icon[]{GuiProperties.getElementIcon(type)}, base);
    }

    public BasePanel(ToolPanel tool, String name, Icon icon, String[] events) {
        super(tool, name, icon, events);
        this.setLayout(new BorderLayout());
        this.add("North", SGUI.createToolBar((String)"BDI Viewer Options", (Action[])this.getActions()));
        this.model = this.createModel();
        this.table = new BDITreeTable(this.model);
        this.table.setAutoResizeMode(0);
        this.scroll = new JScrollPane(this.table);
        this.add("Center", this.scroll);
        new UIManager();
        this.scroll.getViewport().setBackground(UIManager.getColor("List.background"));
        new UIManager();
        this.table.setBackground(UIManager.getColor("List.background"));
        VisibilityTableColumnModel columnmodel = new VisibilityTableColumnModel();
        this.table.setColumnModel((TableColumnModel)columnmodel);
        this.table.createDefaultColumnsFromModel();
        columnmodel.addMouseListener((JTable)this.table);
        columnmodel.setColumnChangeable(columnmodel.getColumn(0), false);
        ResizeableTableHeader header = new ResizeableTableHeader();
        header.setColumnModel(this.table.getColumnModel());
        header.setAutoResizingEnabled(false);
        header.setIncludeHeaderWidth(false);
        this.table.setTableHeader((JTableHeader)header);
        header.setAllColumnWidths(145, -1, -1);
        header.setColumnWidths(this.table.getColumnModel().getColumn(0), 200, 100, -1);
    }

    public abstract void systemEventsOccurred(SystemEvent[] var1);

    protected void handleCapabilityUpdate(SystemEvent event) {
        if (event.instanceOf("agentBorn")) {
            DefaultTreeTableNode cap = (DefaultTreeTableNode)this.model.getRoot();
            this.addNode(cap, this.createBaseNode());
        } else if (event.instanceOf("BDI_capabilityAdded")) {
            Map source = (Map)event.getSource();
            DefaultTreeTableNode owner = this.getNode((String)source.get("owner"));
            DefaultTreeTableNode cap = this.createNode(event);
            this.addNode(owner, cap);
            this.addNode(cap, this.createBaseNode());
        } else if (event.instanceOf("BDI_capabilityRemoved")) {
            Map source = (Map)event.getSource();
            if (!NODE_RBDIAGENT.equals(this.getNodeType(event))) {
                DefaultTreeTableNode owner = this.getNode((String)source.get("owner"));
                this.removeNode(owner.getChild(source.get("name")));
            }
        }
    }

    public void clearOldNodes() {
        if (this.keepold) {
            Iterator i = this.oldnodes.keySet().iterator();
            while (i.hasNext()) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)i.next();
                ((DefaultTreeTableNode)node.getParent()).remove(node);
            }
        }
        this.oldnodes.clear();
    }

    public void setKeepNodes(boolean keepold) {
        if (keepold != this.keepold) {
            this.keepold = keepold;
            Iterator i = this.oldnodes.keySet().iterator();
            while (i.hasNext()) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)i.next();
                DefaultTreeTableNode parent = (DefaultTreeTableNode)this.oldnodes.get(node);
                if (keepold) {
                    this.addNode(parent, node);
                    continue;
                }
                parent.remove(node);
            }
        }
    }

    protected DefaultTreeTableNode createNode(SystemEvent event) {
        TreeTableNodeType type = this.getNodeType(event);
        return new DefaultTreeTableNode(type, ((Map)event.getSource()).get("name"), (Map)event.getSource());
    }

    protected DefaultTreeTableNode getNode(String name) {
        return this.getNode(this.model, name);
    }

    protected DefaultTreeTableNode getNode(TreeTableModel model, String name) {
        DefaultTreeTableNode node = (DefaultTreeTableNode)model.getRoot();
        StringTokenizer stok = new StringTokenizer(name, ".");
        stok.nextToken();
        while (stok.hasMoreTokens()) {
            name = stok.nextToken();
            node = node.getChild(name);
        }
        return node;
    }

    protected void addNode(DefaultTreeTableNode parent, DefaultTreeTableNode child) {
        int index;
        if (!child.instanceOf(NODE_RCAPABILITY)) {
            for (index = parent.getChildCount(); index > 0 && ((DefaultTreeTableNode)parent.getChildAt(index - 1)).instanceOf(NODE_RCAPABILITY); --index) {
            }
        }
        if (!this.oldnodes.containsKey(child)) {
            while (index > 0 && this.oldnodes.containsKey(parent.getChildAt(index - 1))) {
                --index;
            }
        }
        for (index = this.sortNode(parent, child, index); index > 0; --index) {
            DefaultTreeTableNode sib = (DefaultTreeTableNode)parent.getChildAt(index - 1);
            if (child.getType() != sib.getType() || this.oldnodes.containsKey(child) != this.oldnodes.containsKey(sib) || ((String)child.getValue(0)).compareTo((String)sib.getValue(0)) >= 0) break;
        }
        parent.insert(child, index);
        if (parent.getChildCount() == 1) {
            this.table.getTree().expandPath(new TreePath(parent.getPath()));
        }
        if (child.getChildCount() > 0) {
            LinkedList<TreeNode> childnodes = new LinkedList<TreeNode>();
            childnodes.add(child);
            while (childnodes.size() > 0) {
                child = (DefaultTreeTableNode)childnodes.remove(0);
                this.table.getTree().expandPath(new TreePath(child.getPath()));
                for (int i = 0; i < child.getChildCount(); ++i) {
                    if (child.getChildAt(i).getChildCount() <= 0) continue;
                    childnodes.add(child.getChildAt(i));
                }
            }
        }
    }

    protected void removeNode(DefaultTreeTableNode node) {
        DefaultTreeTableNode parent = (DefaultTreeTableNode)node.getParent();
        this.oldnodes.put(node, parent);
        parent.remove(node);
        if (this.keepold && this.oldnodes.size() > 0) {
            this.addNode(parent, node);
        }
    }

    protected TreeTableNodeType getNodeType(SystemEvent event) {
        Map source = (Map)event.getSource();
        TreeTableNodeType type = (TreeTableNodeType)nodetypes.get(source.get("class"));
        if (type == null) {
            throw new RuntimeException("No node for type: " + source.get("class") + " " + event);
        }
        return type;
    }

    public void setActive(boolean active) {
        Color color;
        super.setActive(active);
        if (active) {
            new UIManager();
            color = UIManager.getColor("List.background");
        } else {
            new UIManager();
            color = UIManager.getColor("Panel.background");
        }
        Color background = color;
        this.scroll.getViewport().setBackground(background);
        this.table.setBackground(background);
        this.table.setEnabled(active);
    }

    public Action[] getActions() {
        if (this.actions == null) {
            Action[] actions2 = super.getActions();
            this.actions = new Action[actions2.length + 5];
            System.arraycopy(actions2, 0, this.actions, 0, actions2.length);
            this.actions[actions2.length + 1] = new AbstractAction("Resize Column Widths to Fit Contents", defaults.getIcon("resize")){

                public void actionPerformed(ActionEvent ae) {
                    ((ResizeableTableHeader)BasePanel.this.table.getTableHeader()).resizeAllColumns();
                }
            };
            this.actions[actions2.length + 3] = new AbstractAction("Show/Hide Removed Elements", defaults.getIcon("keepold")){

                public void actionPerformed(ActionEvent ae) {
                    this.putValue("SmallIcon", BasePanel.this.keepold ? defaults.getIcon("keepold") : defaults.getIcon("removeold"));
                    BasePanel.this.setKeepNodes(!BasePanel.this.keepold);
                }
            };
            this.actions[actions2.length + 4] = new AbstractAction("Flush Removed Elements", defaults.getIcon("clear")){

                public void actionPerformed(ActionEvent ae) {
                    BasePanel.this.clearOldNodes();
                }
            };
        }
        return this.actions;
    }

    public void setEnabled(boolean enabled) {
        Color color;
        if (enabled) {
            new UIManager();
            color = UIManager.getColor("List.background");
        } else {
            new UIManager();
            color = UIManager.getColor("Panel.background");
        }
        Color bgcolor = color;
        this.scroll.getViewport().setBackground(bgcolor);
        this.table.setBackground(bgcolor);
        super.setEnabled(enabled);
    }

    protected int sortNode(DefaultTreeTableNode parent, DefaultTreeTableNode node, int index) {
        return index;
    }

    protected void clear() {
        ((DefaultTreeTableNode)this.model.getRoot()).removeAllChildren();
        this.oldnodes.clear();
    }

    protected abstract TreeTableModel createModel();

    protected abstract DefaultTreeTableNode createBaseNode();

    protected static void fillElementAction(ElementAction action, DefaultTreeTableNode node) {
        String name = node.getValue(0).toString();
        String type = node.getType().getName();
        String scope = null;
        while (node.getParent() != null) {
            if ((node = (DefaultTreeTableNode)node.getParent()).instanceOf(NODE_RBELIEFSETCONTAINER)) {
                name = node.getValue(0).toString() + "." + name;
                continue;
            }
            if (!node.instanceOf(NODE_RCAPABILITY)) continue;
            String capaname = node.getValue(0).toString();
            int sep = capaname.indexOf("@");
            if (sep != -1 && node.instanceOf(NODE_RBDIAGENT)) {
                capaname = capaname.substring(0, sep);
            }
            scope = scope == null ? capaname : capaname + "." + scope;
        }
        action.setElementName(name);
        action.setElementType(type);
        action.setScope(scope);
    }

    public static Action createPopupAction(String command, String name) {
        AbstractAction action = new AbstractAction(name){

            public void actionPerformed(ActionEvent e) {
            }
        };
        action.putValue("ActionCommandKey", command);
        return action;
    }

    static /* synthetic */ ToolPanel access$100(BasePanel x0) {
        return x0.tool;
    }

    static /* synthetic */ ToolPanel access$300(BasePanel x0) {
        return x0.tool;
    }

    static {
        nodetypes.put(NODE_RCAPABILITY.getName(), NODE_RCAPABILITY);
        nodetypes.put(NODE_RBDIAGENT.getName(), NODE_RBDIAGENT);
        nodetypes.put(NODE_RBELIEFBASE.getName(), NODE_RBELIEFBASE);
        nodetypes.put(NODE_RGOALBASE.getName(), NODE_RGOALBASE);
        nodetypes.put(NODE_RPLANBASE.getName(), NODE_RPLANBASE);
        nodetypes.put(NODE_RBELIEF.getName(), NODE_RBELIEF);
        nodetypes.put(NODE_RBELIEFSET.getName(), NODE_RBELIEFSET);
        nodetypes.put(NODE_RBELIEFSETCONTAINER.getName(), NODE_RBELIEFSETCONTAINER);
        nodetypes.put(NODE_RBELIEFREFERENCE.getName(), NODE_RBELIEFREFERENCE);
        nodetypes.put(NODE_RBELIEFSETREFERENCE.getName(), NODE_RBELIEFSETREFERENCE);
        nodetypes.put(NODE_RBELIEFSETREFERENCECONTAINER.getName(), NODE_RBELIEFSETREFERENCECONTAINER);
        nodetypes.put(NODE_RABSTRACTGOAL.getName(), NODE_RABSTRACTGOAL);
        nodetypes.put(NODE_RGOAL.getName(), NODE_RGOAL);
        nodetypes.put(NODE_RACHIEVEGOAL.getName(), NODE_RACHIEVEGOAL);
        nodetypes.put(NODE_RMAINTAINGOAL.getName(), NODE_RMAINTAINGOAL);
        nodetypes.put(NODE_RPERFORMGOAL.getName(), NODE_RPERFORMGOAL);
        nodetypes.put(NODE_RQUERYGOAL.getName(), NODE_RQUERYGOAL);
        nodetypes.put(NODE_RMETAGOAL.getName(), NODE_RMETAGOAL);
        nodetypes.put(NODE_RACHIEVEGOALREFERENCE.getName(), NODE_RACHIEVEGOALREFERENCE);
        nodetypes.put(NODE_RMAINTAINGOALREFERENCE.getName(), NODE_RMAINTAINGOALREFERENCE);
        nodetypes.put(NODE_RPERFORMGOALREFERENCE.getName(), NODE_RPERFORMGOALREFERENCE);
        nodetypes.put(NODE_RQUERYGOALREFERENCE.getName(), NODE_RQUERYGOALREFERENCE);
        nodetypes.put(NODE_RMETAGOALREFERENCE.getName(), NODE_RMETAGOALREFERENCE);
        nodetypes.put(NODE_RPROCESSGOAL.getName(), NODE_RPROCESSGOAL);
        nodetypes.put(NODE_RPLAN.getName(), NODE_RPLAN);
        NODE_RBELIEFSETCONTAINER.addExclude("value");
        NODE_RBELIEFSET.addExclude("valueclass");
        NODE_RBELIEF.setEditable("value");
        NODE_RBELIEF.setValidator("value", new ParserValidator());
        NODE_RBELIEF.addPopupAction(BasePanel.createPopupAction("update", "Update Fact Value"));
        NODE_RBELIEF.addPopupAction(BasePanel.createPopupAction("delete", "Delete Belief"));
        NODE_RBELIEFSET.addPopupAction(BasePanel.createPopupAction("removeFact", "Remove Fact"));
        NODE_RBELIEFSETCONTAINER.addPopupAction(BasePanel.createPopupAction("removeFacts", "Remove All Facts"));
        NODE_RBELIEFSETCONTAINER.addPopupAction(BasePanel.createPopupAction("delete", "Delete Beliefset"));
        NODE_RPLAN.addPopupAction(BasePanel.createPopupAction("terminate", "Terminate Plan"));
        NODE_RABSTRACTGOAL.addPopupAction(BasePanel.createPopupAction("drop", "Drop Goal"));
        NODE_RGOAL.addPopupAction(BasePanel.createPopupAction("suspend", "Suspend Goal"));
        NODE_RGOAL.addPopupAction(BasePanel.createPopupAction("option", "Make Option"));
        NODE_RGOAL.addPopupAction(BasePanel.createPopupAction("activate", "Activate Goal"));
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.doPopup(e);
        }

        protected void doPopup(MouseEvent e) {
            Action[] actions;
            DefaultTreeTableNode node;
            JTreeTable table;
            TreePath path;
            if (e.isPopupTrigger() && (path = (table = (JTreeTable)e.getSource()).getTree().getPathForLocation(e.getX(), e.getY())) != null && !BasePanel.this.oldnodes.containsKey(node = (DefaultTreeTableNode)path.getLastPathComponent()) && (actions = node.getType().getPopupActions()).length > 0) {
                int row = table.rowAtPoint(e.getPoint());
                table.clearSelection();
                table.addRowSelectionInterval(row, row);
                ActionListener listener = new ActionListener(this, node){
                    private final /* synthetic */ DefaultTreeTableNode val$node;
                    private final /* synthetic */ PopupListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$node = val$node;
                    }

                    public void actionPerformed(ActionEvent ae) {
                        PerformAction pa = new PerformAction(ae.getActionCommand(), null, null, "introspector");
                        BasePanel.fillElementAction(pa, this.val$node);
                        BasePanel.access$300(PopupListener.access$200(this.this$1)).performToolAction(pa);
                    }
                };
                JPopupMenu menu = new JPopupMenu("Actions");
                for (int i = 0; i < actions.length; ++i) {
                    JMenuItem item = new JMenuItem(actions[i]);
                    item.addActionListener(listener);
                    menu.add(item);
                }
                menu.show(table, e.getX(), e.getY());
            }
        }

        static /* synthetic */ BasePanel access$200(PopupListener x0) {
            return x0.BasePanel.this;
        }
    }

    class BDITreeTable
    extends JTreeTable {
        public BDITreeTable(TreeTableModel model) {
            super(model);
            this.getTree().setCellRenderer(new BDIViewerTreeCellRenderer());
            new TreeExpansionHandler(this.getTree());
            this.addMouseListener(new PopupListener());
            this.getTree().setToggleClickCount(42);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ BDITreeTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        int row = this.this$1.rowAtPoint(me.getPoint());
                        TreePath path = this.this$1.getTree().getPathForRow(row);
                        if (path != null) {
                            DefaultTreeTableNode node = (DefaultTreeTableNode)path.getLastPathComponent();
                            BasePanel.access$100(BDITreeTable.access$000(this.this$1)).showElementDetails(node.getValues());
                        }
                    }
                }
            });
        }

        public String getToolTipText(MouseEvent event) {
            String tip = null;
            Point p = event.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (this.getRowCount() > row && this.getColumnCount() > col) {
                try {
                    TableCellRenderer renderer = this.getCellRenderer(row, col);
                    Component component = this.prepareRenderer(renderer, row, col);
                    if (component.getPreferredSize().getWidth() > (double)this.getColumnModel().getColumn(col).getWidth()) {
                        tip = this.getValueAt(row, col).equals("") ? null : this.getValueAt(row, col).toString();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return tip;
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension ret = super.getPreferredScrollableViewportSize();
            ret.width = 0;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                ret.width += this.getColumnModel().getColumn(col).getPreferredWidth();
            }
            return ret;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            TableCellEditor editor;
            DefaultTreeTableNode node = (DefaultTreeTableNode)this.getTree().getPathForRow(row).getLastPathComponent();
            IValidator validator = node.getType().getValidator(column);
            if (validator != null) {
                JValidatorTextField valt = new JValidatorTextField(15);
                valt.setValidator(validator);
                editor = new DefaultCellEditor(valt);
            } else {
                editor = super.getCellEditor(row, column);
            }
            return editor;
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component comp = super.prepareRenderer(renderer, row, column);
            if (column != 0) {
                boolean enabled = true;
                for (DefaultTreeTableNode node = (DefaultTreeTableNode)this.getTree().getPathForRow(row).getLastPathComponent(); enabled && node != null; node = (DefaultTreeTableNode)node.getParent()) {
                    enabled = !BasePanel.this.oldnodes.containsKey(node);
                }
                comp.setEnabled(enabled);
            }
            return comp;
        }

        public void setModel(TreeTableModel treeTableModel) {
            this.tree = new JTreeTable.TreeTableCellRenderer(treeTableModel);
            this.tree.setCellRenderer(new BDIViewerTreeCellRenderer());
            super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
            JTreeTable.ListToTreeSelectionModelWrapper selectionWrapper = new JTreeTable.ListToTreeSelectionModelWrapper();
            this.tree.setSelectionModel(selectionWrapper);
            this.setSelectionModel(selectionWrapper.getListSelectionModel());
            this.setDefaultRenderer(class$jadex$tools$common$jtreetable$TreeTableModel == null ? (class$jadex$tools$common$jtreetable$TreeTableModel = BasePanel.class$("jadex.tools.common.jtreetable.TreeTableModel")) : class$jadex$tools$common$jtreetable$TreeTableModel, this.tree);
            if (this.tree.getRowHeight() < 1) {
                this.setRowHeight(20);
            }
            new TreeExpansionHandler(this.tree);
            this.tree.setToggleClickCount(42);
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
            ((ResizeableTableHeader)this.getTableHeader()).setAllColumnWidths(100, -1, -1);
            ((ResizeableTableHeader)this.getTableHeader()).setColumnWidths(this.getColumnModel().getColumn(0), 200, 100, -1);
        }

        static /* synthetic */ BasePanel access$000(BDITreeTable x0) {
            return x0.BasePanel.this;
        }
    }

    class BDIViewerTreeCellRenderer
    extends DefaultTreeCellRenderer {
        BDIViewerTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultTreeTableNode node = (DefaultTreeTableNode)value;
            if (node.getType() != null) {
                Icon icon = node.getType().getIcon(value);
                if (icon != null) {
                    this.setOpenIcon(icon);
                    this.setClosedIcon(icon);
                    this.setLeafIcon(icon);
                } else {
                    this.setOpenIcon(this.getDefaultOpenIcon());
                    this.setClosedIcon(this.getDefaultClosedIcon());
                    this.setLeafIcon(this.getDefaultLeafIcon());
                }
            }
            JComponent comp = (JComponent)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            boolean enabled = true;
            while (enabled && node != null) {
                enabled = !BasePanel.this.oldnodes.containsKey(node);
                node = (DefaultTreeTableNode)node.getParent();
            }
            comp.setEnabled(enabled);
            return comp;
        }
    }
}

