/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.AgentDeathException;
import jadex.runtime.AgentEvent;
import jadex.runtime.BDIFailureException;
import jadex.runtime.GoalFailureException;
import jadex.runtime.ICapability;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.runtime.IGoalListener;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.SystemEvent;
import jadex.runtime.TimeoutException;
import jadex.tools.common.ElementPanel;
import jadex.tools.common.IToolPanel;
import jadex.tools.common.LocalToolRequestPlan;
import jadex.tools.common.ShortcutToolReply;
import jadex.tools.introspector.ToolTab;
import jadex.tools.introspector.bdiviewer.BeliefbasePanel;
import jadex.tools.introspector.bdiviewer.GoalbasePanel;
import jadex.tools.introspector.bdiviewer.PlanbasePanel;
import jadex.tools.introspector.debugger.DebuggerTab;
import jadex.tools.ontology.ChangeAttribute;
import jadex.tools.ontology.CurrentState;
import jadex.tools.ontology.Deregister;
import jadex.tools.ontology.ExecuteCommand;
import jadex.tools.ontology.Register;
import jadex.tools.ontology.ToolAction;
import jadex.util.SGUI;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ToolPanel
extends JPanel
implements IToolPanel {
    public static final String NOTHING = "No element selected for detailed view.\nUse double-click to view element.";
    protected IExternalAccess agent;
    protected AgentIdentifier observed;
    protected JSplitPane content;
    protected ElementPanel details;
    protected Map listeners;
    protected Set typeset;
    protected JTabbedPane tabs;
    protected ToolTab[] tools;
    protected boolean isactive;
    protected boolean registered;

    public ToolPanel(IExternalAccess agent, AgentIdentifier observed, boolean[] active) {
        this.agent = agent;
        this.observed = observed;
        this.typeset = new HashSet();
        this.listeners = new HashMap();
        this.details = new ElementPanel("Details", NOTHING);
        this.tabs = new JTabbedPane();
        this.tools = new ToolTab[]{new BeliefbasePanel(this), new GoalbasePanel(this), new PlanbasePanel(this), new DebuggerTab(this)};
        boolean selected = false;
        for (int i = 0; i < this.tools.length; ++i) {
            this.tabs.addTab(this.tools[i].getName(), this.tools[i].getIcon(), this.tools[i]);
            this.tools[i].setActive(active[i]);
            if (selected || !active[i]) continue;
            this.tabs.setSelectedIndex(i);
            selected = true;
        }
        this.content = new JSplitPane(0, this.tabs, this.details);
        this.content.setOneTouchExpandable(true);
        this.content.setResizeWeight(0.5);
        this.content.setDividerLocation(65535);
        this.setLayout(new BorderLayout());
        this.add("Center", this.content);
    }

    public void showElementDetails(Map element) {
        this.details.addElement(element, null);
        if (this.content.getDividerLocation() > this.content.getMaximumDividerLocation()) {
            this.content.setDividerLocation(this.content.getLastDividerLocation());
        }
    }

    public void dispatchGoal(IGoal goal, final String errortitle, final String errormessage) {
        goal.addGoalListener(new IGoalListener(){

            public void goalFinished(AgentEvent ae) {
                IGoal goal = (IGoal)ae.getSource();
                if (!goal.isSucceeded()) {
                    String text = errormessage == null && goal.getException() == null ? errortitle : (errormessage != null && goal.getException() == null ? errormessage : (errormessage == null && goal.getException() != null ? "" + goal.getExcludeMode() : errormessage + "\n" + goal.getExcludeMode()));
                    JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)ToolPanel.this), SUtil.wrapText((String)text), errortitle, 0);
                }
                goal.removeGoalListener((IGoalListener)this);
            }

            public void goalAdded(AgentEvent ae) {
            }
        }, false);
        this.agent.dispatchTopLevelGoal(goal);
    }

    public String getAgentName() {
        return this.observed.getName();
    }

    public void refresh(ISystemEventListener listener) {
        String[] types = (String[])this.listeners.get(listener);
        if (types == null) {
            throw new IllegalArgumentException("Listener has to be registered.");
        }
        CurrentState state = new CurrentState("introspector");
        state.setEventTypes(types);
        if (this.observed.equals((Object)this.agent.getAgentIdentifier())) {
            ShortcutToolReply reply = new ShortcutToolReply(this, null);
            LocalToolRequestPlan.handleLocalToolRequest((ICapability)this.agent, state, reply);
            state = (CurrentState)reply.getResult();
            if (state != null) {
                listener.systemEventsOccurred(state.getSystemEvents());
            }
        } else {
            IGoal getstate = this.agent.getGoalbase().createGoal("tool_request");
            getstate.getParameter("tool").setValue((Object)this);
            getstate.getParameter("agent").setValue((Object)this.observed);
            getstate.getParameter("request").setValue((Object)state);
            try {
                this.agent.dispatchTopLevelGoalAndWait(getstate, 3000L);
                state = (CurrentState)getstate.getParameter("result").getValue();
                if (state != null) {
                    listener.systemEventsOccurred(state.getSystemEvents());
                }
            }
            catch (BDIFailureException e) {
                String text = SUtil.wrapText((String)("Tool request failed: " + e.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), text, "Tool Problem", 1);
            }
        }
    }

    public void performToolAction(ToolAction action) {
        if (this.observed.equals((Object)this.agent.getAgentIdentifier())) {
            ShortcutToolReply reply = new ShortcutToolReply(this, null);
            LocalToolRequestPlan.handleLocalToolRequest((ICapability)this.agent, action, reply);
        } else {
            try {
                if (action.getToolType() == null) {
                    action.setToolType("introspector");
                }
                IGoal perform = this.agent.getGoalbase().createGoal("tool_request");
                perform.getParameter("tool").setValue((Object)this);
                perform.getParameter("agent").setValue((Object)this.observed);
                perform.getParameter("request").setValue((Object)action);
                this.agent.dispatchTopLevelGoalAndWait(perform, 3000L);
            }
            catch (GoalFailureException gfe) {
                Object error = gfe.getGoal().getResult();
                if (error == null) {
                    error = gfe;
                }
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), this.createErrorMessage(action, error.toString()), "Error while performing action", 0);
            }
            catch (TimeoutException e) {
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), this.createErrorMessage(action, e.getMessage()), "Timeout while performing action", 0);
            }
        }
    }

    public void addChangeListener(ISystemEventListener listener, String[] types) {
        if (types == null) {
            throw new NullPointerException("Types may not be null.");
        }
        this.listeners.put(listener, types);
        this.updateRegistration();
        this.refresh(listener);
    }

    public void removeChangeListener(ISystemEventListener listener) {
        this.listeners.remove(listener);
        this.updateRegistration();
    }

    protected String createErrorMessage(ToolAction action, String error) {
        String msg;
        if (action instanceof ExecuteCommand) {
            msg = "Action: Execute command " + ((ExecuteCommand)action).getCommand();
        } else if (action instanceof ChangeAttribute) {
            ChangeAttribute ca = (ChangeAttribute)action;
            msg = "Action: Change " + ca.getAttributeName() + " of " + ca.getElementName() + " to " + ca.getValue();
        } else {
            msg = "Action: " + SReflect.getInnerClassName(action.getClass());
        }
        msg = msg + "\n\nError: " + error;
        return SUtil.wrapText((String)msg);
    }

    protected void updateRegistration() {
        HashSet<String> typeset2 = new HashSet<String>();
        Iterator i = this.listeners.values().iterator();
        while (i.hasNext()) {
            String[] types = (String[])i.next();
            for (int j = 0; j < types.length; ++j) {
                typeset2.add(types[j]);
            }
        }
        if (!((Object)typeset2).equals(this.typeset)) {
            this.typeset = typeset2;
            String[] types = this.typeset.toArray(new String[this.typeset.size()]);
            Register reg = new Register("introspector");
            reg.setEventTypes(types);
            if (this.observed.equals((Object)this.agent.getAgentIdentifier())) {
                LocalToolRequestPlan.handleLocalToolRequest((ICapability)this.agent, reg, new ShortcutToolReply(this, null));
                this.registered = true;
            } else {
                try {
                    IGoal reggoal = this.agent.getGoalbase().createGoal("tool_request");
                    reggoal.getParameter("tool").setValue((Object)this);
                    reggoal.getParameter("agent").setValue((Object)this.observed);
                    reggoal.getParameter("request").setValue((Object)reg);
                    this.agent.dispatchTopLevelGoalAndWait(reggoal, 3000L);
                    this.registered = true;
                }
                catch (BDIFailureException e) {
                    String text = SUtil.wrapText((String)("Tool request failed: " + e.getMessage()));
                    JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), text, "Tool Problem", 1);
                }
            }
        }
    }

    protected void cleanupRegistration() {
        Deregister dereg = new Deregister("introspector");
        IGoal dereggoal = this.agent.getGoalbase().createGoal("tool_request");
        dereggoal.getParameter("tool").setValue((Object)this);
        dereggoal.getParameter("agent").setValue((Object)this.observed);
        dereggoal.getParameter("request").setValue((Object)dereg);
        this.dispatchGoal(dereggoal, "Error Closing Tool", "Problem while deregistering tool");
        this.registered = false;
    }

    public String getId() {
        return this.getAgentName() + "_toolpanel@" + this.hashCode();
    }

    public void activate() {
        this.isactive = true;
    }

    public void update(final CurrentState state) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SystemEvent[] ces = state.getSystemEvents();
                ISystemEventListener[] cls = ToolPanel.this.listeners.keySet().toArray(new ISystemEventListener[ToolPanel.this.listeners.size()]);
                for (int i = 0; i < cls.length; ++i) {
                    try {
                        cls[i].systemEventsOccurred(ces);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Exception of " + cls[i] + " during handling of " + SUtil.arrayToString((Object)ces));
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public boolean isActive() {
        return this.isactive;
    }

    public void deactivate() {
        try {
            this.cleanupRegistration();
            this.isactive = false;
        }
        catch (AgentDeathException agentDeathException) {
            // empty catch block
        }
    }

    public Component getComponent() {
        return this;
    }
}

