/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IGoal;
import jadex.tools.common.AgentTreeTable;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.ObjectCardLayout;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.jtreetable.TreeTableNodeType;
import jadex.tools.common.plugin.IAgentListListener;
import jadex.tools.introspector.ToolPanel;
import jadex.tools.jcc.AbstractJCCPlugin;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;

public class IntrospectorPlugin
extends AbstractJCCPlugin
implements IAgentListListener {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"introspector", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/new_introspector.png"), "introspector_sel", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/new_introspector_sel.png"), "introspect_agent", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/new_introspector.png"), "close_introspector", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/close_introspector.png"), "agent_introspected", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/new_agent_introspected.png"), "introspector_empty", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/introspector_empty.png"), "show_beliefbase", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/bulb2.png"), "show_goalbase", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/cloud2.png"), "show_planbase", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/plan2.png"), "show_debugger", SGUI.makeIcon((Class)IntrospectorPlugin.class, (String)"/jadex/tools/common/images/bug_small.png")});
    protected JSplitPane split;
    protected AgentTreeTable agents;
    protected JPanel detail;
    protected ObjectCardLayout cards;
    protected JCheckBoxMenuItem[] checkboxes;
    final AbstractAction START_INTROSPECTOR = new AbstractAction("Introspect Agent", icons.getIcon("introspect_agent")){

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            IntrospectorPlugin.this.split.setCursor(Cursor.getPredefinedCursor(3));
            DefaultTreeTableNode node = (DefaultTreeTableNode)IntrospectorPlugin.this.agents.getTreetable().getTree().getSelectionPath().getLastPathComponent();
            AMSAgentDescription desc = (AMSAgentDescription)node.getUserObject();
            try {
                boolean[] active = new boolean[IntrospectorPlugin.this.checkboxes.length];
                for (int i = 0; i < IntrospectorPlugin.this.checkboxes.length; ++i) {
                    active[i] = IntrospectorPlugin.this.checkboxes[i].isSelected();
                }
                ToolPanel intro = new ToolPanel(IntrospectorPlugin.this.getJCC().getAgent(), desc.getName(), active);
                IGoal manage = IntrospectorPlugin.this.getJCC().getAgent().getGoalbase().createGoal("manage_tool");
                manage.getParameter("tool").setValue((Object)intro);
                IntrospectorPlugin.this.getJCC().getAgent().dispatchTopLevelGoal(manage);
                GuiProperties.setupHelp(intro, "tools.introspector");
                IntrospectorPlugin.this.detail.add((Component)intro, node.getUserObject());
            }
            catch (GoalFailureException ex) {
                String text = SUtil.wrapText((String)("Manage tool goal failed: " + ex.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)IntrospectorPlugin.this.split), text, "Manager Tool Problem", 1);
            }
            IntrospectorPlugin.this.agents.updateAgent(desc);
            IntrospectorPlugin.this.split.setCursor(Cursor.getDefaultCursor());
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreePath path = IntrospectorPlugin.this.agents.getTreetable().getTree().getSelectionPath();
            if (path != null) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)path.getLastPathComponent();
                ret = node != null && node.getUserObject() instanceof AMSAgentDescription && IntrospectorPlugin.this.cards.getComponent(node.getUserObject()) == null;
            }
            return ret;
        }
    };
    final AbstractAction STOP_INTROSPECTOR = new AbstractAction("Close Introspector", icons.getIcon("close_introspector")){

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            IntrospectorPlugin.this.split.setCursor(Cursor.getPredefinedCursor(3));
            DefaultTreeTableNode node = (DefaultTreeTableNode)IntrospectorPlugin.this.agents.getTreetable().getTree().getSelectionPath().getLastPathComponent();
            ToolPanel intro = (ToolPanel)IntrospectorPlugin.this.cards.getComponent(node.getUserObject());
            IGoal goal = null;
            IGoal[] goals = IntrospectorPlugin.this.getJCC().getAgent().getGoalbase().getGoals("manage_tool");
            for (int i = 0; goal == null && i < goals.length; ++i) {
                if (!intro.equals(goals[i].getParameter("tool").getValue())) continue;
                goal = goals[i];
            }
            goal.drop();
            IntrospectorPlugin.this.detail.remove(intro);
            IntrospectorPlugin.this.agents.updateAgent((AMSAgentDescription)node.getUserObject());
            IntrospectorPlugin.this.split.setCursor(Cursor.getDefaultCursor());
        }

        public boolean isEnabled() {
            boolean ret = false;
            TreePath path = IntrospectorPlugin.this.agents.getTreetable().getTree().getSelectionPath();
            if (path != null) {
                DefaultTreeTableNode node = (DefaultTreeTableNode)path.getLastPathComponent();
                ret = node != null && node.getUserObject() instanceof AMSAgentDescription && IntrospectorPlugin.this.cards.getComponent(node.getUserObject()) != null;
            }
            return ret;
        }
    };

    public IntrospectorPlugin() {
        this.checkboxes = new JCheckBoxMenuItem[]{new JCheckBoxMenuItem("Show Beliefbase", icons.getIcon("show_beliefbase")), new JCheckBoxMenuItem("Show Goalbase", icons.getIcon("show_goalbase")), new JCheckBoxMenuItem("Show Planbase", icons.getIcon("show_planbase")), new JCheckBoxMenuItem("Show Debugger", icons.getIcon("show_debugger"))};
    }

    public void getProperties(Properties props) {
        for (int i = 0; i < this.checkboxes.length; ++i) {
            props.setProperty(this.checkboxes[i].getText(), "" + this.checkboxes[i].isSelected());
        }
    }

    public void setProperties(Properties props) {
        for (int i = 0; i < this.checkboxes.length; ++i) {
            String selected = props.getProperty(this.checkboxes[i].getText());
            this.checkboxes[i].setSelected(selected != null ? new Boolean(selected) : false);
        }
    }

    public String getName() {
        return "Introspector";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("introspector_sel") : icons.getIcon("introspector");
    }

    public JToolBar getToolBar() {
        JToolBar bar = new JToolBar();
        JButton b = new JButton(this.START_INTROSPECTOR);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        b = new JButton(this.STOP_INTROSPECTOR);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        return bar;
    }

    public JMenuBar createMenuBar() {
        JMenu menu = new JMenu("Default Options");
        for (int i = 0; i < this.checkboxes.length; ++i) {
            menu.add(this.checkboxes[i]);
        }
        JMenuBar menubar = new JMenuBar();
        menubar.add(menu);
        return menubar;
    }

    public JComponent getPanel() {
        this.split = new JSplitPane(1, true);
        this.split.setOneTouchExpandable(true);
        this.agents = new AgentTreeTable();
        this.agents.setMinimumSize(new Dimension(0, 0));
        this.split.add(this.agents);
        this.agents.getTreetable().setSelectionMode(0);
        this.agents.getTreetable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JTree tree = IntrospectorPlugin.this.agents.getTreetable().getTree();
                if (!e.getValueIsAdjusting() && !tree.isSelectionEmpty()) {
                    DefaultTreeTableNode node = (DefaultTreeTableNode)tree.getSelectionPath().getLastPathComponent();
                    IntrospectorPlugin.this.cards.show(node.getUserObject());
                }
            }
        });
        this.agents.addNodeType(new TreeTableNodeType(AgentTreeTable.NODE_AGENT, new Icon[0], new String[]{"name", "address"}, new String[]{"Name", "Address"}){

            public Icon selectIcon(Object value) {
                AMSAgentDescription ad = (AMSAgentDescription)((DefaultTreeTableNode)value).getUserObject();
                Icon ret = IntrospectorPlugin.this.cards.getComponent(ad) != null ? icons.getIcon("agent_introspected") : AgentTreeTable.icons.getIcon(AgentTreeTable.NODE_AGENT);
                return ret;
            }
        });
        this.agents.getNodeType(AgentTreeTable.NODE_AGENT).addPopupAction(this.START_INTROSPECTOR);
        this.agents.getNodeType(AgentTreeTable.NODE_AGENT).addPopupAction(this.STOP_INTROSPECTOR);
        JLabel emptylabel = new JLabel("Select agents to activate the introspector", icons.getIcon("introspector_empty"), 0);
        emptylabel.setVerticalAlignment(0);
        emptylabel.setHorizontalTextPosition(0);
        emptylabel.setVerticalTextPosition(3);
        emptylabel.setFont(emptylabel.getFont().deriveFont((float)emptylabel.getFont().getSize() * 1.3f));
        this.cards = new ObjectCardLayout();
        this.detail = new JPanel(this.cards);
        this.detail.setMinimumSize(new Dimension(0, 0));
        this.detail.add("jtc_ocl_default_component", emptylabel);
        this.split.add(this.detail);
        GuiProperties.setupHelp(this.split, "tools.introspector");
        this.agents.getTreetable().getSelectionModel().setSelectionInterval(0, 0);
        this.split.setDividerLocation(150);
        this.agents.getTreetable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (IntrospectorPlugin.this.START_INTROSPECTOR.isEnabled()) {
                        IntrospectorPlugin.this.START_INTROSPECTOR.actionPerformed(null);
                    } else if (IntrospectorPlugin.this.STOP_INTROSPECTOR.isEnabled()) {
                        IntrospectorPlugin.this.STOP_INTROSPECTOR.actionPerformed(null);
                    }
                }
            }
        });
        this.jcc.addAgentListListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IntrospectorPlugin.this.agents.adjustColumnWidths();
            }
        });
        return this.split;
    }

    public void agentDied(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IntrospectorPlugin.this.agents.removeAgent(ad);
                if (IntrospectorPlugin.this.cards.isAvailable(ad)) {
                    IntrospectorPlugin.this.detail.remove(IntrospectorPlugin.this.cards.getComponent(ad));
                }
            }
        });
    }

    public void agentBorn(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IntrospectorPlugin.this.agents.addAgent(ad);
            }
        });
    }

    public void agentChanged(AMSAgentDescription ad) {
    }

    public String getHelpID() {
        return "tools.introspector";
    }
}

