/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.AgentEvent;
import jadex.runtime.GoalFailureException;
import jadex.runtime.IAgentListener;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.tools.introspector.ToolPanel;
import jadex.util.SUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class IntrospectorFrame
extends JFrame {
    protected ToolPanel toolpanel;

    public IntrospectorFrame(final IExternalAccess agent) {
        this.setTitle("Introspector");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    AgentIdentifier observed = (AgentIdentifier)agent.getBeliefbase().getBelief("agent").getFact();
                    IntrospectorFrame.this.toolpanel = new ToolPanel(agent, observed, new boolean[]{false, false, false, false});
                    IGoal manage = agent.getGoalbase().createGoal("manage_tool");
                    manage.getParameter("tool").setValue((Object)IntrospectorFrame.this.toolpanel);
                    agent.dispatchTopLevelGoal(manage);
                }
                catch (GoalFailureException e) {
                    String text = SUtil.wrapText((String)("Manage tool goal failed: " + e.getMessage()));
                    JOptionPane.showMessageDialog(IntrospectorFrame.this, text, "Manager Tool Problem", 1);
                }
                IntrospectorFrame.this.getContentPane().add("Center", IntrospectorFrame.this.toolpanel);
                IntrospectorFrame.this.pack();
                IntrospectorFrame.this.setVisible(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                agent.killAgent();
            }
        });
        agent.addAgentListener(new IAgentListener(){

            public void agentTerminating(AgentEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$000(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ IntrospectorFrame access$000(3 x0) {
                return x0.IntrospectorFrame.this;
            }
        }, false);
    }

    public ToolPanel getToolPanel() {
        return this.toolpanel;
    }
}

