/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.introspector;

import jadex.adapter.IToolAdapter;
import jadex.adapter.fipa.AgentAction;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.Done;
import jadex.model.IMCapability;
import jadex.model.ISystemEventTypes;
import jadex.runtime.IFilter;
import jadex.runtime.ISystemEventListener;
import jadex.runtime.MessageFailureException;
import jadex.runtime.SystemEvent;
import jadex.runtime.TimeoutException;
import jadex.runtime.impl.IEncodable;
import jadex.runtime.impl.IRBelief;
import jadex.runtime.impl.IRBeliefSet;
import jadex.runtime.impl.IRGoal;
import jadex.runtime.impl.RBDIAgent;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RGoal;
import jadex.runtime.impl.RPlan;
import jadex.runtime.impl.SystemEventFilter;
import jadex.tools.ontology.ChangeAttribute;
import jadex.tools.ontology.CurrentState;
import jadex.tools.ontology.Deregister;
import jadex.tools.ontology.ElementAction;
import jadex.tools.ontology.ExecuteCommand;
import jadex.tools.ontology.IntrospectorOntology;
import jadex.tools.ontology.PerformAction;
import jadex.tools.ontology.Register;
import jadex.tools.ontology.ToolAction;
import jadex.tools.ontology.ToolRequest;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IntrospectorAdapter
implements IToolAdapter,
ISystemEventListener,
Serializable {
    public static final String TOOL_INTROSPECTOR = "introspector";
    protected RBDIAgent agent;
    protected IndexMap tools;
    protected Map repliers;
    protected SystemEventFilter filter;

    public IntrospectorAdapter(RBDIAgent agent) {
        this.agent = agent;
        this.tools = SCollection.createIndexMap();
        this.repliers = SCollection.createHashMap();
    }

    public void handleToolRequest(AgentIdentifier sender, AgentAction action, IToolAdapter.IToolReply reply) {
        try {
            if (action instanceof Register) {
                String[] ltypes = ((Register)action).getEventTypes();
                HashSet stypes = SCollection.createHashSet();
                for (int i = 0; i < ltypes.length; ++i) {
                    stypes.addAll(ISystemEventTypes.Subtypes.getSubtypes((String)ltypes[i]));
                }
                this.tools.put((Object)sender, (Object)stypes);
                this.repliers.put(sender, reply);
                this.updateListener();
                reply.sendInform((Object)new Done(action), false);
            } else if (action instanceof Deregister) {
                this.tools.removeKey((Object)sender);
                this.repliers.remove(sender);
                this.updateListener();
                reply.sendInform((Object)new Done(action), false);
            } else if (action instanceof CurrentState) {
                String[] types = ((CurrentState)action).getEventTypes();
                List events = this.agent.getState(types);
                this.externalizeSystemEvents(events);
                ((CurrentState)action).setSystemEvents(events.toArray(new SystemEvent[events.size()]));
                reply.sendInform((Object)action, false);
            } else if (action instanceof ToolAction) {
                try {
                    this.performToolAction((ToolAction)action);
                    reply.sendInform((Object)new Done(action), false);
                }
                catch (Exception e) {
                    reply.sendFailure((Object)e.toString(), false);
                    e.printStackTrace();
                }
            }
        }
        catch (MessageFailureException e) {
            this.tools.removeKey((Object)sender);
            this.repliers.remove(sender);
            this.updateListener();
        }
    }

    public Class getMessageClass() {
        return ToolRequest.class;
    }

    public void systemEventsOccurred(SystemEvent[] events) {
        for (int e = 0; e < events.length; ++e) {
            if (events[e].getType().equals("BDI_capabilityAdded")) {
                ((RCapability)events[e].getSource()).addSystemEventListener((ISystemEventListener)this, (IFilter)this.filter, false, false);
                continue;
            }
            if (!events[e].getType().equals("BDI_capabilityRemoved")) continue;
            ((RCapability)events[e].getSource()).removeSystemEventListener((ISystemEventListener)this);
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            Collection types = (Collection)this.tools.get(i);
            ArrayList matched = SCollection.createArrayList();
            for (int e = 0; e < events.length; ++e) {
                if (!types.contains(events[e].getType())) continue;
                matched.add(events[e]);
            }
            if (matched.size() <= 0) continue;
            try {
                this.externalizeSystemEvents(matched);
                CurrentState state = new CurrentState(TOOL_INTROSPECTOR);
                state.setSystemEvents(matched.toArray(new SystemEvent[matched.size()]));
                IToolAdapter.IToolReply reply = (IToolAdapter.IToolReply)this.repliers.get(this.tools.getKey(i));
                reply.sendInform((Object)state, true);
                continue;
            }
            catch (TimeoutException e) {
                this.repliers.remove(this.tools.getKey(i));
                this.tools.remove(i);
                this.updateListener();
                continue;
            }
            catch (MessageFailureException e) {
                this.repliers.remove(this.tools.getKey(i));
                this.tools.remove(i);
                this.updateListener();
            }
        }
    }

    protected void updateListener() {
        block4: {
            HashSet eventtypes;
            block5: {
                block3: {
                    eventtypes = new HashSet();
                    for (int i = 0; i < this.tools.size(); ++i) {
                        eventtypes.addAll((Set)this.tools.get(i));
                    }
                    if (this.filter != null || eventtypes.isEmpty()) break block3;
                    this.filter = new SystemEventFilter(eventtypes.toArray(new String[eventtypes.size()]));
                    List caps = this.agent.getAllCapabilities();
                    for (int i = 0; i < caps.size(); ++i) {
                        ((RCapability)caps.get(i)).addSystemEventListener((ISystemEventListener)this, (IFilter)this.filter, false, false);
                    }
                    break block4;
                }
                if (this.filter == null || eventtypes.isEmpty()) break block5;
                this.filter.setEventTypes(eventtypes.toArray(new String[eventtypes.size()]));
                break block4;
            }
            if (this.filter == null || !eventtypes.isEmpty()) break block4;
            this.filter = null;
            List caps = this.agent.getAllCapabilities();
            for (int i = 0; i < caps.size(); ++i) {
                ((RCapability)caps.get(i)).removeSystemEventListener((ISystemEventListener)this);
            }
        }
    }

    public void externalizeSystemEvents(List events) {
        for (int i = 0; i < events.size(); ++i) {
            SystemEvent event = (SystemEvent)events.get(i);
            event = (SystemEvent)event.clone();
            events.set(i, event);
            event.setSource(this.externalizeValue(event.getSource()));
            if (event.getValue() instanceof List) {
                List values = (List)event.getValue();
                ArrayList<Object> newvalues = new ArrayList<Object>();
                for (int j = 0; j < values.size(); ++j) {
                    newvalues.add(this.externalizeValue(values.get(j)));
                }
                event.setValue(newvalues);
                continue;
            }
            event.setValue(this.externalizeValue(event.getValue()));
        }
    }

    public Object externalizeValue(Object value) {
        if (value instanceof IEncodable) {
            value = ((IEncodable)value).getEncodableRepresentation();
        } else if (value != null && !(value instanceof String)) {
            value = value.toString();
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performToolAction(ToolAction action) throws Exception {
        if (action instanceof ExecuteCommand) {
            String com = ((ExecuteCommand)action).getCommand();
            StringTokenizer stok = new StringTokenizer(com, " ");
            String todo = stok.nextToken();
            if ("setAgendaExecutionMode".equals(todo)) {
                this.agent.getInterpreter().setExecutionMode(stok.nextToken());
                return;
            } else {
                if (!"setAgendaSteps".equals(todo)) throw new RuntimeException("command not understood: " + todo);
                int steps = Integer.parseInt(stok.nextToken());
                this.agent.getInterpreter().setSteps(steps);
            }
            return;
        } else {
            if (!(action instanceof ElementAction)) throw new RuntimeException("Unknown tool action: " + action);
            ElementAction ea = (ElementAction)action;
            RCapability cap = this.agent.getCapability(ea.getScope());
            if (ea.getElementType().equals("RBelief") || ea.getElementType().equals("RBeliefReference")) {
                IRBelief bel = cap.getBeliefbase().getBelief(ea.getElementName());
                if (action instanceof ChangeAttribute) {
                    ChangeAttribute ca = (ChangeAttribute)action;
                    Object value = ((IMCapability)cap.getModelElement()).getParser().parseExpression(ca.getValue().trim(), null).getValue(cap.getExpressionParameters());
                    if (!ca.getAttributeName().equals("value")) throw new RuntimeException("Can't change attribute: " + ca.getAttributeName());
                    bel.setFact(value);
                    return;
                } else {
                    if (!(action instanceof PerformAction)) return;
                    PerformAction pa = (PerformAction)action;
                    if (pa.getActionName().equals("update")) {
                        bel.getFact();
                        return;
                    } else {
                        if (!pa.getActionName().equals("delete")) throw new RuntimeException("Can't apply action: " + pa.getActionName());
                        cap.getBeliefbase().deleteBelief(ea.getElementName());
                    }
                }
                return;
            } else if (ea.getElementType().equals("RBeliefSet") || ea.getElementType().equals("RBeliefSetReference")) {
                String name = ea.getElementName();
                int index = Integer.parseInt(name.substring(name.indexOf(".") + 1));
                name = name.substring(0, name.indexOf("."));
                IRBeliefSet bel = cap.getBeliefbase().getBeliefSet(name);
                if (action instanceof ChangeAttribute) {
                    ChangeAttribute ca = (ChangeAttribute)action;
                    Object value = ((IMCapability)cap.getModelElement()).getParser().parseExpression(ca.getValue().trim(), null).getValue(cap.getExpressionParameters());
                    if (!ca.getAttributeName().equals("value")) throw new RuntimeException("Can't change attribute: " + ca.getAttributeName());
                    bel.removeFact(bel.getFacts()[index]);
                    bel.addFact(value);
                    return;
                } else {
                    if (!(action instanceof PerformAction)) throw new RuntimeException("Can't apply action: " + ea.getClass().getName());
                    PerformAction pa = (PerformAction)action;
                    if (!pa.getActionName().equals("removeFact")) throw new RuntimeException("Can't apply action: " + pa.getActionName());
                    bel.removeFact(bel.getFacts()[index]);
                }
                return;
            } else if (ea.getElementType().equals("RBeliefSetContainer") || ea.getElementType().equals("RBeliefSetReferenceContainer")) {
                PerformAction pa;
                String name = ea.getElementName();
                IRBeliefSet bel = cap.getBeliefbase().getBeliefSet(name);
                if (!(action instanceof PerformAction) || (pa = (PerformAction)action).getActionName().equals("addFact")) return;
                if (pa.getActionName().equals("removeFacts")) {
                    bel.removeFacts();
                    return;
                } else {
                    if (!pa.getActionName().equals("delete")) throw new RuntimeException("Can't apply action: " + pa.getActionName());
                    cap.getBeliefbase().deleteBeliefSet(ea.getElementName());
                }
                return;
            } else if (ea.getElementType().equals("RPlan")) {
                RPlan plan = cap.getPlanbase().getPlan(ea.getElementName());
                if (!(action instanceof PerformAction)) throw new RuntimeException("Can't apply action: " + ea.getClass().getName());
                PerformAction pa = (PerformAction)action;
                if (!pa.getActionName().equals("terminate")) throw new RuntimeException("Can't apply action: " + pa.getActionName());
                plan.getRootGoal().abort(false);
                return;
            } else {
                if (!ea.getElementType().endsWith("Goal")) throw new RuntimeException("Can't apply actions to element: " + ea.getElementType());
                IRGoal goal = cap.getGoalbase().getGoal(ea.getElementName());
                if (!(action instanceof PerformAction)) throw new RuntimeException("Can't apply action: " + ea.getClass().getName());
                PerformAction pa = (PerformAction)action;
                if (pa.getActionName().equals("drop")) {
                    goal.drop();
                    return;
                } else if (pa.getActionName().equals("suspend") && goal instanceof RGoal) {
                    ((RGoal)goal).suspend();
                    return;
                } else if (pa.getActionName().equals("option") && goal instanceof RGoal) {
                    ((RGoal)goal).option();
                    return;
                } else {
                    if (!pa.getActionName().equals("activate") || !(goal instanceof RGoal)) throw new RuntimeException("Can't apply action: " + pa.getActionName());
                    ((RGoal)goal).activate();
                }
            }
        }
    }

    static {
        try {
            Class.forName(IntrospectorOntology.class.getName());
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not find tool ontology: " + e);
        }
    }
}

