/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import [Ljadex.adapter.fipa.Property;;
import [Ljava.lang.String;;
import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.ServiceDescription;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class ServiceTableModel
extends AbstractTableModel {
    AgentDescription[] ad;
    ServiceDescription[] sd;

    ServiceTableModel() {
    }

    public int getColumnCount() {
        return 8;
    }

    public void setAgentDescriptions(AgentDescription[] ads) {
        ArrayList<AgentDescription> ad_list = new ArrayList<AgentDescription>();
        ArrayList<ServiceDescription> svd_list = new ArrayList<ServiceDescription>();
        for (int a = 0; a < ads.length; ++a) {
            AgentDescription ad = ads[a];
            ServiceDescription[] sd = ads[a].getServices();
            for (int s = 0; s < sd.length; ++s) {
                ad_list.add(ad);
                svd_list.add(sd[s]);
            }
        }
        this.ad = ad_list.toArray(new AgentDescription[ad_list.size()]);
        this.sd = svd_list.toArray(new ServiceDescription[svd_list.size()]);
        this.fireTableDataChanged();
    }

    public void setAgentDescription(AgentDescription ad) {
        ServiceDescription[] sd = ad.getServices();
        AgentDescription[] aid = new AgentDescription[sd.length];
        for (int s = 0; s < sd.length; ++s) {
            aid[s] = ad;
        }
        this.ad = aid;
        this.sd = sd;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.sd != null ? this.sd.length : 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.sd == null || rowIndex < 0 || rowIndex >= this.sd.length) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.sd[rowIndex].getName();
            }
            case 1: {
                return this.sd[rowIndex].getType();
            }
            case 2: {
                return this.sd[rowIndex].getOwnership();
            }
            case 3: {
                return this.ad[rowIndex].getName();
            }
            case 4: {
                return this.sd[rowIndex].getOntologies();
            }
            case 5: {
                return this.sd[rowIndex].getLanguages();
            }
            case 6: {
                return this.sd[rowIndex].getProtocols();
            }
            case 7: {
                return this.sd[rowIndex].getProperties();
            }
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Ownership";
            }
            case 3: {
                return "Agent";
            }
            case 4: {
                return "Ontologies";
            }
            case 5: {
                return "Languages";
            }
            case 6: {
                return "Protocols";
            }
            case 7: {
                return "Properties";
            }
        }
        return null;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return AgentIdentifier.class;
            }
            case 4: {
                return String;.class;
            }
            case 5: {
                return String;.class;
            }
            case 6: {
                return String;.class;
            }
            case 7: {
                return Property;.class;
            }
        }
        return null;
    }

    public ServiceDescription getServiceDescription(int i) {
        return this.sd == null || i < 0 || i >= this.sd.length ? null : this.sd[i];
    }

    public AgentDescription getAgentDescription(int i) {
        return this.ad == null || i < 0 || i >= this.ad.length ? null : this.ad[i];
    }
}

