/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.Property;
import jadex.adapter.fipa.ServiceDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ServiceDescriptionPanel
extends JPanel {
    private JTextField name;
    private JTextField type;
    private JTextField owner;
    private JTextField agent;
    private JList onto;
    private JList lang;
    private JList proto;
    private JList props;

    public ServiceDescriptionPanel() {
        super(new GridBagLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Service Properties"));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        this.name = this.addTF(c, "Name", "", "Service name");
        this.type = this.addTF(c, "Type", "", "Service type");
        this.owner = this.addTF(c, "Ownership", "", "Service ownership");
        this.agent = this.addTF(c, "Agent", "", "The agent providing this service");
        JPanel panel = new JPanel(new GridLayout(1, 4));
        this.onto = this.addList(panel, "Ontologies", "Ontologies understood by this service");
        this.lang = this.addList(panel, "Languages", "Languages understood by this service");
        this.proto = this.addList(panel, "Protocols", "Protocols utilized by this service");
        this.props = this.addList(panel, "Properties", "Properties of this service");
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.add((Component)panel, c);
    }

    void setService(AgentDescription ad, ServiceDescription sd) {
        this.name.setText(sd.getName());
        this.name.setToolTipText(sd.getName());
        this.type.setText(sd.getType());
        this.type.setToolTipText(sd.getType());
        this.owner.setText(sd.getOwnership());
        this.owner.setToolTipText(sd.getOwnership());
        this.agent.setText(ad.getName().getName());
        String[] addrs = ad.getName().getAddresses();
        String tooltip = "<html>" + ad.getName().getName();
        for (int addr = 0; addr < addrs.length; ++addr) {
            tooltip = tooltip + "<br>" + addrs[addr];
        }
        this.agent.setToolTipText(tooltip);
        this.update(this.onto, sd.getOntologies());
        this.update(this.lang, sd.getLanguages());
        this.update(this.proto, sd.getProtocols());
        DefaultListModel model = (DefaultListModel)this.props.getModel();
        model.clear();
        Property[] items = sd.getProperties();
        for (int i = 0; i < items.length; ++i) {
            model.addElement(items[i].getName() + '=' + items[i].getValue());
        }
    }

    private void update(JList list, String[] items) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        model.clear();
        for (int i = 0; i < items.length; ++i) {
            model.addElement(items[i]);
        }
    }

    private JList addList(JPanel panel, String name, String tooltip) {
        DefaultListModel model = new DefaultListModel();
        JList list = new JList(model);
        JPanel tp = new JPanel(new BorderLayout());
        tp.setBorder(new TitledBorder(new EtchedBorder(1), name));
        list.setToolTipText(tooltip);
        JScrollPane scroll = new JScrollPane(list);
        tp.add("Center", scroll);
        panel.add(tp);
        return list;
    }

    private JTextField addTF(GridBagConstraints c, String label, String value, String tooltip) {
        c.anchor = 13;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel l = new JLabel(label + ':');
        this.add((Component)l, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = -1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JTextField tf = new JTextField(value, value.length());
        tf.setEditable(false);
        this.add((Component)tf, c);
        l.setLabelFor(tf);
        tf.setToolTipText(tooltip);
        return tf;
    }
}

