/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import [Ljadex.adapter.fipa.Property;;
import [Ljava.lang.String;;
import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.common.TableSorter;
import jadex.tools.dfbrowser.AgentIdentifierRenderer;
import jadex.tools.dfbrowser.PropertyArrayRenderer;
import jadex.tools.dfbrowser.ServiceTableModel;
import jadex.tools.dfbrowser.StringArrayRenderer;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DFServiceTable
extends JScrollPane {
    private ServiceTableModel model = new ServiceTableModel();
    private TableSorter sorter = new TableSorter(this.model);
    private JTable table = new JTable(this.sorter);

    public DFServiceTable() {
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Registered Services"));
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setPreferredScrollableViewportSize(new Dimension(800, 70));
        this.table.setDefaultRenderer(AgentIdentifier.class, new AgentIdentifierRenderer());
        this.table.setDefaultRenderer(String;.class, new StringArrayRenderer());
        this.table.setDefaultRenderer(Property;.class, new PropertyArrayRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selectedRow = DFServiceTable.this.table.getSelectedRow();
                if (e.getClickCount() > 1 && selectedRow >= 0) {
                    int n = DFServiceTable.this.sorter.modelIndex(selectedRow);
                }
            }
        });
        this.setViewportView(this.table);
    }

    public void setAgentDescriptions(AgentDescription[] ad) {
        this.model.setAgentDescriptions(ad);
    }

    public void setAgentDescription(AgentDescription agentDescription) {
        this.model.setAgentDescription(agentDescription);
    }

    public void getProperties(Properties props) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn column = cm.getColumn(i);
            props.setProperty("serviceTable.column" + i, Integer.toString(column.getWidth()));
        }
    }

    public void setProperties(Properties props) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn column = cm.getColumn(i);
            try {
                String p = props.getProperty("serviceTable.column" + i);
                if (p == null) continue;
                column.setPreferredWidth(Integer.parseInt(p));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

