/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.SearchConstraints;
import jadex.adapter.fipa.ServiceDescription;
import jadex.runtime.IGoal;
import jadex.tools.common.AgentTreeTable;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.SelectAction;
import jadex.tools.common.jtreetable.AbstractTreeTableAction;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.plugin.IAgentListListener;
import jadex.tools.dfbrowser.DFAgentTable;
import jadex.tools.dfbrowser.DFServiceTable;
import jadex.tools.dfbrowser.ServiceDescriptionPanel;
import jadex.tools.jcc.AbstractJCCPlugin;
import jadex.tools.starter.StarterPlugin;
import jadex.util.SGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DFBrowserPlugin
extends AbstractJCCPlugin
implements IAgentListListener {
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"dfbrowser", SGUI.makeIcon((Class)DFBrowserPlugin.class, (String)"/jadex/tools/common/images/new_dfbrowser.png"), "dfbrowser_sel", SGUI.makeIcon((Class)DFBrowserPlugin.class, (String)"/jadex/tools/common/images/new_dfbrowser_sel.png"), "remove_agent", SGUI.makeIcon((Class)DFBrowserPlugin.class, (String)"/jadex/tools/common/images/new_remove_service.png"), "starter", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_starter.png")});
    protected static final long REFRESH1 = 1000L;
    protected static final long REFRESH5 = 5000L;
    protected static final long REFRESH30 = 30000L;
    protected AgentTreeTable df_agents;
    protected DFAgentTable agent_table;
    protected DFServiceTable service_table;
    protected ServiceDescriptionPanel service_panel;
    protected long sleep = 5000L;
    protected AMSAgentDescription df_des;
    protected volatile Thread refresh_thread;
    protected JPanel main_panel;
    protected JSplitPane split1;
    protected JSplitPane split2;
    protected JSplitPane split3;
    protected JRadioButtonMenuItem refresh1;
    protected JRadioButtonMenuItem refresh5;
    protected JRadioButtonMenuItem refresh30;
    protected AgentDescription selected_agent;
    AgentDescription[] old_ads;
    final AbstractTreeTableAction SHOW_DF = new ShowDFAction();
    protected SelectAction REFRESH = new SelectAction("Refresh"){

        public void flagChanged(boolean flag) {
            if (DFBrowserPlugin.this.refresh_thread == null && flag) {
                DFBrowserPlugin.this.startRefreshThread();
            }
        }
    };
    final AbstractAction REMOVE_AGENT = new RemoveAgentAction();

    public String getName() {
        return "DF Browser";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("dfbrowser_sel") : icons.getIcon("dfbrowser");
    }

    public JToolBar getToolBar() {
        JToolBar bar = new JToolBar();
        JButton b = new JButton(this.REMOVE_AGENT);
        b.setBorder(null);
        b.setToolTipText(b.getText());
        b.setText(null);
        b.setEnabled(true);
        bar.add(b);
        return bar;
    }

    public JComponent getPanel() {
        this.df_agents = new AgentTreeTable();
        this.df_agents.setMinimumSize(new Dimension(0, 0));
        this.df_agents.getTreetable().setSelectionMode(0);
        this.df_agents.getTreetable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JTree tree = DFBrowserPlugin.this.df_agents.getTreetable().getTree();
                if (!e.getValueIsAdjusting() && !tree.isSelectionEmpty()) {
                    DFBrowserPlugin.this.SHOW_DF.actionPerformed(null);
                }
            }
        });
        this.df_agents.getNodeType(AgentTreeTable.NODE_AGENT).addPopupAction(this.SHOW_DF);
        this.df_agents.getTreetable().getSelectionModel().setSelectionInterval(0, 0);
        this.df_agents.getTreetable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DFBrowserPlugin.this.SHOW_DF.actionPerformed(null);
                }
            }
        });
        this.jcc.addAgentListListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DFBrowserPlugin.this.df_agents.adjustColumnWidths();
            }
        });
        this.service_panel = new ServiceDescriptionPanel();
        this.service_table = new DFServiceTable(){

            protected void serviceSelected(ServiceDescription service_description, AgentDescription agent_description) {
                DFBrowserPlugin.this.service_panel.setService(agent_description, service_description);
            }
        };
        this.agent_table = new DFAgentTable(this){

            protected void agentSelected(AgentDescription agent_description) {
                DFBrowserPlugin.this.selected_agent = agent_description;
                DFBrowserPlugin.this.service_table.setAgentDescription(agent_description);
            }

            protected void removeSelected(AgentDescription agent_description) {
                DFBrowserPlugin.this.removeAgentRegistration(agent_description);
            }
        };
        this.main_panel = new JPanel(new BorderLayout());
        this.split3 = new JSplitPane(0);
        this.split3.setDividerLocation(250);
        this.split3.add(this.service_table);
        this.split3.add(this.service_panel);
        this.split2 = new JSplitPane(0);
        this.split2.setDividerLocation(250);
        this.split2.add(this.agent_table);
        this.split2.add(this.split3);
        this.split1 = new JSplitPane(1);
        this.split1.setDividerLocation(200);
        this.split1.setOneTouchExpandable(true);
        this.split1.add(this.df_agents);
        this.split1.add(this.split2);
        this.main_panel.removeAll();
        this.main_panel.add((Component)this.split1, "Center");
        this.main_panel.validate();
        GuiProperties.setupHelp(this.split1, "tools.DFBrowser");
        return this.main_panel;
    }

    public void setProperties(Properties props) {
        try {
            this.split3.setDividerLocation(Integer.parseInt(props.getProperty("split3.location")));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.split2.setDividerLocation(Integer.parseInt(props.getProperty("split2.location")));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.split1.setDividerLocation(Integer.parseInt(props.getProperty("split1.location")));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.REFRESH.setSelected("true".equals(props.getProperty("refresh")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.agent_table.setProperties(props);
        this.service_table.setProperties(props);
        if (this.refresh1 != null) {
            this.refresh1.setSelected(this.sleep == 1000L);
        }
        if (this.refresh5 != null) {
            this.refresh5.setSelected(this.sleep == 5000L);
        }
        if (this.refresh30 != null) {
            this.refresh30.setSelected(this.sleep == 30000L);
        }
    }

    public void getProperties(Properties props) {
        props.put("split1.location", Integer.toString(this.split1.getDividerLocation()));
        props.put("split2.location", Integer.toString(this.split2.getDividerLocation()));
        props.put("split3.location", Integer.toString(this.split3.getDividerLocation()));
        props.put("refresh", Boolean.toString(this.REFRESH.isSelected()));
        this.agent_table.getProperties(props);
        this.service_table.getProperties(props);
    }

    public JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("View");
        GuiProperties.setupHelp(menu, "df_browser.menu_graph");
        menubar.add(menu);
        menu.add(this.REFRESH.getCBItem());
        ButtonGroup group = new ButtonGroup();
        this.refresh1 = new JRadioButtonMenuItem(new AbstractAction("1 s"){

            public void actionPerformed(ActionEvent e) {
                DFBrowserPlugin.this.sleep = 1000L;
            }
        });
        this.refresh1.setSelected(this.sleep == 1000L);
        group.add(this.refresh1);
        menu.add(this.refresh1);
        this.refresh5 = new JRadioButtonMenuItem(new AbstractAction("5 s"){

            public void actionPerformed(ActionEvent e) {
                DFBrowserPlugin.this.sleep = 5000L;
            }
        });
        this.refresh5.setSelected(this.sleep == 5000L);
        group.add(this.refresh5);
        menu.add(this.refresh5);
        this.refresh30 = new JRadioButtonMenuItem(new AbstractAction("30 s"){

            public void actionPerformed(ActionEvent e) {
                DFBrowserPlugin.this.sleep = 30000L;
            }
        });
        this.refresh30.setSelected(this.sleep == 30000L);
        group.add(this.refresh30);
        menu.add(this.refresh30);
        menu.addSeparator();
        return menubar;
    }

    protected void refresh() {
        if (this.df_des != null) {
            SearchConstraints constraints = new SearchConstraints();
            constraints.setMaxResults(-1);
            IGoal ft = this.getJCC().getAgent().createGoal("df_search");
            ft.getParameter("description").setValue((Object)new AgentDescription());
            ft.getParameter("constraints").setValue((Object)constraints);
            ft.getParameter("df").setValue((Object)this.df_des.getName());
            this.getJCC().getAgent().dispatchTopLevelGoalAndWait(ft);
            AgentDescription[] ads = (AgentDescription[])ft.getParameterSet("result").getValues();
            if (this.old_ads == null || !DFBrowserPlugin.equal(this.old_ads, ads)) {
                this.old_ads = ads;
                this.agent_table.setAgentDescriptions(ads);
                if (this.selected_agent == null) {
                    this.service_table.setAgentDescriptions(ads);
                } else {
                    this.showOnlyServicesFromSelectedAgent(ads);
                }
            }
        }
    }

    protected void showOnlyServicesFromSelectedAgent(AgentDescription[] ads) {
        AgentIdentifier aid = this.selected_agent.getName();
        for (int i = 0; i < ads.length; ++i) {
            if (!aid.equals((Object)ads[i].getName())) continue;
            this.service_table.setAgentDescription(ads[i]);
            return;
        }
        this.service_table.setAgentDescriptions(ads);
    }

    protected static boolean equal(AgentDescription[] ad1, AgentDescription[] ad2) {
        if (ad1.length != ad2.length) {
            return false;
        }
        for (int i = 0; i < ad1.length; ++i) {
            if (ad1[i].equals((Object)ad2[i])) continue;
            return false;
        }
        return true;
    }

    public void agentDied(final AMSAgentDescription ad) {
        if (this.df_des != null && this.df_des.getName().equals((Object)ad.getName())) {
            this.df_des = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DFBrowserPlugin.this.df_agents.removeAgent(ad);
            }
        });
    }

    public void agentBorn(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ad.getName().getName().startsWith("df@")) {
                    DFBrowserPlugin.this.df_agents.addAgent(ad);
                    if (DFBrowserPlugin.this.df_des == null) {
                        DFBrowserPlugin.this.df_des = ad;
                        DFBrowserPlugin.this.REFRESH.flagChanged(DFBrowserPlugin.this.REFRESH.isSelected());
                    }
                }
            }
        });
    }

    public void agentChanged(AMSAgentDescription ad) {
    }

    public String getHelpID() {
        return "tools.df_browser";
    }

    protected void startRefreshThread() {
        this.refresh_thread = new Thread("DFBrowser refresh thread"){

            public void run() {
                try {
                    while (DFBrowserPlugin.this.REFRESH.isSelected() && DFBrowserPlugin.this.refresh_thread == this) {
                        DFBrowserPlugin.this.refresh();
                        11.sleep(DFBrowserPlugin.this.sleep);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DFBrowserPlugin.this.refresh_thread == this) {
                    DFBrowserPlugin.this.refresh_thread = null;
                }
            }
        };
        this.refresh_thread.start();
    }

    public void shutdown() {
        this.refresh_thread = null;
    }

    protected void removeAgentRegistration(AgentDescription description) {
        try {
            IGoal deregister = this.getJCC().getAgent().createGoal("df_deregister");
            deregister.getParameter("description").setValue((Object)description);
            deregister.getParameter("df").setValue((Object)this.df_des.getName());
            this.getJCC().getAgent().dispatchTopLevelGoalAndWait(deregister, 100L);
            this.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final class RemoveAgentAction
    extends AbstractAction {
        protected RemoveAgentAction() {
            super("Remove agent registration", icons.getIcon("remove_agent"));
        }

        public void actionPerformed(ActionEvent e) {
            if (DFBrowserPlugin.this.df_des != null) {
                AgentDescription[] as = DFBrowserPlugin.this.agent_table.getSelectedAgents();
                for (int i = 0; i < as.length; ++i) {
                    DFBrowserPlugin.this.removeAgentRegistration(as[i]);
                }
                DFBrowserPlugin.this.refresh();
            }
        }
    }

    protected final class ShowDFAction
    extends AbstractTreeTableAction {
        protected ShowDFAction() {
            super("Show DF", icons.getIcon("DFBrowser"));
        }

        public void actionPerformed(ActionEvent e) {
            DefaultTreeTableNode node = (DefaultTreeTableNode)DFBrowserPlugin.this.df_agents.getTreetable().getTree().getSelectionPath().getLastPathComponent();
            if (node != null && node.getUserObject() instanceof AMSAgentDescription) {
                DFBrowserPlugin.this.main_panel.setCursor(Cursor.getPredefinedCursor(3));
                if (DFBrowserPlugin.this.selected_agent != null) {
                    DFBrowserPlugin.this.selected_agent = null;
                    DFBrowserPlugin.this.old_ads = null;
                }
                DFBrowserPlugin.this.df_des = (AMSAgentDescription)node.getUserObject();
                DFBrowserPlugin.this.refresh();
                DFBrowserPlugin.this.main_panel.setCursor(Cursor.getDefaultCursor());
            }
        }

        public boolean isSelected() {
            DefaultTreeTableNode node = (DefaultTreeTableNode)this.getValue("node");
            return node.getUserObject() == DFBrowserPlugin.this.df_des;
        }
    }
}

