/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.dfbrowser;

import [Ljadex.adapter.fipa.ServiceDescription;;
import [Ljava.lang.String;;
import jadex.adapter.fipa.AgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.common.TableSorter;
import jadex.tools.dfbrowser.AgentIdentifierRenderer;
import jadex.tools.dfbrowser.AgentTableModel;
import jadex.tools.dfbrowser.DFBrowserPlugin;
import jadex.tools.dfbrowser.LeaseTimeRenderer;
import jadex.tools.dfbrowser.ServiceDescriptionArrayRenderer;
import jadex.tools.dfbrowser.StringArrayRenderer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DFAgentTable
extends JScrollPane {
    private AgentTableModel model = new AgentTableModel();
    private TableSorter sorter = new TableSorter(this.model);
    private JTable table = new JTable(this.sorter);
    protected final JPopupMenu popup;
    protected DFBrowserPlugin browser;
    static final AgentDescription[] EMPTY = new AgentDescription[0];

    public DFAgentTable(DFBrowserPlugin browser) {
        this.browser = browser;
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Registered Agent Descriptions"));
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setPreferredScrollableViewportSize(new Dimension(800, 70));
        this.table.setDefaultRenderer(AgentIdentifier.class, new AgentIdentifierRenderer());
        this.table.setDefaultRenderer(String;.class, new StringArrayRenderer());
        this.table.setDefaultRenderer(ServiceDescription;.class, new ServiceDescriptionArrayRenderer());
        this.table.setDefaultRenderer(Date.class, new LeaseTimeRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selectedRow = DFAgentTable.this.table.getSelectedRow();
                if (e.getClickCount() > 1 && selectedRow >= 0) {
                    DFAgentTable.this.agentSelected(DFAgentTable.this.model.getAgentDescription(DFAgentTable.this.sorter.modelIndex(selectedRow)));
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DFAgentTable.this.showPopUp(e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DFAgentTable.this.showPopUp(e.getX(), e.getY());
                }
            }
        });
        this.setViewportView(this.table);
        this.popup = new JPopupMenu();
        this.addMenuItems(this.popup);
    }

    protected void addMenuItems(JPopupMenu menu) {
        menu.add(new JMenuItem(new AbstractAction("Remove agent description"){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = DFAgentTable.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    DFAgentTable.this.browser.removeAgentRegistration(DFAgentTable.this.model.getAgentDescription(DFAgentTable.this.sorter.modelIndex(selectedRow)));
                }
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Show services"){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = DFAgentTable.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    DFAgentTable.this.agentSelected(DFAgentTable.this.model.getAgentDescription(DFAgentTable.this.sorter.modelIndex(selectedRow)));
                }
            }
        }));
    }

    protected void showPopUp(int x, int y) {
        this.popup.show(this, x, y);
    }

    protected void agentSelected(AgentDescription agentDescription) {
    }

    public AgentDescription[] getSelectedAgents() {
        int count = this.table.getSelectedRowCount();
        if (count == 0) {
            return EMPTY;
        }
        ArrayList<AgentDescription> sa = new ArrayList<AgentDescription>();
        int[] rows = this.table.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            sa.add(this.model.getAgentDescription(this.sorter.modelIndex(rows[i])));
        }
        return sa.toArray(new AgentDescription[sa.size()]);
    }

    public void setAgentDescriptions(AgentDescription[] ad) {
        this.model.setAgentDescriptions(ad);
    }

    public void getProperties(Properties props) {
        TableColumnModel cm = this.table.getColumnModel();
        int cc = cm.getColumnCount();
        while (cc > 0) {
            TableColumn column = cm.getColumn(--cc);
            props.setProperty("agentTable.column" + cc, Integer.toString(column.getWidth()));
        }
    }

    public void setProperties(Properties props) {
        TableColumnModel cm = this.table.getColumnModel();
        int cc = cm.getColumnCount();
        while (cc > 0) {
            TableColumn column = cm.getColumn(--cc);
            try {
                String p = props.getProperty("agentTable.column" + cc);
                if (p == null) continue;
                column.setPreferredWidth(Integer.parseInt(p));
            }
            catch (Exception e) {}
        }
    }
}

