/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.convcenter;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.AgentDeathException;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IParameter;
import jadex.runtime.IParameterSet;
import jadex.runtime.externalaccesswrapper.ElementWrapper;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterSet;
import jadex.tools.common.FipaMessagePanel;
import jadex.tools.common.GuiProperties;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import nuggets.Nuggets;

public class FipaConversationPanel
extends JSplitPane {
    protected static UIDefaults icons = new UIDefaults(new Object[]{"new_message", SGUI.makeIcon((Class)FipaConversationPanel.class, (String)"/jadex/tools/common/images/new_new_message.png"), "sent_message", SGUI.makeIcon((Class)FipaConversationPanel.class, (String)"/jadex/tools/common/images/new_sent_message.png"), "received_message", SGUI.makeIcon((Class)FipaConversationPanel.class, (String)"/jadex/tools/common/images/new_received_message.png")});
    protected IExternalAccess agent;
    protected AgentIdentifier receiver;
    protected JTabbedPane tabs;
    protected FipaMessagePanel sendpanel;
    protected JList sentmsgs;
    protected JList receivedmsgs;

    public FipaConversationPanel(final IExternalAccess agent, AgentIdentifier default_receiver) {
        super(1, true);
        this.setOneTouchExpandable(true);
        this.agent = agent;
        this.receiver = default_receiver;
        IMessageEvent msg = agent.getEventbase().createMessageEvent("fipamsg");
        msg.getParameter("sender").setValue((Object)agent.getAgentIdentifier());
        if (default_receiver != null) {
            msg.getParameterSet("receivers").addValue((Object)default_receiver);
        }
        this.sendpanel = new FipaMessagePanel(msg, agent);
        JButton send = new JButton("Send");
        send.setToolTipText("Send the specified message");
        send.putClientProperty("auto-adjust", Boolean.TRUE);
        send.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    IMessageEvent msgevent = FipaConversationPanel.this.cloneMessage(FipaConversationPanel.this.sendpanel.getMessage());
                    agent.getEventbase().sendMessage(msgevent);
                    ((DefaultListModel)FipaConversationPanel.this.sentmsgs.getModel()).addElement(msgevent);
                }
                catch (Exception e) {
                    String text = SUtil.wrapText((String)("Could not send message: " + e.getMessage()));
                    JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)FipaConversationPanel.this), text, "Message Error", 1);
                }
            }
        });
        JButton reset = new JButton("Reset");
        reset.setToolTipText("Reset all specified message values");
        reset.putClientProperty("auto-adjust", Boolean.TRUE);
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FipaConversationPanel.this.resetMessage();
            }
        });
        JPanel sendcont = new JPanel(new BorderLayout());
        sendcont.add("Center", this.sendpanel);
        JPanel south = new JPanel(new FlowLayout(2));
        south.add(send);
        south.add(reset);
        HelpBroker hb = GuiProperties.setupHelp(this, "tools.conversationcenter");
        if (hb != null) {
            JButton help = new JButton("Help");
            help.setToolTipText("Open the Javahelp for the Conversation Center");
            help.putClientProperty("auto-adjust", Boolean.TRUE);
            help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
            south.add(help);
        }
        sendcont.add("South", south);
        final JScrollPane sendtab = new JScrollPane(sendcont);
        sendtab.setBorder(null);
        JPanel lists = new JPanel(new GridBagLayout());
        GridBagConstraints gbcons = new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0);
        this.sentmsgs = new JList(new DefaultListModel());
        this.sentmsgs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && FipaConversationPanel.this.sentmsgs.locationToIndex(e.getPoint()) != -1) {
                    IMessageEvent msg = (IMessageEvent)FipaConversationPanel.this.sentmsgs.getModel().getElementAt(FipaConversationPanel.this.sentmsgs.locationToIndex(e.getPoint()));
                    JPanel msgtab = new JPanel(new BorderLayout());
                    FipaMessagePanel msgpanel = new FipaMessagePanel(msg, agent);
                    msgpanel.setEditable(false);
                    JScrollPane scroll = new JScrollPane(msgtab);
                    scroll.setBorder(null);
                    JButton edit = new JButton("Edit");
                    edit.setToolTipText("Edit this sent message");
                    edit.putClientProperty("auto-adjust", Boolean.TRUE);
                    edit.addActionListener(new ActionListener(this, msg){
                        private final /* synthetic */ IMessageEvent val$msg;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$msg = val$msg;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            3.access$000(this.this$1).sendpanel.setMessage(3.access$000(this.this$1).cloneMessage(this.val$msg));
                            3.access$000(this.this$1).tabs.setSelectedComponent(3.access$100(this.this$1));
                        }
                    });
                    JButton send = new JButton("Resend");
                    send.setMargin(new Insets(2, 2, 2, 2));
                    send.setToolTipText("Send this message again");
                    send.putClientProperty("auto-adjust", Boolean.TRUE);
                    send.addActionListener(new ActionListener(this, msg){
                        private final /* synthetic */ IMessageEvent val$msg;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$msg = val$msg;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            try {
                                IMessageEvent clone = 3.access$000(this.this$1).cloneMessage(this.val$msg);
                                3.access$200(this.this$1).getEventbase().sendMessage(clone);
                                ((DefaultListModel)3.access$000(this.this$1).sentmsgs.getModel()).addElement(clone);
                            }
                            catch (Exception e) {
                                String text = SUtil.wrapText((String)("Could not send message: " + e.getMessage()));
                                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)3.access$000(this.this$1)), text, "Message Error", 1);
                            }
                        }
                    });
                    JButton reset = new JButton("Close");
                    reset.setToolTipText("Close displayed message");
                    reset.putClientProperty("auto-adjust", Boolean.TRUE);
                    reset.addActionListener(new ActionListener(this, scroll){
                        private final /* synthetic */ JScrollPane val$scroll;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$scroll = val$scroll;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            3.access$000(this.this$1).tabs.remove(this.val$scroll);
                        }
                    });
                    msgtab.add("Center", msgpanel);
                    JPanel south = new JPanel(new FlowLayout(2));
                    south.add(edit);
                    south.add(send);
                    south.add(reset);
                    msgtab.add("South", south);
                    String title = "" + msg;
                    if (title.length() > 25) {
                        title = title.substring(0, 21) + "...)";
                    }
                    FipaConversationPanel.this.tabs.addTab(title, icons.getIcon("sent_message"), scroll);
                    FipaConversationPanel.this.tabs.setSelectedComponent(scroll);
                    SGUI.adjustComponentSizes((Container)FipaConversationPanel.this);
                }
            }

            static /* synthetic */ FipaConversationPanel access$000(3 x0) {
                return x0.FipaConversationPanel.this;
            }

            static /* synthetic */ JScrollPane access$100(3 x0) {
                return x0.sendtab;
            }

            static /* synthetic */ IExternalAccess access$200(3 x0) {
                return x0.agent;
            }
        });
        JPanel cpane = new JPanel(new BorderLayout());
        cpane.add("Center", new JScrollPane(this.sentmsgs));
        cpane.setBorder(new TitledBorder(new EtchedBorder(1), " Sent Messages "));
        lists.add((Component)cpane, gbcons);
        ++gbcons.gridy;
        this.receivedmsgs = new JList(new DefaultListModel());
        this.receivedmsgs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int idx;
                if (e.getClickCount() == 2 && (idx = FipaConversationPanel.this.receivedmsgs.locationToIndex(e.getPoint())) != -1) {
                    IMessageEvent msg = (IMessageEvent)FipaConversationPanel.this.receivedmsgs.getModel().getElementAt(idx);
                    JPanel msgtab = new JPanel(new BorderLayout());
                    FipaMessagePanel msgpanel = new FipaMessagePanel(msg, agent);
                    msgpanel.setEditable(false);
                    JScrollPane scroll = new JScrollPane(msgtab);
                    scroll.setBorder(null);
                    JButton reply = new JButton("Reply");
                    reply.setToolTipText("Set up a reply message");
                    reply.putClientProperty("auto-adjust", Boolean.TRUE);
                    reply.addActionListener(new ActionListener(this, msg){
                        private final /* synthetic */ IMessageEvent val$msg;
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$msg = val$msg;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            IMessageEvent reply = this.val$msg.createReply("fipamsg");
                            reply.getParameter("sender").setValue((Object)7.access$300(this.this$1).getAgentIdentifier());
                            7.access$400(this.this$1).sendpanel.setMessage(reply);
                            7.access$400(this.this$1).tabs.setSelectedComponent(7.access$500(this.this$1));
                        }
                    });
                    JButton reset = new JButton("Close");
                    reset.setToolTipText("Close this message view");
                    reset.putClientProperty("auto-adjust", Boolean.TRUE);
                    reset.addActionListener(new ActionListener(this, scroll){
                        private final /* synthetic */ JScrollPane val$scroll;
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$scroll = val$scroll;
                        }

                        public void actionPerformed(ActionEvent ae) {
                            7.access$400(this.this$1).tabs.remove(this.val$scroll);
                        }
                    });
                    msgtab.add("Center", msgpanel);
                    JPanel south = new JPanel(new FlowLayout(2));
                    south.add(reply);
                    south.add(reset);
                    msgtab.add("South", south);
                    String title = "" + msg;
                    if (title.length() > 25) {
                        title = title.substring(0, 21) + "...)";
                    }
                    FipaConversationPanel.this.tabs.addTab(title, icons.getIcon("received_message"), scroll);
                    FipaConversationPanel.this.tabs.setSelectedComponent(scroll);
                    SGUI.adjustComponentSizes((Container)FipaConversationPanel.this);
                }
            }

            static /* synthetic */ IExternalAccess access$300(7 x0) {
                return x0.agent;
            }

            static /* synthetic */ FipaConversationPanel access$400(7 x0) {
                return x0.FipaConversationPanel.this;
            }

            static /* synthetic */ JScrollPane access$500(7 x0) {
                return x0.sendtab;
            }
        });
        cpane = new JPanel(new BorderLayout());
        cpane.add("Center", new JScrollPane(this.receivedmsgs));
        cpane.setBorder(new TitledBorder(new EtchedBorder(1), " Received Messages "));
        lists.add((Component)cpane, gbcons);
        ++gbcons.gridy;
        gbcons.weighty = 0.0;
        cpane = new JPanel(new FlowLayout(2));
        JButton clear = new JButton("Clear");
        clear.setToolTipText("Clear the lists of sent and received messages");
        clear.putClientProperty("auto-adjust", Boolean.TRUE);
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DefaultListModel)FipaConversationPanel.this.sentmsgs.getModel()).removeAllElements();
                ((DefaultListModel)FipaConversationPanel.this.receivedmsgs.getModel()).removeAllElements();
                while (FipaConversationPanel.this.tabs.getComponentCount() > 1) {
                    FipaConversationPanel.this.tabs.remove(1);
                }
            }
        });
        cpane.add(clear);
        lists.add((Component)cpane, gbcons);
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Send", icons.getIcon("new_message"), sendtab);
        this.add(lists);
        this.add(this.tabs);
        SGUI.adjustComponentSizes((Container)this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FipaConversationPanel.this.setDividerLocation(0.35);
            }
        });
    }

    public void addMessage(final IMessageEvent msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((DefaultListModel)FipaConversationPanel.this.receivedmsgs.getModel()).addElement(msg);
            }
        });
    }

    public void reset() {
        this.resetMessage();
        this.setSentMessages(new IMessageEvent[0]);
        this.setReceivedMessages(new IMessageEvent[0]);
        while (this.tabs.getTabCount() > 1) {
            this.tabs.removeTabAt(this.tabs.getTabCount() - 1);
        }
    }

    public void resetMessage() {
        IMessageEvent msg = this.agent.getEventbase().createMessageEvent("fipamsg");
        msg.getParameter("sender").setValue((Object)this.agent.getAgentIdentifier());
        if (this.receiver != null) {
            msg.getParameterSet("receivers").addValue((Object)this.receiver);
        }
        this.sendpanel.setMessage(msg);
    }

    public IMessageEvent cloneMessage(IMessageEvent msg) {
        IMessageEvent clone = this.agent.createMessageEvent(msg.getType());
        IParameter[] params = msg.getParameters();
        for (int i = 0; i < params.length; ++i) {
            clone.getParameter(params[i].getName()).setValue(msg.getParameter(params[i].getName()).getValue());
        }
        IParameterSet[] paramsets = msg.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            Object[] vals = msg.getParameterSet(paramsets[i].getName()).getValues();
            clone.getParameterSet(paramsets[i].getName()).removeValues();
            for (int j = 0; j < vals.length; ++j) {
                clone.getParameterSet(paramsets[i].getName()).addValue(vals[j]);
            }
        }
        return clone;
    }

    public FipaMessagePanel getMessagePanel() {
        return this.sendpanel;
    }

    public IMessageEvent[] getSentMessages() {
        DefaultListModel model = (DefaultListModel)this.sentmsgs.getModel();
        Object[] ret = new IMessageEvent[model.getSize()];
        model.copyInto(ret);
        return ret;
    }

    public void setSentMessages(final IMessageEvent[] msgs) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultListModel model = (DefaultListModel)FipaConversationPanel.this.sentmsgs.getModel();
                model.removeAllElements();
                for (int i = 0; i < msgs.length; ++i) {
                    model.addElement(msgs[i]);
                }
            }
        });
    }

    public void setReceivedMessages(final IMessageEvent[] msgs) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultListModel model = (DefaultListModel)FipaConversationPanel.this.receivedmsgs.getModel();
                model.removeAllElements();
                for (int i = 0; i < msgs.length; ++i) {
                    model.addElement(msgs[i]);
                }
            }
        });
    }

    public void setProperties(Properties ps) {
        String msg = ps.getProperty("lastmessage");
        IMessageEvent message = null;
        if (msg != null) {
            try {
                message = this.decodeMessage(msg);
                message.getParameter("sender").setValue((Object)this.agent.getAgentIdentifier());
            }
            catch (Exception e) {
                String text = SUtil.wrapText((String)("Could not decode stored message: " + e.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), text, "Message problem", 1);
            }
        }
        if (message != null) {
            this.getMessagePanel().setMessage(message);
        } else {
            this.resetMessage();
        }
        ArrayList<IMessageEvent> sentmsgs = new ArrayList<IMessageEvent>();
        for (int i = 0; i < 5 && (msg = ps.getProperty("sentmessage" + i)) != null; ++i) {
            try {
                message = this.decodeMessage(msg);
                message.getParameter("sender").setValue((Object)this.agent.getAgentIdentifier());
                sentmsgs.add(0, message);
                continue;
            }
            catch (Exception e) {
                String text = SUtil.wrapText((String)("Could not decode stored message: " + e.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), text, "Message problem", 1);
            }
        }
        this.setSentMessages(sentmsgs.toArray(new IMessageEvent[sentmsgs.size()]));
    }

    public IMessageEvent decodeMessage(String msg) {
        Map map = (Map)Nuggets.objectFromXML((String)msg);
        IMessageEvent message = this.agent.createMessageEvent((String)map.get("encoded-message-type"));
        IParameter[] params = message.getParameters();
        for (int i = 0; i < params.length; ++i) {
            params[i].setValue(map.get(params[i].getName()));
        }
        IParameterSet[] paramsets = message.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            if (map.get(paramsets[i].getName()) == null) continue;
            paramsets[i].removeValues();
            paramsets[i].addValues((Object[])map.get(paramsets[i].getName()));
        }
        return message;
    }

    public void getProperties(Properties ps) {
        IMessageEvent message = this.getMessagePanel().getMessage();
        String msg = this.encodeMessage(message);
        ps.setProperty("lastmessage", msg);
        IMessageEvent[] msgs = this.getSentMessages();
        HashSet<String> saved = new HashSet<String>();
        for (int i = msgs.length - 1; i >= 0 && saved.size() < 5; --i) {
            msg = this.encodeMessage(msgs[i]);
            if (saved.contains(msg)) continue;
            ps.setProperty("sentmessage" + saved.size(), msg);
            saved.add(msg);
        }
    }

    public String encodeMessage(IMessageEvent message) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("encoded-message-type", message.getType());
            IParameter[] params = message.getParameters();
            for (int i = 0; i < params.length; ++i) {
                map.put(params[i].getName(), params[i].getValue());
            }
            IParameterSet[] paramsets = message.getParameterSets();
            for (int i = 0; i < paramsets.length; ++i) {
                map.put(paramsets[i].getName(), paramsets[i].getValues());
            }
            String msg = Nuggets.objectToXML(map);
            return msg;
        }
        catch (AgentDeathException e) {
            IRMessageEvent msg = (IRMessageEvent)((ElementWrapper)message).unwrap();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("encoded-message-type", msg.getType());
            IRParameter[] params = msg.getParameters();
            for (int i = 0; i < params.length; ++i) {
                map.put(params[i].getName(), params[i].getValue());
            }
            IRParameterSet[] paramsets = msg.getParameterSets();
            for (int i = 0; i < paramsets.length; ++i) {
                map.put(paramsets[i].getName(), paramsets[i].getValues());
            }
            return Nuggets.objectToXML(map);
        }
    }
}

