/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.convcenter;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.IMessageEvent;
import jadex.runtime.IParameterSet;
import jadex.tools.common.AgentTreeTable;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.plugin.IAgentListListener;
import jadex.tools.common.plugin.IMessageListener;
import jadex.tools.convcenter.FipaConversationPanel;
import jadex.tools.jcc.AbstractJCCPlugin;
import jadex.tools.starter.StarterPlugin;
import jadex.util.SGUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;

public class ConversationPlugin
extends AbstractJCCPlugin
implements IAgentListListener,
IMessageListener {
    public static final String LAST_MESSAGE = "lastmessage";
    public static final String SENT_MESSAGE = "sentmessage";
    public static final String ENCODED_MESSAGE_TYPE = "encoded-message-type";
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"conversation", SGUI.makeIcon((Class)ConversationPlugin.class, (String)"/jadex/tools/common/images/new_conversation.png"), "conversation_sel", SGUI.makeIcon((Class)StarterPlugin.class, (String)"/jadex/tools/common/images/new_conversation_sel.png"), "help", SGUI.makeIcon((Class)ConversationPlugin.class, (String)"/jadex/tools/common/images/help.gif")});
    private AgentTreeTable agents;
    private FipaConversationPanel convcenter;
    final AbstractAction SEND_MESSAGE = new AbstractAction("Send Message", icons.getIcon("conversation")){

        public void actionPerformed(ActionEvent e) {
            DefaultTreeTableNode node = (DefaultTreeTableNode)ConversationPlugin.this.agents.getTreetable().getTree().getSelectionPath().getLastPathComponent();
            AMSAgentDescription desc = (AMSAgentDescription)node.getUserObject();
            AgentIdentifier receiver = (AgentIdentifier)desc.getName().clone();
            IMessageEvent message = ConversationPlugin.this.convcenter.getMessagePanel().getMessage();
            IParameterSet rcvs = message.getParameterSet("receivers");
            if (rcvs.containsValue((Object)receiver)) {
                rcvs.removeValue((Object)receiver);
            } else {
                rcvs.addValue((Object)receiver);
            }
            ConversationPlugin.this.convcenter.getMessagePanel().setMessage(message);
        }
    };

    public String getName() {
        return "Conversation Center";
    }

    public Icon getToolIcon(boolean selected) {
        return selected ? icons.getIcon("conversation_sel") : icons.getIcon("conversation");
    }

    public JComponent getPanel() {
        JSplitPane split = new JSplitPane(1, true);
        split.setOneTouchExpandable(true);
        this.agents = new AgentTreeTable();
        this.agents.setMinimumSize(new Dimension(0, 0));
        split.add(this.agents);
        this.agents.getTreetable().setSelectionMode(0);
        this.agents.getNodeType(AgentTreeTable.NODE_AGENT).addPopupAction(this.SEND_MESSAGE);
        this.convcenter = new FipaConversationPanel(this.getJCC().getAgent(), null);
        split.add(this.convcenter);
        GuiProperties.setupHelp(split, "tools.conversationcenter");
        this.agents.getTreetable().getSelectionModel().setSelectionInterval(0, 0);
        split.setDividerLocation(150);
        this.agents.getTreetable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ConversationPlugin.this.SEND_MESSAGE.actionPerformed(null);
                }
            }
        });
        this.jcc.addAgentListListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConversationPlugin.this.agents.adjustColumnWidths();
            }
        });
        this.jcc.addMessageListener(this);
        return split;
    }

    public boolean processMessage(IMessageEvent message) {
        boolean processed = false;
        try {
            String onto = (String)message.getParameter("ontology").getValue();
            if (onto == null || !onto.startsWith("jadex.tools")) {
                this.convcenter.addMessage(message);
                processed = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return processed;
    }

    public void setProperties(Properties ps) {
        this.convcenter.setProperties(ps);
    }

    public void getProperties(Properties ps) {
        this.convcenter.getProperties(ps);
    }

    public void agentDied(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConversationPlugin.this.agents.removeAgent(ad);
            }
        });
    }

    public void agentBorn(final AMSAgentDescription ad) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConversationPlugin.this.agents.addAgent(ad);
            }
        });
    }

    public void agentChanged(AMSAgentDescription ad) {
    }

    public String getHelpID() {
        return "tools.conversationcenter";
    }

    public void reset() {
        this.convcenter.reset();
    }
}

