/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common.jtreetable;

import jadex.tools.common.IValidator;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;

public class TreeTableNodeType {
    protected TreeTableNodeType supertype;
    protected String name;
    protected Icon[] icons;
    protected String[] columns;
    protected String[] columnnames;
    protected boolean[] editable;
    protected boolean[] excludes;
    protected IValidator[] validators;
    protected List actions;

    public TreeTableNodeType(String name, Icon[] icons, TreeTableNodeType supertype) {
        this(name, icons, null, null);
        this.supertype = supertype;
    }

    public TreeTableNodeType(String name, Icon[] icons, String[] columns, String[] columnnames) {
        this.name = name;
        this.icons = icons;
        this.columns = columns;
        this.columnnames = columnnames;
        this.actions = new ArrayList();
    }

    public TreeTableNodeType getSupertype() {
        return this.supertype;
    }

    public String getName() {
        return this.name;
    }

    public void addIcon(Icon icon) {
        Icon[] tmp = new Icon[this.icons != null ? this.icons.length + 1 : 1];
        for (int i = 0; this.icons != null && i < this.icons.length; ++i) {
            tmp[i] = this.icons[i];
        }
        tmp[tmp.length - 1] = icon;
        this.icons = tmp;
    }

    public Icon getIcon(Object value) {
        return this.selectIcon(value) == null ? this.supertype.selectIcon(value) : this.selectIcon(value);
    }

    public Icon selectIcon(Object value) {
        return this.icons != null ? this.icons[0] : null;
    }

    public String[] getColumns() {
        return this.columns == null && this.supertype != null ? this.supertype.getColumns() : this.columns;
    }

    public String[] getColumnNames() {
        return this.columnnames == null && this.supertype != null ? this.supertype.getColumnNames() : this.columnnames;
    }

    public boolean isColumnEditable(int column) {
        return this.editable == null && this.supertype != null ? this.supertype.isColumnEditable(column) : this.editable != null && this.editable.length > column && this.editable[column];
    }

    public boolean isColumnExcluded(int column) {
        return this.excludes == null && this.supertype != null ? this.supertype.isColumnExcluded(column) : this.excludes != null && this.excludes.length > column && this.excludes[column];
    }

    public void addExclude(String column) {
        String[] columns = this.getColumns();
        if (this.excludes == null) {
            this.excludes = new boolean[columns.length];
        }
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equals(column)) continue;
            this.excludes[i] = true;
            break;
        }
    }

    public void setEditable(String column) {
        String[] columns = this.getColumns();
        if (this.editable == null) {
            this.editable = new boolean[columns.length];
        }
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equals(column)) continue;
            this.editable[i] = true;
            break;
        }
    }

    public void addPopupAction(Action action) {
        this.actions.add(action);
    }

    public Action[] getPopupActions() {
        Action[] all = this.actions.toArray(new Action[this.actions.size()]);
        if (this.supertype != null) {
            all = (Action[])SUtil.joinArrays((Object)this.supertype.getPopupActions(), (Object)all);
        }
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].isEnabled()) continue;
            ret.add(all[i]);
        }
        return ret.toArray(new Action[ret.size()]);
    }

    public IValidator getValidator(int column) {
        return this.validators != null && this.validators.length > column && this.validators[column] != null ? this.validators[column] : (this.supertype != null ? this.supertype.getValidator(column) : null);
    }

    public void setValidator(String column, IValidator validator) {
        String[] columns = this.getColumns();
        if (this.validators == null) {
            this.validators = new IValidator[columns.length];
        }
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equals(column)) continue;
            this.validators[i] = validator;
            break;
        }
    }
}

