/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common.jtreetable;

import jadex.tools.common.jtreetable.TreeTableModel;
import jadex.tools.common.jtreetable.TreeTableNode;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    JTree tree;
    TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                int row = TreeTableModelAdapter.this.tree.getRowForPath(event.getPath());
                if (row != -1) {
                    TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                    if (event.getPath().getLastPathComponent() instanceof TreeTableNode) {
                        int childcount = ((TreeTableNode)event.getPath().getLastPathComponent()).getChildCount();
                        if (childcount > 0) {
                            TreeTableModelAdapter.this.fireTableRowsInserted(row + 1, row + 1 + childcount);
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                int row = TreeTableModelAdapter.this.tree.getRowForPath(event.getPath());
                if (row != -1) {
                    TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                    if (event.getPath().getLastPathComponent() instanceof TreeTableNode) {
                        int childcount = ((TreeTableNode)event.getPath().getLastPathComponent()).getChildCount();
                        if (childcount > 0) {
                            TreeTableModelAdapter.this.fireTableRowsDeleted(row + 1, row + 1 + childcount);
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(this, e){
                    private final /* synthetic */ TreeModelEvent val$e;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        int row = 2.access$000(this.this$1).tree.getRowForPath(new TreePath(this.val$e.getPath()));
                        if (row != -1 && 2.access$000(this.this$1).tree.isExpanded(row)) {
                            int[] rows = this.val$e.getChildIndices();
                            2.access$000(this.this$1).fireTableRowsUpdated(row + 1 + rows[0], row + 1 + rows[rows.length - 1]);
                        }
                    }
                });
            }

            public void treeNodesInserted(TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(this, e){
                    private final /* synthetic */ TreeModelEvent val$e;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        int row = 2.access$000(this.this$1).tree.getRowForPath(new TreePath(this.val$e.getPath()));
                        if (row != -1 && 2.access$000(this.this$1).tree.isExpanded(row)) {
                            2.access$000(this.this$1).fireTableRowsUpdated(row, row);
                            int[] rows = this.val$e.getChildIndices();
                            2.access$000(this.this$1).fireTableRowsInserted(row + 1 + rows[0], row + 1 + rows[rows.length - 1]);
                        }
                    }
                });
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(this, e){
                    private final /* synthetic */ TreeModelEvent val$e;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        int row = 2.access$000(this.this$1).tree.getRowForPath(new TreePath(this.val$e.getPath()));
                        if (row != -1 && 2.access$000(this.this$1).tree.isExpanded(row)) {
                            2.access$000(this.this$1).fireTableRowsUpdated(row, row);
                            int[] rows = this.val$e.getChildIndices();
                            2.access$000(this.this$1).fireTableRowsDeleted(row + 1 + rows[0], row + 1 + rows[rows.length - 1]);
                        }
                    }
                });
            }

            public void treeStructureChanged(TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$000(this.this$1).fireTableStructureChanged();
                    }
                });
            }

            static /* synthetic */ TreeTableModelAdapter access$000(2 x0) {
                return x0.TreeTableModelAdapter.this;
            }
        });
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }
}

