/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common.jtreetable;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class TreeExpansionHandler
implements TreeExpansionListener,
TreeModelListener {
    protected JTree tree;
    protected Set expanded;

    public TreeExpansionHandler(JTree tree) {
        this.tree = tree;
        this.expanded = new HashSet();
        tree.addTreeExpansionListener(this);
        tree.getModel().addTreeModelListener(this);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.expanded.add(event.getPath().getLastPathComponent());
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        this.expanded.remove(event.getPath().getLastPathComponent());
    }

    public void treeNodesChanged(TreeModelEvent event) {
    }

    public void treeNodesInserted(TreeModelEvent event) {
        this.handlePath(event.getTreePath());
    }

    public void treeNodesRemoved(TreeModelEvent event) {
        Object[] children = event.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.expanded.remove(children[i]);
        }
    }

    public void treeStructureChanged(final TreeModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreePath path;
                TreePath root = event.getTreePath();
                for (int i = Math.max(TreeExpansionHandler.this.tree.getRowForPath(root), 0); i < TreeExpansionHandler.this.tree.getRowCount() && root.isDescendant(path = TreeExpansionHandler.this.tree.getPathForRow(i)); ++i) {
                    TreeExpansionHandler.this.handlePath(path);
                }
            }
        });
    }

    protected void handlePath(TreePath path) {
        if (this.expanded.contains(path.getLastPathComponent())) {
            this.tree.expandPath(path);
        }
    }
}

