/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common.jtreetable;

import jadex.tools.common.jtreetable.AbstractTreeTableModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.tree.TreeNode;

public class DynamicTreeTableModel
extends AbstractTreeTableModel {
    private String[] columnNames;
    private String[] methodNames;
    private String[] setterMethodNames;
    private Class[] cTypes;

    public DynamicTreeTableModel(TreeNode root, String[] columnNames, String[] getterMethodNames, String[] setterMethodNames, Class[] cTypes) {
        super(root);
        this.columnNames = columnNames;
        this.methodNames = getterMethodNames;
        this.setterMethodNames = setterMethodNames;
        this.cTypes = cTypes;
    }

    public int getChildCount(Object node) {
        return ((TreeNode)node).getChildCount();
    }

    public Object getChild(Object node, int i) {
        return ((TreeNode)node).getChildAt(i);
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.columnNames[column];
    }

    public Class getColumnClass(int column) {
        if (this.cTypes == null || column < 0 || column >= this.cTypes.length) {
            return null;
        }
        return this.cTypes[column];
    }

    public Object getValueAt(Object node, int column) {
        try {
            Method method = node.getClass().getMethod(this.methodNames[column], null);
            if (method != null) {
                return method.invoke(node, (Object[])null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isCellEditable(Object node, int column) {
        return this.setterMethodNames != null && this.setterMethodNames[column] != null;
    }

    public void setValueAt(Object aValue, Object node, int column) {
        boolean found = false;
        try {
            Method[] methods = node.getClass().getMethods();
            for (int counter = methods.length - 1; counter >= 0; --counter) {
                if (!methods[counter].getName().equals(this.setterMethodNames[column]) || methods[counter].getParameterTypes() == null || methods[counter].getParameterTypes().length != 1) continue;
                Class<?> param = methods[counter].getParameterTypes()[0];
                if (!param.isInstance(aValue)) {
                    if (aValue instanceof String && ((String)aValue).length() == 0) {
                        aValue = null;
                    } else {
                        Constructor<?> cs = param.getConstructor(String.class);
                        aValue = cs != null ? cs.newInstance(aValue) : null;
                    }
                }
                methods[counter].invoke(node, aValue);
                found = true;
                break;
            }
        }
        catch (Throwable th) {
            System.out.println("exception: " + th);
        }
        if (found) {
            TreeNode parent = ((TreeNode)node).getParent();
            this.fireTreeNodesChanged(this, this.getPathToRoot(parent), new int[]{this.getIndexOfChild(parent, node)}, new Object[]{node});
        }
    }
}

