/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.runtime.IFilter;
import jadex.runtime.IMessageEvent;
import jadex.runtime.MessageEventFilter;
import jadex.runtime.Plan;
import jadex.tools.common.IToolPanel;
import jadex.tools.ontology.CurrentState;
import javax.swing.SwingUtilities;

public class ToolUpdatePlan
extends Plan {
    protected IToolPanel tool;

    public ToolUpdatePlan(IToolPanel tool) {
        this.tool = tool;
    }

    public void body() {
        MessageEventFilter filter = new MessageEventFilter("tool_inform");
        filter.addValue("conversation-id", (Object)this.tool.getId());
        this.getWaitqueue().addFilter((IFilter)filter);
        this.tool.activate();
        while (this.tool.isActive()) {
            IMessageEvent msg = (IMessageEvent)this.waitFor((IFilter)filter);
            CurrentState state = (CurrentState)msg.getContent();
            this.tool.update(state);
            this.sendMessage(msg.createReply("tool_acknowledge"));
        }
    }

    public void aborted() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolUpdatePlan.this.tool.deactivate();
            }
        });
    }
}

