/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SwingWorker
extends Timer
implements ActionListener {
    protected static final int TIME_SLICE = 50;
    protected Set tasks;
    protected static SwingWorker worker = new SwingWorker();

    protected SwingWorker() {
        super(60, null);
        this.addActionListener(this);
        this.tasks = new HashSet();
    }

    public void actionPerformed(ActionEvent arg0) {
        long starttime = System.currentTimeMillis();
        boolean removed = false;
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            try {
                TaskInfo task = (TaskInfo)it.next();
                task.execute();
                if (!task.isFinished()) continue;
                removed = true;
                it.remove();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                if (removed) continue;
                removed = true;
                it.remove();
            }
        }
        if (removed) {
            if (this.tasks.isEmpty()) {
                this.stop();
            } else {
                this.calculateSlices();
            }
        }
    }

    protected void calculateSlices() {
        double total = 0.0;
        Iterator i = this.tasks.iterator();
        while (i.hasNext()) {
            total += ((TaskInfo)i.next()).getPriority();
        }
        double adjust = total > 1.0 ? total : 1.0;
        Iterator i2 = this.tasks.iterator();
        while (i2.hasNext()) {
            TaskInfo task = (TaskInfo)i2.next();
            task.setSlice((long)(50.0 * task.getPriority() / adjust));
        }
    }

    protected void addTask(TaskInfo ti) {
        if (SwingWorker.worker.tasks.add(ti)) {
            worker.calculateSlices();
            worker.restart();
        }
    }

    public static void addTask(Task task, double priority) {
        final TaskInfo ti = new TaskInfo(task, priority);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                worker.addTask(ti);
            }
        });
    }

    public static void main(String[] args) {
        SwingWorker.addTask(new Task(){

            public boolean execute() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Here is task 2");
                return true;
            }
        }, 0.1);
    }

    public static interface Task {
        public boolean execute();
    }

    public static class TaskInfo {
        protected Task task;
        protected double priority;
        protected long slice;
        protected boolean finished;

        public TaskInfo(Task task, double priority) {
            this.task = task;
            this.priority = priority;
        }

        public double getPriority() {
            return this.priority;
        }

        public void setSlice(long slice) {
            this.slice = slice;
        }

        public void execute() {
            long starttime = System.currentTimeMillis();
            int i = 0;
            while (!((long)i >= this.slice && this.slice <= 10L || this.finished || System.currentTimeMillis() - starttime >= this.slice)) {
                this.finished = !this.task.execute();
                ++i;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public String toString() {
            return "Task(" + this.task + ", priority=" + this.priority + ", slice=" + this.slice + ")";
        }
    }
}

