/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;

public class StatusBar
extends JPanel {
    protected JLabel textl;
    protected long timeout;
    protected Timer timer;
    protected Map components = new HashMap();

    public StatusBar() {
        this.textl = new JLabel(" ");
        this.timer = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusBar.this.setText(" ");
            }
        });
        this.setBorder(new BevelBorder(1));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.textl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 4, 4, 2), 0, 0));
    }

    public void setText(String text) {
        final String txt = text == null || text.length() == 0 ? " " : text;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.textl.setText(txt);
            }
        });
        this.timer.restart();
    }

    public void addStatusComponent(Object id, Component comp) {
        if (!this.components.containsKey(id)) {
            this.components.put(id, comp);
            this.add(comp, new GridBagConstraints(this.getComponentCount(), 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.invalidate();
            this.doLayout();
            this.repaint();
        }
    }

    public Component getStatusComponent(Object id) {
        return (Component)this.components.get(id);
    }

    public void removeStatusComponent(Object id) {
        if (this.components.containsKey(id)) {
            this.remove((Component)this.components.get(id));
            this.components.remove(id);
            this.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        StatusBar sb = new StatusBar();
        f.add("South", sb);
        f.setSize(200, 200);
        f.setVisible(true);
        sb.setText("hallo");
        Button b = new Button("b");
        sb.addStatusComponent("a", new Button("a"));
        sb.addStatusComponent("b", b);
        sb.addStatusComponent("c", new Button("c"));
        sb.removeStatusComponent("b");
    }
}

