/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.border.Border;

public class ScrollablePanel
extends JPanel
implements Scrollable {
    protected Dimension preferredsize;
    protected boolean trackwidth;
    protected boolean trackheight;

    public ScrollablePanel(Dimension preferredsize, boolean trackwidth, boolean trackheigth) {
        this.preferredsize = preferredsize;
        this.trackwidth = trackwidth;
        this.trackheight = trackheigth;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredsize;
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        Dimension par = null;
        if (this.getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            JScrollPane scroll = (JScrollPane)this.getParent().getParent();
            par = scroll.getSize();
            Border border = scroll.getBorder();
            if (border != null) {
                Insets insets = scroll.getBorder().getBorderInsets(scroll);
                par.width -= insets.left + insets.right;
                par.height -= insets.top + insets.bottom;
            }
        }
        int prefwidth = pref != null ? pref.width : 0;
        int prefheight = pref != null ? pref.height : 0;
        int parwidth = par != null ? par.width : 0;
        int parheight = par != null ? par.height : 0;
        Dimension ret = new Dimension(Math.max(prefwidth, parwidth), Math.max(prefheight, parheight));
        return ret;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 16;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.trackwidth;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.trackheight;
    }
}

