/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ObjectCardLayout
implements LayoutManager2 {
    public static final String DEFAULT_COMPONENT = "jtc_ocl_default_component";
    protected int hgap = 0;
    protected int vgap = 0;
    protected Map components = new HashMap();
    protected Component current;

    public void show(Object object) {
        Component comp;
        if (this.current != null) {
            this.current.setVisible(false);
        }
        if ((comp = (Component)this.components.get(object)) == null) {
            comp = (Component)this.components.get(DEFAULT_COMPONENT);
        }
        if (comp != null) {
            comp.setVisible(true);
            comp.getParent().validate();
        }
        this.current = comp;
    }

    public boolean isAvailable(Object object) {
        return this.components.containsKey(object);
    }

    public Component getComponent(Object object) {
        return (Component)this.components.get(object);
    }

    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Rectangle bounds = parent.getBounds();
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            comp.setBounds(this.hgap + insets.left, this.vgap + insets.top, bounds.width - (this.hgap * 2 + insets.left + insets.right), bounds.height - (this.vgap * 2 + insets.top + insets.bottom));
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getMinimumSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w + this.hgap * 2, insets.top + insets.bottom + h + this.vgap * 2);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w + this.hgap * 2, insets.top + insets.bottom + h + this.vgap * 2);
    }

    public void removeLayoutComponent(Component comp) {
        Iterator i = this.components.values().iterator();
        while (i.hasNext()) {
            if (!i.next().equals(comp)) continue;
            i.remove();
            break;
        }
        if (comp == this.current) {
            comp.getParent().repaint();
            this.show(DEFAULT_COMPONENT);
        }
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints == null) {
            throw new RuntimeException("no_object_for_card_specified");
        }
        this.components.put(constraints, component);
        component.setVisible(false);
        this.show(constraints);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public Dimension maximumLayoutSize(Container target) {
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

