/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.SXML;
import jadex.tools.common.PopupBuilder;
import jadex.tools.common.SwingWorker;
import jadex.tools.common.ToolTipAction;
import jadex.tools.common.jtreetable.TreeExpansionHandler;
import jadex.tools.common.plugin.IControlCenter;
import jadex.tools.starter.DirNode;
import jadex.tools.starter.FileNode;
import jadex.tools.starter.IExplorerTreeNode;
import jadex.tools.starter.INodeAction;
import jadex.tools.starter.JarNode;
import jadex.tools.starter.ModelTreeCellRenderer;
import jadex.tools.starter.RootNode;
import jadex.util.DynamicURLClassLoader;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nuggets.Nuggets;

public class ModelExplorer
extends JTree {
    public static String REFRESHER_ID = "refresher";
    public static double PERCENTAGE_USER = 0.9;
    public static double PERCENTAGE_CRAWLER = 0.02;
    protected static final UIDefaults icons = new UIDefaults(new Object[]{"addpath", SGUI.makeIcon((Class)ModelExplorer.class, (String)"/jadex/tools/common/images/new_addfolder.png"), "removepath", SGUI.makeIcon((Class)ModelExplorer.class, (String)"/jadex/tools/common/images/new_removefolder.png"), "checker", SGUI.makeIcon((Class)ModelExplorer.class, (String)"/jadex/tools/common/images/new_checker.png"), "refresh", SGUI.makeIcon((Class)ModelExplorer.class, (String)"/jadex/tools/common/images/new_refresh.png"), "refresh_menu", SGUI.makeIcon((Class)ModelExplorer.class, (String)"/jadex/tools/common/images/new_refresh_small.png"), "checking_menu", SGUI.makeIcon((Class)ModelExplorer.class, (String)"/jadex/tools/common/images/new_agent_broken.png")});
    protected IControlCenter jcc;
    protected RootNode root;
    protected PopupBuilder pubuilder;
    protected JFileChooser filechooser;
    protected TreeHandler expansionhandler;
    protected boolean refresh;
    protected JComponent refreshcomp;
    protected JCheckBoxMenuItem refreshmenu;
    protected JCheckBoxMenuItem checkingmenu;
    protected TreePath selected;
    public final Action ADD_PATH = new ToolTipAction("Add Path", icons.getIcon("addpath"), "Add a new directory path (package root) to the project structure"){

        public void actionPerformed(ActionEvent e) {
            File file;
            if (ModelExplorer.this.filechooser.showDialog(SGUI.getWindowParent((Component)ModelExplorer.this), "Add Path") == 0 && (file = ModelExplorer.this.filechooser.getSelectedFile()) != null) {
                if (!file.exists() && file.getParentFile().exists() && file.getParentFile().getName().equals(file.getName())) {
                    file = file.getParentFile();
                }
                if (file.exists()) {
                    FileNode node = ModelExplorer.this.getRootNode().addPathEntry(file);
                    ((DefaultTreeModel)ModelExplorer.this.getModel()).reload(ModelExplorer.this.getRootNode());
                    ModelExplorer.this.refresh(node);
                    try {
                        String fname = file.getAbsolutePath();
                        if (file.isDirectory() && !fname.endsWith(System.getProperty("file.separator", "/"))) {
                            fname = fname + "/";
                        }
                        DynamicURLClassLoader.addURLToInstance((URL)new URL("file", "", fname));
                    }
                    catch (MalformedURLException e1) {
                        String msg = SUtil.wrapText((String)("Error adding path:\n" + file + "\n:" + e1));
                        JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)ModelExplorer.this), msg, "Error adding path", 0);
                    }
                } else {
                    String msg = SUtil.wrapText((String)("Cannot find file or directory:\n" + file));
                    JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)ModelExplorer.this), msg, "Cannot find file or directory", 0);
                }
            }
        }

        public boolean isEnabled() {
            TreeNode rm = (TreeNode)ModelExplorer.this.getLastSelectedPathComponent();
            return rm == null;
        }
    };
    public final Action REMOVE_PATH = new ToolTipAction("Remove Path", icons.getIcon("removepath"), "Remove a directory path to the project structure"){

        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                FileNode node = (FileNode)ModelExplorer.this.getLastSelectedPathComponent();
                ModelExplorer.this.getRootNode().removePathEntry(node);
                if (ModelExplorer.this.usertask != null) {
                    ModelExplorer.this.usertask.nodes_user.clear();
                    ModelExplorer.this.usertask.nodes_out.clear();
                }
                if (ModelExplorer.this.crawlertask != null) {
                    ModelExplorer.this.crawlertask.nodes_crawler.clear();
                }
                ModelExplorer.this.refresh(ModelExplorer.this.getRootNode());
                ((DefaultTreeModel)ModelExplorer.this.getModel()).reload(ModelExplorer.this.getRootNode());
                try {
                    String fname = node.getFile().getAbsolutePath();
                    if (!(node instanceof JarNode) && node.getFile().isDirectory() && !fname.endsWith(System.getProperty("file.separator", "/"))) {
                        fname = fname + "/";
                    }
                    DynamicURLClassLoader.removeURLFromInstance((URL)new URL("file", "", fname));
                }
                catch (MalformedURLException ex) {
                    String failed = SUtil.wrapText((String)("Could not remove path\n\n" + ex.getMessage()));
                    JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)ModelExplorer.this), failed, "Path Error", 0);
                }
            }
        }

        public boolean isEnabled() {
            TreeNode rm = (TreeNode)ModelExplorer.this.getLastSelectedPathComponent();
            return rm != null && rm.getParent() == ModelExplorer.this.getRootNode();
        }
    };
    public final Action REFRESH = new ToolTipAction("Refresh", icons.getIcon("refresh"), null){

        public void actionPerformed(ActionEvent e) {
            FileNode node = (FileNode)ModelExplorer.this.getLastSelectedPathComponent();
            node.uncheck();
            ModelExplorer.this.refresh(node);
        }

        public boolean isEnabled() {
            return ModelExplorer.this.getLastSelectedPathComponent() != null && ((FileNode)ModelExplorer.this.getLastSelectedPathComponent()).getChildCount() == 0;
        }

        public String getToolTipText() {
            String ret = null;
            Object tmp = ModelExplorer.this.getLastSelectedPathComponent();
            if (tmp instanceof DirNode) {
                ret = "Refresh directory recursively: " + ((DirNode)tmp).getFile().getName();
            } else if (tmp instanceof FileNode) {
                ret = "Refresh file: " + ((FileNode)tmp).getFile().getName();
            }
            return ret;
        }
    };
    public final Action REFRESH_ALL = new ToolTipAction("Refresh All", icons.getIcon("refresh"), "Refresh all items of tree"){

        public boolean isEnabled() {
            return ModelExplorer.this.getLastSelectedPathComponent() == null || ((FileNode)ModelExplorer.this.getLastSelectedPathComponent()).getChildCount() != 0;
        }

        public void actionPerformed(ActionEvent e) {
            IExplorerTreeNode node = (IExplorerTreeNode)ModelExplorer.this.getLastSelectedPathComponent();
            if (node == null) {
                node = ModelExplorer.this.getRootNode();
            }
            LinkedList<TreeNode> unchecknodes = new LinkedList<TreeNode>();
            unchecknodes.add(node);
            while (unchecknodes.size() > 0) {
                node = (IExplorerTreeNode)unchecknodes.remove(0);
                node.uncheck();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    unchecknodes.add(node.getChildAt(i));
                }
            }
            ModelExplorer.this.refresh(node);
        }
    };
    public final AbstractAction TOGGLE_REFRESH = new AbstractAction("Auto refresh", icons.getIcon("refresh_menu")){

        public void actionPerformed(ActionEvent e) {
            ModelExplorer.this.refresh = ((JCheckBoxMenuItem)e.getSource()).getState();
            if (ModelExplorer.this.refresh) {
                if (ModelExplorer.this.crawlertask == null) {
                    ModelExplorer.this.crawlertask = new CrawlerTask();
                }
                SwingWorker.addTask(ModelExplorer.this.crawlertask, PERCENTAGE_CRAWLER);
            }
        }
    };
    public final AbstractAction TOGGLE_CHECKING = new AbstractAction("Auto check", icons.getIcon("checking_menu")){

        public void actionPerformed(ActionEvent e) {
            ModelExplorer.this.getRootNode().setChecking(((JCheckBoxMenuItem)e.getSource()).getState());
            ModelExplorer.this.refresh(ModelExplorer.this.getRootNode());
        }
    };
    protected UserTask usertask;
    protected CrawlerTask crawlertask;

    public ModelExplorer(IControlCenter jcc, RootNode root, JComponent refreshcomp, PopupBuilder pubuilder) {
        super(root);
        this.jcc = jcc;
        this.root = (RootNode)this.getModel().getRoot();
        this.refreshcomp = refreshcomp;
        this.setRootVisible(false);
        this.refresh = true;
        this.pubuilder = pubuilder != null ? pubuilder : new PopupBuilder(new Action[]{this.ADD_PATH, this.REMOVE_PATH, this.REFRESH, this.REFRESH_ALL});
        this.setCellRenderer(new ModelTreeCellRenderer());
        this.setRowHeight(16);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ModelExplorer.this.showPopUp(e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ModelExplorer.this.showPopUp(e.getX(), e.getY());
                }
            }
        });
        this.setScrollsOnExpand(true);
        this.expansionhandler = new TreeHandler(this);
        this.filechooser = new JFileChooser(".");
        this.filechooser.setFileSelectionMode(2);
        this.filechooser.addChoosableFileFilter(new FileFilter(){

            public String getDescription() {
                return "Paths or .jar files";
            }

            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                return f.isDirectory() || name.endsWith(".jar");
            }
        });
        this.getModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
                if (ModelExplorer.this.selected != null) {
                    ModelExplorer.this.expansionhandler.setSelectedNode((FileNode)ModelExplorer.this.selected.getLastPathComponent());
                }
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ModelExplorer.this.selected = e.getPath();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ModelExplorer.this.REMOVE_PATH.actionPerformed(null);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setPopupBuilder(PopupBuilder pubuilder) {
        this.pubuilder = pubuilder;
    }

    public void addAction(Class nodetype, INodeAction action) {
        this.getRootNode().addAction(nodetype, action);
    }

    public RootNode getRootNode() {
        return this.root;
    }

    public void getProperties(Properties props) {
        String treesave = Nuggets.objectToXML((Object)this.getRootNode());
        props.setProperty("rootnode", treesave);
        File sf = this.filechooser.getSelectedFile();
        if (sf != null) {
            props.setProperty("lastpath", sf.getAbsolutePath());
        }
        int expi = 0;
        Enumeration<TreePath> exp = this.getExpandedDescendants(new TreePath(this.getRootNode()));
        while (exp != null && exp.hasMoreElements()) {
            TreePath path = exp.nextElement();
            if (!(path.getLastPathComponent() instanceof FileNode)) continue;
            props.setProperty("expanded" + expi++, ((FileNode)path.getLastPathComponent()).getFile().getAbsolutePath());
        }
        if (this.getSelectionPath() != null) {
            props.setProperty("selected", "" + ((FileNode)this.getSelectionPath().getLastPathComponent()).getFile().getAbsolutePath());
        }
        props.setProperty("refresh", Boolean.toString(this.refresh));
    }

    public void setProperties(Properties props) {
        String node;
        String rootxml = props.getProperty("rootnode");
        if (rootxml != null) {
            try {
                RootNode newroot = (RootNode)Nuggets.objectFromXML((String)rootxml);
                newroot.copyFrom(this.root);
                this.root = newroot;
                ((DefaultTreeModel)this.getModel()).setRoot(this.root);
            }
            catch (Exception e) {
                System.err.println("Cannot load project tree: " + e.getClass().getName());
            }
        } else {
            String entry;
            int i = 0;
            while ((entry = props.getProperty("pathentry_" + i)) != null) {
                File file = new File(entry);
                this.getRootNode().addPathEntry(file);
                ++i;
            }
            this.getRootNode().setChecking(!"false".equals(props.getProperty("checking")));
        }
        Enumeration e = this.getRootNode().children();
        while (e.hasMoreElements()) {
            File file = ((FileNode)e.nextElement()).getFile();
            String fname = file.getAbsolutePath();
            if (file.isDirectory() && !fname.endsWith(System.getProperty("file.separator", "/"))) {
                fname = fname + "/";
            }
            try {
                DynamicURLClassLoader.addURLToInstance((URL)new URL("file", "", fname));
            }
            catch (MalformedURLException ex) {
                String failed = SUtil.wrapText((String)("Could not add path\n\n" + ex.getMessage()));
                JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this), failed, "Path Error", 0);
            }
        }
        int i = 0;
        while ((node = props.getProperty("expanded" + i++)) != null) {
            this.expansionhandler.treeExpanded(new TreeExpansionEvent(this, new TreePath(new FileNode(null, new File(node)))));
        }
        String sel = props.getProperty("selected");
        this.expansionhandler.setSelectedNode(sel == null ? null : new FileNode(null, new File(sel)));
        ((DefaultTreeModel)this.getModel()).reload(this.getRootNode());
        String lastpath = props.getProperty("lastpath");
        if (lastpath != null) {
            try {
                File mo_file = new File(lastpath);
                this.filechooser.setCurrentDirectory(mo_file.getParentFile());
                this.filechooser.setSelectedFile(mo_file);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        boolean bl = this.refresh = !"false".equals(props.getProperty("refresh"));
        if (this.refreshmenu != null) {
            this.refreshmenu.setState(this.refresh);
        }
        if (this.checkingmenu != null) {
            this.checkingmenu.setState(this.getRootNode().isChecking());
        }
        if (this.refresh) {
            if (this.crawlertask == null) {
                this.crawlertask = new CrawlerTask();
            }
            SwingWorker.addTask(this.crawlertask, PERCENTAGE_CRAWLER);
        }
    }

    public void reset() {
        this.refresh = false;
        if (this.usertask != null) {
            this.usertask.nodes_user.clear();
            this.usertask.nodes_out.clear();
        }
        DynamicURLClassLoader.resetInstance();
        this.root.reset();
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.root);
    }

    public void close() {
    }

    protected void showPopUp(int x, int y) {
        TreePath sel = this.getPathForLocation(x, y);
        this.setSelectionPath(sel);
        JPopupMenu pop = this.pubuilder.buildPopupMenu();
        pop.show(this, x, y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean check(TreeNode node, String baseurl) {
        baseurl = baseurl == null ? node.toString() : baseurl + "/" + node.toString();
        boolean ok = true;
        if (node.getChildCount() > 0) {
            int i = 0;
            while (i < node.getChildCount()) {
                boolean check = this.check(node.getChildAt(i), baseurl);
                ok = ok && check;
                ++i;
            }
            return ok;
        }
        if (!SXML.isJadexFilename((String)baseurl)) return ok;
        try {
            IMBDIAgent model = SXML.isAgentFilename((String)baseurl) ? SXML.loadAgentModel((String)baseurl, null) : (SXML.isCapabilityFilename((String)baseurl) ? SXML.loadCapabilityModel((String)baseurl, null, null) : (SXML.isPropertiesFilename((String)baseurl) ? SXML.loadPropertiesModel((String)baseurl, null, null) : null));
            if (model == null) return ok;
            if (!Configuration.getConfiguration().isModelChecking()) return true;
            if (!model.getReport().isEmpty()) return false;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("Model");
        this.refreshmenu = new JCheckBoxMenuItem(this.TOGGLE_REFRESH);
        this.refreshmenu.setState(this.refresh);
        menu.add(this.refreshmenu);
        this.checkingmenu = new JCheckBoxMenuItem(this.TOGGLE_CHECKING);
        this.checkingmenu.setState(this.getRootNode().isChecking());
        menu.add(this.checkingmenu);
        menubar.add((Component)menu, menubar.getComponentCount() - 1);
        return menubar;
    }

    public void refresh(IExplorerTreeNode node) {
        if (this.usertask == null) {
            this.usertask = new UserTask();
            SwingWorker.addTask(this.usertask, PERCENTAGE_USER);
            if (this.refreshcomp != null) {
                this.jcc.addStatusComponent(this, this.refreshcomp);
            }
        }
        this.usertask.nodes_user.add(node);
    }

    public class CrawlerTask
    implements SwingWorker.Task {
        protected List nodes_crawler = new ArrayList();

        public boolean execute() {
            IExplorerTreeNode node;
            if (this.nodes_crawler.isEmpty()) {
                this.nodes_crawler.add(ModelExplorer.this.getRootNode());
            }
            if ((node = (IExplorerTreeNode)this.nodes_crawler.remove(0)).refresh()) {
                ((DefaultTreeModel)ModelExplorer.this.getModel()).reload(node);
                ModelExplorer.this.refresh(node);
            }
            Enumeration<? extends TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                this.nodes_crawler.add(children.nextElement());
            }
            return ModelExplorer.this.refresh && ModelExplorer.this.usertask == null;
        }
    }

    public class UserTask
    implements SwingWorker.Task {
        protected List nodes_user = new LinkedList();
        protected List nodes_out = new LinkedList();

        public boolean execute() {
            boolean finished;
            IExplorerTreeNode node;
            if (!this.nodes_user.isEmpty()) {
                node = (IExplorerTreeNode)this.nodes_user.remove(0);
                String tip = node.getToolTipText();
                if (tip != null) {
                    ModelExplorer.this.jcc.setStatusText("Scanning " + tip);
                }
                if (node.refresh()) {
                    ((DefaultTreeModel)ModelExplorer.this.getModel()).reload(node);
                    this.nodes_out.add(node);
                }
                Enumeration<? extends TreeNode> children = node.children();
                while (children.hasMoreElements()) {
                    this.nodes_user.add(children.nextElement());
                }
            } else if (!this.nodes_out.isEmpty()) {
                node = (IExplorerTreeNode)this.nodes_out.remove(0);
                String tip = node.getToolTipText();
                if (tip != null) {
                    ModelExplorer.this.jcc.setStatusText("Scanning " + tip);
                }
                if (node.refresh()) {
                    ((DefaultTreeModel)ModelExplorer.this.getModel()).reload(node);
                    this.nodes_out.add(node);
                } else if (node.getParent() != null) {
                    this.nodes_out.add(node.getParent());
                }
            }
            boolean bl = finished = this.nodes_user.isEmpty() && this.nodes_out.isEmpty();
            if (finished) {
                ModelExplorer.this.usertask = null;
                if (ModelExplorer.this.refreshcomp != null) {
                    ModelExplorer.this.jcc.removeStatusComponent(ModelExplorer.this);
                }
                if (ModelExplorer.this.refresh) {
                    if (ModelExplorer.this.crawlertask == null) {
                        ModelExplorer.this.crawlertask = new CrawlerTask();
                    }
                    SwingWorker.addTask(ModelExplorer.this.crawlertask, PERCENTAGE_CRAWLER);
                }
            }
            return !finished;
        }
    }

    public static class TreeHandler
    extends TreeExpansionHandler {
        protected FileNode lastselected;

        public TreeHandler(JTree tree) {
            super(tree);
        }

        public void setSelectedNode(FileNode node) {
            this.lastselected = node;
        }

        protected void handlePath(TreePath path) {
            super.handlePath(path);
            if (this.lastselected != null && this.lastselected.equals(path.getLastPathComponent())) {
                this.lastselected = null;
                this.tree.setSelectionPath(path);
            }
        }
    }
}

