/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.adapter.IToolAdapter;
import jadex.adapter.fipa.AgentAction;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.runtime.ICapability;
import jadex.runtime.Plan;
import jadex.tools.common.IToolPanel;
import jadex.tools.common.ShortcutToolReply;
import jadex.tools.ontology.ToolRequest;
import jadex.util.collection.SCollection;
import java.util.ArrayList;

public class LocalToolRequestPlan
extends Plan {
    public static final String PROPERTY_TOOL_ADAPTERS = "tooladapter";
    protected IToolPanel tool;
    protected ToolRequest request;

    public LocalToolRequestPlan(IToolPanel tool, ToolRequest request) {
        this.tool = tool;
        this.request = request;
    }

    public void body() {
        LocalToolRequestPlan.handleLocalToolRequest((ICapability)this.getCapability(), this.request, new ShortcutToolReply(this.tool, this.getRootGoal()));
    }

    public static void handleLocalToolRequest(ICapability scope, ToolRequest request, IToolAdapter.IToolReply reply) {
        ArrayList tooladapters = SCollection.createArrayList();
        String[] keys = scope.getPropertybase().getPropertyNames(PROPERTY_TOOL_ADAPTERS);
        for (int i = 0; i < keys.length; ++i) {
            IToolAdapter adapter = (IToolAdapter)scope.getPropertybase().getProperty(keys[i]);
            tooladapters.add(adapter);
        }
        boolean processed = false;
        for (int i = 0; i < tooladapters.size(); ++i) {
            IToolAdapter adapter = (IToolAdapter)tooladapters.get(i);
            if (!adapter.getMessageClass().isInstance(request)) continue;
            try {
                adapter.handleToolRequest((AgentIdentifier)scope.getAgentIdentifier(), (AgentAction)request, reply);
                processed = true;
                continue;
            }
            catch (RuntimeException e) {
                scope.getLogger().severe("Tool adapter " + adapter + "threw exception " + e);
                e.printStackTrace();
            }
        }
        if (!processed) {
            scope.getLogger().warning("No tool adapter to handle: " + request);
        }
    }
}

