/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.tools.common.IValidator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class JValidatorTextField
extends JTextField {
    protected IValidator validator;

    public JValidatorTextField() {
    }

    public JValidatorTextField(IValidator validator) {
        this.setValidator(validator);
    }

    public JValidatorTextField(String text, IValidator validator) {
        super(text);
        this.setValidator(validator);
    }

    public JValidatorTextField(String text) {
        super(text);
    }

    public JValidatorTextField(int columns) {
        super(columns);
    }

    public JValidatorTextField(String text, int columns) {
        super(text, columns);
    }

    public JValidatorTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    protected boolean isInputValid() {
        return this.validator == null ? true : this.validator.isValid(this.getText());
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isInputValid()) {
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            bounds.x = insets.left;
            bounds.y = insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            Rectangle2D textbounds = g.getFontMetrics().getStringBounds(this.getText(), g);
            int width = (int)textbounds.getWidth();
            g.setColor(Color.red);
            int y = bounds.y + bounds.height;
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            int align = this.getHorizontalAlignment();
            int x = align == 2 || ltr && align == 10 || !ltr && align == 11 ? bounds.x : (this.getHorizontalAlignment() == 4 || !ltr && align == 10 || ltr && align == 11 ? Math.max(bounds.x, bounds.x + bounds.width - width) : (this.getHorizontalAlignment() == 0 ? Math.max(bounds.x, bounds.x + (bounds.width - width) / 2) : bounds.x));
            int wx = Math.min(x + width, bounds.x + bounds.width);
            while (x + 2 <= wx) {
                g.drawLine(x, y, x + 2, y - 2);
                if ((x += 2) + 2 > wx) continue;
                g.drawLine(x, y - 2, x + 2, y);
                x += 2;
            }
        }
    }
}

