/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeDialog
extends JDialog {
    protected Map options;
    protected String def;
    protected String message;
    protected String result;

    public JTreeDialog(Frame owner, String title, boolean modal, String message, String[] options, String def) {
        super(owner, title, modal);
        this.message = message;
        this.options = new HashMap();
        this.def = def;
        Icon icon = UIManager.getIcon("OptionPane.questionIcon");
        JLabel iconlab = new JLabel("", icon, 0);
        final JTree tree = this.createTree(options);
        tree.setRootVisible(false);
        if (def != null) {
            StringTokenizer stok = new StringTokenizer(def, "/\\");
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tree.getModel().getRoot();
            int cnt = stok.countTokens();
            for (int i = 0; i < cnt - 1 && parent != null; ++i) {
                String uo = stok.nextToken();
                parent = this.getNodeForUserObject(parent, uo);
            }
            if (parent != null) {
                tree.expandPath(new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(parent)));
                DefaultMutableTreeNode node = this.getNodeForUserObject(parent, stok.nextToken());
                tree.getSelectionModel().addSelectionPath(new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(node)));
            }
        }
        JLabel msgtf = new JLabel(message);
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TreePath sel = tree.getSelectionModel().getSelectionPath();
                if (sel != null) {
                    JTreeDialog.this.result = (String)JTreeDialog.this.options.get(sel.getLastPathComponent());
                }
                JTreeDialog.this.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JTreeDialog.this.dispose();
            }
        });
        JPanel border = new JPanel(new GridBagLayout());
        border.add((Component)tree, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        border.setBackground(tree.getBackground());
        JScrollPane center = new JScrollPane(border);
        JPanel south = new JPanel(new GridBagLayout());
        south.add((Component)ok, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        south.add((Component)cancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ok.setMinimumSize(cancel.getMinimumSize());
        ok.setPreferredSize(cancel.getPreferredSize());
        center.setPreferredSize(tree.getMinimumSize());
        center.setPreferredSize(tree.getPreferredSize());
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)iconlab, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 0, new Insets(10, 10, 10, 15), 0, 0));
        this.getContentPane().add((Component)msgtf, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 5, 10), 0, 0));
        this.getContentPane().add((Component)center, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        this.getContentPane().add((Component)south, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.setSize(400, 300);
        this.setLocationRelativeTo(owner);
    }

    public String getResult() {
        return this.result;
    }

    protected JTree createTree(String[] options) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        String delims = "/\\";
        for (int i = 0; i < options.length; ++i) {
            StringTokenizer stok = new StringTokenizer(options[i], delims);
            DefaultMutableTreeNode parent = root;
            while (stok.hasMoreTokens()) {
                String txt = stok.nextToken();
                DefaultMutableTreeNode node = this.getNodeForUserObject(parent, txt);
                if (node == null) {
                    node = new DefaultMutableTreeNode(txt);
                    parent.add(node);
                }
                parent = node;
            }
            this.options.put(parent, options[i]);
        }
        return new JTree(root);
    }

    protected DefaultMutableTreeNode getNodeForUserObject(DefaultMutableTreeNode node, Object uo) {
        Enumeration<TreeNode> e = node.children();
        DefaultMutableTreeNode ret = null;
        while (ret == null && e.hasMoreElements()) {
            DefaultMutableTreeNode tester = (DefaultMutableTreeNode)e.nextElement();
            if (!uo.equals(tester.getUserObject())) continue;
            ret = tester;
        }
        return ret;
    }

    public static void main(String[] args) {
        String[] opts = new String[]{"a1/1.xml", "a1/b1/2.xml", "a1/b2/c1/3.xml", "a2/b1/4.xml", "a3/b1/c1/5.xml"};
        JFrame f = new JFrame();
        JTreeDialog td = new JTreeDialog(f, "Titel", false, "Select an agent", opts, "a2/b1/4.xml");
        f.setLocation(400, 400);
        f.setVisible(true);
        td.setVisible(true);
    }
}

