/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.tools.common.IRepresentationConverter;
import java.util.Map;

public class ElementStringGenerator
implements IRepresentationConverter {
    protected int indentwidth;

    public ElementStringGenerator() {
        this(4);
    }

    public ElementStringGenerator(int indentwidth) {
        this.indentwidth = indentwidth;
    }

    public String convert(Map element) {
        return this.convert(element, 0);
    }

    protected String convert(Map element, int indent) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indent * this.indentwidth && indent == 0; ++i) {
            buf.append(" ");
        }
        String clazz = (String)element.get("class");
        clazz = clazz == null ? "class=n/a" : clazz;
        String name = (String)element.get("name");
        name = name == null ? "name=n/a" : name;
        buf.append(clazz + " " + name + "\n");
        String[] keys = element.keySet().toArray(new String[element.keySet().size()]);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals("name") || keys[i].equals("class")) continue;
            for (int j = 0; j < (indent + 1) * this.indentwidth; ++j) {
                buf.append(" ");
            }
            if (element.get(keys[i]) instanceof Map) {
                buf.append(keys[i] + ": " + this.convert((Map)element.get(keys[i]), indent + 1));
                continue;
            }
            buf.append(keys[i] + ": " + element.get(keys[i]) + "\n");
        }
        return buf.toString();
    }
}

