/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.tools.common.BrowserPane;
import jadex.tools.common.ElementStringGenerator;
import jadex.tools.common.IRepresentationConverter;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.text.html.HTMLDocument;

public class ElementPanel
extends JTabbedPane {
    public static final String DEFAULT = "default";
    protected String stylesheet;
    protected int max;
    protected Map tabs;
    protected IRepresentationConverter htmlconv;
    protected boolean htmlinited;
    protected IRepresentationConverter defconv;

    public ElementPanel(String title, String text) {
        this(title, text, "element.css", 5);
    }

    public ElementPanel(String title, String text, String stylesheet, int max) {
        this.stylesheet = stylesheet;
        this.max = max;
        this.tabs = new HashMap();
        if (title != null) {
            this.setBorder(new TitledBorder(new EtchedBorder(1), title));
        }
        if (text != null) {
            if (text.indexOf("<html>") != -1 || text.indexOf("<HTML>") != -1) {
                try {
                    this.addHTMLContent("Info", null, text, DEFAULT, null);
                }
                catch (Exception e) {
                    System.out.println(e);
                    this.addTextContent("Info", null, text, DEFAULT);
                }
            } else {
                this.addTextContent("Info", null, text, DEFAULT);
            }
        }
    }

    public synchronized void addTextContent(String title, Icon icon, String text, Object id) {
        JTextArea textcomp = new JTextArea(text);
        textcomp.setEditable(false);
        this.addTab(title, icon, textcomp, id);
    }

    public void addHTMLContent(String title, Icon icon, String text, Object id, Map externals) {
        BrowserPane textcomp = new BrowserPane();
        textcomp.setText(text);
        textcomp.setCaretPosition(0);
        textcomp.setExternals(externals);
        this.setStylesheet(textcomp);
        this.addTab(title, icon, textcomp, id);
    }

    public void addElement(Map element, Icon icon) {
        String title;
        Object id = element.get("id");
        Object clazz = element.get("class");
        Object name = element.get("name");
        String string = name != null ? name.toString() : (title = clazz != null ? "Unnamed " + clazz.toString() : "Unnamed Element");
        if (this.getHTMLConverter() != null) {
            String html = this.getHTMLConverter().convert(element);
            try {
                this.addHTMLContent(title, icon, html, id, null);
            }
            catch (Exception e) {
                System.out.println(e);
                String text = this.getDefaultConverter().convert(element);
                this.addTextContent(title, icon, text, id);
            }
        } else {
            String text = this.getDefaultConverter().convert(element);
            this.addTextContent(title, icon, text, id);
        }
    }

    public Object getId(Component comp) {
        Iterator i = this.tabs.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (this.tabs.get(key) != comp) continue;
            return key;
        }
        return null;
    }

    public Object getId() {
        return this.getId(this.getSelectedComponent());
    }

    public void setStylesheet(JTextPane textcomp) {
        if (this.stylesheet != null) {
            try {
                int cnt;
                StringBuffer cssbuf = new StringBuffer();
                InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream(this.stylesheet));
                char[] buf = new char[256];
                while ((cnt = in.read(buf)) != -1) {
                    cssbuf.append(buf, 0, cnt);
                }
                String css = cssbuf.toString();
                UIDefaults def = UIManager.getLookAndFeelDefaults();
                String title_background = SUtil.colorToHTML((Color)((Color)def.get("InternalFrame.activeTitleBackground")));
                String title_foreground = SUtil.colorToHTML((Color)((Color)def.get("InternalFrame.activeTitleForeground")));
                String title_font = SUtil.fontToHTML((Font)((Font)def.get("InternalFrame.titleFont")));
                String border = SUtil.colorToHTML((Color)((Color)def.get("InternalFrame.borderShadow")));
                String attribute_background = SUtil.colorToHTML((Color)((Color)def.get("Label.background")));
                String attribute_foreground = SUtil.colorToHTML((Color)((Color)def.get("Label.foreground")));
                String attribute_font = SUtil.fontToHTML((Font)((Font)def.get("Label.font")));
                String text_background = SUtil.colorToHTML((Color)((Color)def.get("TextPane.background")));
                String text_foreground = SUtil.colorToHTML((Color)((Color)def.get("TextPane.foreground")));
                String text_font = SUtil.fontToHTML((Font)((Font)def.get("TextPane.font")));
                css = SUtil.replace((String)css, (String)"$title_background", (String)title_background);
                css = SUtil.replace((String)css, (String)"$title_foreground", (String)title_foreground);
                css = SUtil.replace((String)css, (String)"$title_font", (String)title_font);
                css = SUtil.replace((String)css, (String)"$border", (String)border);
                css = SUtil.replace((String)css, (String)"$attribute_background", (String)attribute_background);
                css = SUtil.replace((String)css, (String)"$attribute_foreground", (String)attribute_foreground);
                css = SUtil.replace((String)css, (String)"$attribute_font", (String)attribute_font);
                css = SUtil.replace((String)css, (String)"$text_background", (String)text_background);
                css = SUtil.replace((String)css, (String)"$text_foreground", (String)text_foreground);
                css = SUtil.replace((String)css, (String)"$text_font", (String)text_font);
                HTMLDocument doc = (HTMLDocument)textcomp.getStyledDocument();
                doc.getStyleSheet().loadRules(new StringReader(css.toString()), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load stylesheet: " + this.stylesheet + "\n" + e);
            }
        }
    }

    protected void addTab(String title, Icon icon, JComponent comp, Object id) {
        int i;
        ChangeListener[] cls = this.getChangeListeners();
        for (int i2 = 0; i2 < cls.length; ++i2) {
            this.removeChangeListener(cls[i2]);
        }
        int index = this.getTabCount();
        if (id == null) {
            id = DEFAULT;
        }
        if (this.tabs.get(id) != null) {
            Object tab = this.tabs.get(id);
            for (i = 0; i < this.getTabCount(); ++i) {
                if (tab != this.getComponentAt(i)) continue;
                index = i;
                this.remove(i);
                break;
            }
        }
        while (this.max >= 0 && this.getTabCount() >= this.max) {
            this.tabs.remove(this.getId(this.getComponentAt(0)));
            this.remove(0);
            index = Math.min(index, this.getTabCount());
        }
        JScrollPane scroll = new JScrollPane(comp);
        this.insertTab(title, icon, scroll, null, index);
        this.setSelectedIndex(index);
        this.tabs.put(id, scroll);
        for (i = 0; i < cls.length; ++i) {
            this.addChangeListener(cls[i]);
        }
    }

    public IRepresentationConverter getHTMLConverter() {
        if (this.htmlconv == null && !this.htmlinited) {
            try {
                this.htmlconv = (IRepresentationConverter)SReflect.findClass((String)"jadex.tools.common.ElementHTMLGenerator", null).newInstance();
            }
            catch (Throwable e) {
                System.out.println("Velocity template engine not installed: using plain text description.");
            }
            this.htmlinited = true;
        }
        return this.htmlconv;
    }

    public IRepresentationConverter getDefaultConverter() {
        if (this.defconv == null) {
            this.defconv = new ElementStringGenerator();
        }
        return this.defconv;
    }

    public static void main(String[] args) {
        HashMap<String, Object> element = new HashMap<String, Object>();
        HashMap<String, Object> ielement = new HashMap<String, Object>();
        HashMap<String, String> iielement = new HashMap<String, String>();
        iielement.put("ii1", "ii1_val");
        iielement.put("isencodeablepresentation", "true");
        ielement.put("inner", iielement);
        ielement.put("inner2", iielement);
        ielement.put("ia2", "ia_val");
        ielement.put("name", "innername_val");
        ielement.put("class", "innerclass_val");
        ielement.put("ia", "ia_val");
        ielement.put("isencodeablepresentation", "true");
        element.put("inner", ielement);
        element.put("inner2", ielement);
        element.put("a2", "a_val");
        element.put("name", "name_val");
        element.put("class", "class_val");
        element.put("a", "a_val");
        JFrame frame = new JFrame("Element Panel Test");
        ElementPanel panel = new ElementPanel("Element Panel", null);
        frame.getContentPane().add(panel);
        frame.setSize(640, 480);
        frame.setVisible(true);
        panel.addElement(element, null);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
    }
}

