/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.tools.common.AgentIdentifierPanel;
import jadex.util.SGUI;
import jadex.util.SUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class EditableList
extends JTable {
    protected static UIDefaults icons = new UIDefaults(new Object[]{"add", SGUI.makeIcon((Class)AgentIdentifierPanel.class, (String)"/jadex/tools/common/images/add_small.png"), "delete", SGUI.makeIcon((Class)AgentIdentifierPanel.class, (String)"/jadex/tools/common/images/delete_small.png")});
    protected boolean editable;
    protected List entries;
    protected boolean allowduplicates;
    protected String title;
    protected boolean showcnt;
    static /* synthetic */ Class class$java$lang$String;

    public EditableList(String title) {
        this(title, false);
    }

    public EditableList(String title, boolean showcnt) {
        this.title = title;
        this.entries = new ArrayList();
        this.editable = true;
        this.allowduplicates = false;
        this.showcnt = showcnt;
        this.setModel(new AbstractTableModel(){

            public int getColumnCount() {
                return EditableList.this.editable ? 2 : 1;
            }

            public String getColumnName(int column) {
                return EditableList.this.editable && column == 0 ? " " : EditableList.this.getTitle();
            }

            public Class getColumnClass(int columnIndex) {
                Class clazz = EditableList.this.editable && columnIndex == 0 ? (class$javax$swing$JButton == null ? (class$javax$swing$JButton = EditableList.class$("javax.swing.JButton")) : class$javax$swing$JButton) : (class$java$lang$String == null ? (class$java$lang$String = EditableList.class$("java.lang.String")) : class$java$lang$String);
                return clazz;
            }

            public int getRowCount() {
                return EditableList.this.getEntries().length + (EditableList.this.editable ? 1 : 0);
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                if (!(EditableList.this.editable && columnIndex == 0 || rowIndex >= EditableList.this.getEntries().length)) {
                    return EditableList.this.getEntries()[rowIndex];
                }
                return "";
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return EditableList.this.editable && (columnIndex == 0 || rowIndex != EditableList.this.getEntries().length);
            }

            public void setValueAt(Object newadr, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    while (rowIndex >= EditableList.this.entries.size()) {
                        EditableList.this.entries.add("");
                    }
                    EditableList.this.entries.set(rowIndex, (String)newadr);
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                }
            }
        });
        this.getTableHeader().setPreferredSize(this.getTableHeader().getPreferredSize());
        this.getColumnModel().getColumn(0).setHeaderValue("");
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setDefaultRenderer(JButton.class, new ButtonCellManager());
        this.setDefaultEditor(JButton.class, new ButtonCellManager());
        JButton but = new JButton(icons.getIcon("delete"));
        but.setMargin(new Insets(0, 0, 0, 0));
        this.getColumnModel().getColumn(0).setMaxWidth(but.getPreferredSize().width);
    }

    public boolean isAllowDuplicates() {
        return this.allowduplicates;
    }

    public void setAllowDuplicates(boolean allowduplicates) {
        this.allowduplicates = allowduplicates;
        if (!allowduplicates) {
            this.removeDuplicates();
        }
    }

    protected void removeDuplicates() {
        for (int i = 0; i < this.entries.size(); ++i) {
            Object tmp = this.entries.get(i);
            int last = this.entries.lastIndexOf(tmp);
            while (i < last) {
                this.entries.remove(last);
                last = this.entries.lastIndexOf(tmp);
            }
        }
        this.refresh();
    }

    public String[] getEntries() {
        return this.entries.toArray(new String[this.entries.size()]);
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public void setEntries(String[] entries) {
        this.entries = SUtil.arrayToList((Object)entries);
        if (!this.allowduplicates) {
            this.removeDuplicates();
        }
        this.refresh();
    }

    public void addEntry(String entry) {
        if (this.allowduplicates || !this.entries.contains(entry)) {
            this.entries.add(entry);
        }
        this.refresh();
    }

    public void removeEntry(String entry) {
        this.entries.remove(entry);
        this.refresh();
    }

    public void removeEntries() {
        this.entries.clear();
        this.refresh();
    }

    public boolean containsEntry(String entry) {
        return this.entries.contains(entry);
    }

    public void refresh() {
        this.tableChanged(new TableModelEvent(this.getModel(), -1));
        if (this.editable) {
            JButton but = new JButton(icons.getIcon("delete"));
            but.setMargin(new Insets(0, 0, 0, 0));
            this.getColumnModel().getColumn(0).setMaxWidth(but.getPreferredSize().width);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void setTitle(String title) {
        this.title = title;
        this.refresh();
    }

    public String getTitle() {
        return this.showcnt ? this.title + " [" + this.entries.size() + "]" : this.title;
    }

    public boolean isShowEntriesCount() {
        return this.showcnt;
    }

    public void setShowEntriesCount(boolean showcnt) {
        this.showcnt = showcnt;
    }

    public class ButtonCellManager
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int column) {
            JButton ret;
            if (rowIndex != EditableList.this.getEntries().length) {
                ret = new JButton(icons.getIcon("delete"));
                ret.setToolTipText("Remove this entry.");
            } else {
                ret = new JButton(icons.getIcon("add"));
                ret.setToolTipText("Add a new entry.");
            }
            return ret;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int column) {
            if (rowIndex != EditableList.this.getEntries().length) {
                JButton del = new JButton(icons.getIcon("delete"));
                del.addActionListener(new ActionListener(this, rowIndex){
                    private final /* synthetic */ int val$rowIndex;
                    private final /* synthetic */ ButtonCellManager this$1;
                    {
                        this.this$1 = this$1;
                        this.val$rowIndex = val$rowIndex;
                    }

                    public void actionPerformed(ActionEvent e) {
                        ButtonCellManager.access$000((ButtonCellManager)this.this$1).entries.remove(this.val$rowIndex);
                        ((AbstractTableModel)ButtonCellManager.access$000(this.this$1).getModel()).fireTableRowsDeleted(this.val$rowIndex, this.val$rowIndex);
                        ButtonCellManager.access$100(this.this$1);
                        ButtonCellManager.access$000(this.this$1).refresh();
                    }
                });
                return del;
            }
            JButton add = new JButton(icons.getIcon("add"));
            add.addActionListener(new ActionListener(this){
                private final /* synthetic */ ButtonCellManager this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ButtonCellManager.access$000((ButtonCellManager)this.this$1).entries.add("");
                    AbstractTableModel model = (AbstractTableModel)ButtonCellManager.access$000(this.this$1).getModel();
                    model.fireTableRowsInserted(model.getRowCount(), model.getRowCount());
                    ButtonCellManager.access$200(this.this$1);
                    ButtonCellManager.access$000(this.this$1).refresh();
                }
            });
            return add;
        }

        public Object getCellEditorValue() {
            return "";
        }

        static /* synthetic */ EditableList access$000(ButtonCellManager x0) {
            return x0.EditableList.this;
        }

        static /* synthetic */ void access$100(ButtonCellManager x0) {
            x0.fireEditingStopped();
        }

        static /* synthetic */ void access$200(ButtonCellManager x0) {
            x0.fireEditingStopped();
        }
    }
}

