/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.tools.common.StyledDocumentOutputStream;
import jadex.util.MultiStream;
import jadex.util.SGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ConsolePanel
extends JPanel {
    protected static UIDefaults icons = new UIDefaults(new Object[]{"clear", SGUI.makeIcon((Class)ConsolePanel.class, (String)"/jadex/tools/common/images/new_console_clear.png"), "on", SGUI.makeIcon((Class)ConsolePanel.class, (String)"/jadex/tools/common/images/new_console_on.png"), "off", SGUI.makeIcon((Class)ConsolePanel.class, (String)"/jadex/tools/common/images/new_console_off.png")});
    protected StyledDocument doc;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    protected StyledDocumentOutputStream sdout;
    protected StyledDocumentOutputStream sderr;
    protected MultiStream multiout;
    protected MultiStream multierr;
    protected JButton onoff;

    public ConsolePanel() {
        this("Console Output");
    }

    public ConsolePanel(String title) {
        JTextPane tp = new JTextPane();
        this.doc = tp.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style outstyle = this.doc.addStyle("out", def);
        Style errorstyle = this.doc.addStyle("error", def);
        StyleConstants.setForeground(errorstyle, Color.red);
        this.sdout = new StyledDocumentOutputStream(this.doc, outstyle);
        this.sderr = new StyledDocumentOutputStream(this.doc, errorstyle);
        this.multiout = new MultiStream((OutputStream[])new PrintStream[]{this.out, this.sdout});
        PrintStream myout = new PrintStream((OutputStream)this.multiout);
        this.multierr = new MultiStream((OutputStream[])new PrintStream[]{this.err, this.sderr});
        PrintStream myerr = new PrintStream((OutputStream)this.multierr);
        System.setOut(myout);
        System.setErr(myerr);
        JButton clear = new JButton(icons.getIcon("clear"));
        clear.setMargin(new Insets(0, 0, 0, 0));
        clear.setToolTipText("Clear the console output");
        clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConsolePanel.this.clear();
            }
        });
        this.onoff = new JButton(icons.getIcon("off"));
        this.onoff.setMargin(new Insets(0, 0, 0, 0));
        this.onoff.setToolTipText("Turn off the console");
        this.onoff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConsolePanel.this.setConsoleEnabled(ConsolePanel.this.onoff.getIcon() == icons.getIcon("on"));
            }
        });
        final JScrollPane center = new JScrollPane(tp);
        this.doc.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        JScrollBar bar = 3.access$000(this.this$1).getVerticalScrollBar();
                        if (bar != null) {
                            bar.setValue(bar.getMaximum());
                        }
                    }
                });
            }

            public void changedUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
            }

            static /* synthetic */ JScrollPane access$000(3 x0) {
                return x0.center;
            }
        });
        JPanel north = new JPanel(new GridBagLayout());
        north.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this.onoff, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)clear, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.setLayout(new BorderLayout());
        this.add("Center", center);
        this.add("North", north);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            StyledDocument styledDocument = this.doc;
            synchronized (styledDocument) {
                this.doc.remove(0, this.doc.getLength());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setConsoleEnabled(boolean enable) {
        if (!enable) {
            this.multiout.setEnabled((OutputStream)this.sdout, false);
            this.multierr.setEnabled((OutputStream)this.sderr, false);
            this.onoff.setIcon(icons.getIcon("on"));
            this.onoff.setToolTipText("Turn on the console");
        } else {
            this.multiout.setEnabled((OutputStream)this.sdout, true);
            this.multierr.setEnabled((OutputStream)this.sderr, true);
            this.onoff.setIcon(icons.getIcon("off"));
            this.onoff.setToolTipText("Turn off the console");
        }
    }

    public boolean isConsoleEnabled() {
        return this.onoff.getIcon() == icons.getIcon("off");
    }

    public void close() {
        System.setOut(this.out);
        System.setErr(this.err);
        this.sdout.close();
        this.sderr.close();
    }
}

