/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.config.Configuration;
import jadex.tools.common.BrowserPane;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.JAutoPositionDialog;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ConfigurationDialog
extends JAutoPositionDialog {
    public static final String PROPERTY_NAME = "property_name";
    public static final String PROPERTY_VALUE = "property_value";
    public static final String PROPERTY_DEPENDENCY = "property_dependency";
    public static final String PROPERTY_OPTIONS = "property_options";
    protected List components;

    public ConfigurationDialog(Frame owner) {
        super(owner, true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Platform Settings");
        this.components = SCollection.createArrayList();
        JRadioButton javacc = new JRadioButton("Interpreter");
        javacc.putClientProperty(PROPERTY_NAME, Configuration.PARSER_NAME);
        javacc.putClientProperty(PROPERTY_VALUE, "jadex.parser.javaccimpl.Parser");
        javacc.putClientProperty(PROPERTY_DEPENDENCY, "jadex.parser.javaccimpl.Parser");
        JCheckBox javacc_plan_reloading = new JCheckBox("Plan reloading enabled");
        javacc_plan_reloading.putClientProperty(PROPERTY_NAME, Configuration.JAVACC_PLAN_RELAODING);
        javacc.putClientProperty(PROPERTY_OPTIONS, new JCheckBox[]{javacc_plan_reloading});
        JRadioButton janino = new JRadioButton("Compiler");
        janino.putClientProperty(PROPERTY_NAME, Configuration.PARSER_NAME);
        janino.putClientProperty(PROPERTY_VALUE, "jadex.parser.janinoimpl.Parser");
        janino.putClientProperty(PROPERTY_DEPENDENCY, "jadex.parser.janinoimpl.Parser");
        JCheckBox janino_write_cache = new JCheckBox("Write to file-cache enabled");
        janino_write_cache.putClientProperty(PROPERTY_NAME, Configuration.JANINO_WRITE_CACHE);
        JCheckBox janino_read_cache = new JCheckBox("Read from file-cache enabled");
        janino_read_cache.putClientProperty(PROPERTY_NAME, Configuration.JANINO_READ_CACHE);
        janino.putClientProperty(PROPERTY_OPTIONS, new JCheckBox[]{janino_write_cache, janino_read_cache});
        this.addChoice(" Expression evaluation ", new JRadioButton[]{javacc, janino});
        JCheckBox model_checking = new JCheckBox("Enable model integrity checking");
        model_checking.putClientProperty(PROPERTY_NAME, Configuration.MODEL_CHECKING);
        JCheckBox model_caching = new JCheckBox("Enable model caching");
        model_caching.putClientProperty(PROPERTY_NAME, Configuration.MODEL_CACHING);
        JCheckBox model_cache_auto = new JCheckBox("Enable model cache auto-refresh");
        model_cache_auto.putClientProperty(PROPERTY_NAME, Configuration.MODEL_CACHE_AUTOREFRESH);
        this.addChoice(" XML model loading ", new AbstractButton[]{model_checking, model_caching, model_cache_auto});
        JCheckBox welcome = new JCheckBox("Suppress Jadex welcome message on platform start");
        welcome.putClientProperty(PROPERTY_NAME, Configuration.NO_WELCOME);
        JRadioButton shutdown = new JRadioButton("Shutdown platform on JCC exit");
        shutdown.putClientProperty(PROPERTY_NAME, Configuration.JCC_EXIT);
        shutdown.putClientProperty(PROPERTY_VALUE, Configuration.JCC_EXIT_SHUTDOWN);
        JRadioButton keep = new JRadioButton("Keep platform running after JCC exit");
        keep.putClientProperty(PROPERTY_NAME, Configuration.JCC_EXIT);
        keep.putClientProperty(PROPERTY_VALUE, Configuration.JCC_EXIT_KEEP);
        JRadioButton ask = new JRadioButton("Ask for platform behavior on JCC exit");
        ask.putClientProperty(PROPERTY_NAME, Configuration.JCC_EXIT);
        ask.putClientProperty(PROPERTY_VALUE, Configuration.JCC_EXIT_ASK);
        this.addChoice(" Generic settings ", new AbstractButton[]{welcome, shutdown, keep, ask});
        this.update();
        BrowserPane addons = new BrowserPane();
        addons.setText("Some of these settings require add-ons <br> available from the <a href=\"http://vsis-www.informatik.uni-hamburg.de/projects/jadex/addons.php\">Jadex add-ons page</a>.");
        addons.setCaretPosition(0);
        addons.setDefaultOpenMode(true);
        int index = this.getContentPane().getComponentCount();
        this.getContentPane().add((Component)addons, new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 12, 2, new Insets(2, 4, 4, 2), 0, 0));
        JPanel buts = new JPanel(new GridBagLayout());
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        JButton apply = new JButton("Apply");
        JButton help = new JButton("Help");
        buts.add((Component)ok, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)cancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)apply, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        buts.add((Component)help, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 4, 4, 2), 0, 0));
        Dimension md = cancel.getMinimumSize();
        Dimension pd = cancel.getPreferredSize();
        ok.setMinimumSize(md);
        ok.setPreferredSize(pd);
        apply.setMinimumSize(md);
        apply.setPreferredSize(pd);
        help.setMinimumSize(md);
        help.setPreferredSize(pd);
        index = this.getContentPane().getComponentCount();
        this.getContentPane().add((Component)buts, new GridBagConstraints(0, index, 1, 1, 1.0, 1.0, 12, 2, new Insets(2, 4, 4, 2), 0, 0));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConfigurationDialog.this.save();
                ConfigurationDialog.this.dispose();
            }
        });
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConfigurationDialog.this.save();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConfigurationDialog.this.dispose();
            }
        });
        HelpBroker hb = GuiProperties.setupHelp(this, "tools.controlcenter.settings");
        if (hb != null) {
            help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
        }
    }

    protected void addChoice(String title, AbstractButton[] choices) {
        JPanel choicepanel = new JPanel(new GridBagLayout());
        choicepanel.setBorder(new TitledBorder(new EtchedBorder(), title));
        int index = this.getContentPane().getComponentCount();
        this.getContentPane().add((Component)choicepanel, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 4, 4, 2), 0, 0));
        ButtonGroup bgroup = new ButtonGroup();
        int row = 0;
        for (int i = 0; i < choices.length; ++i) {
            this.components.add(choices[i]);
            if (choices[i] instanceof JRadioButton) {
                bgroup.add(choices[i]);
            }
            final JCheckBox[] options = (JCheckBox[])choices[i].getClientProperty(PROPERTY_OPTIONS);
            choicepanel.add((Component)choices[i], new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 4, options != null && options.length > 0 ? 0 : 4, 2), 0, 0));
            if (options == null || options.length <= 0) continue;
            JPanel optionpanel = new JPanel(new GridBagLayout());
            choicepanel.add((Component)optionpanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 4, 4, 2), 0, 0));
            for (int j = 0; j < options.length; ++j) {
                optionpanel.add((Component)options[j], new GridBagConstraints(0, j, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 12, 0, 2), 0, 0));
            }
            choices[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    boolean active = ((JRadioButton)e.getSource()).isSelected();
                    for (int j = 0; j < options.length; ++j) {
                        String dependency = (String)options[j].getClientProperty(ConfigurationDialog.PROPERTY_DEPENDENCY);
                        options[j].setEnabled(active && (dependency == null || SReflect.findClass0((String)dependency, null) != null));
                    }
                }
            });
        }
    }

    protected void update() {
        for (int i = 0; i < this.components.size(); ++i) {
            this.update((JComponent)this.components.get(i), true);
        }
    }

    protected void update(JComponent comp, boolean active) {
        String dependency = (String)comp.getClientProperty(PROPERTY_DEPENDENCY);
        active = active && (dependency == null || SReflect.findClass0((String)dependency, null) != null);
        comp.setEnabled(active);
        if (dependency != null && SReflect.findClass0((String)dependency, null) == null && comp instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)comp;
            ab.setText(ab.getText() + " (n/a)");
        }
        String state = Configuration.getConfiguration().getProperty((String)comp.getClientProperty(PROPERTY_NAME));
        if (comp instanceof JRadioButton) {
            ((JRadioButton)comp).setSelected(state != null && state.equals(comp.getClientProperty(PROPERTY_VALUE)));
            active = state != null && state.equals(comp.getClientProperty(PROPERTY_VALUE));
        } else if (comp instanceof JCheckBox) {
            ((JCheckBox)comp).setSelected(state != null && state.equals("true"));
        }
        JCheckBox[] options = (JCheckBox[])comp.getClientProperty(PROPERTY_OPTIONS);
        for (int i = 0; options != null && i < options.length; ++i) {
            this.update(options[i], active);
        }
    }

    protected void save() {
        for (int i = 0; i < this.components.size(); ++i) {
            this.save((JComponent)this.components.get(i));
        }
        try {
            Configuration.getConfiguration().persist();
        }
        catch (IOException e) {
            String txt = SUtil.wrapText((String)("Could not save configuration: " + e.getMessage()));
            JOptionPane.showMessageDialog(this, txt, "Configuration Error", 0);
        }
    }

    protected void save(JComponent comp) {
        String value;
        String name = (String)comp.getClientProperty(PROPERTY_NAME);
        if (comp instanceof JRadioButton) {
            if (((JRadioButton)comp).isSelected()) {
                value = (String)comp.getClientProperty(PROPERTY_VALUE);
                Configuration.getConfiguration().setProperty(name, value);
            }
        } else if (comp instanceof JCheckBox) {
            value = ((JCheckBox)comp).isSelected() ? "true" : "false";
            Configuration.getConfiguration().setProperty(name, value);
        }
        JCheckBox[] options = (JCheckBox[])comp.getClientProperty(PROPERTY_OPTIONS);
        for (int i = 0; options != null && i < options.length; ++i) {
            this.save(options[i]);
        }
    }

    public static void main(String[] args) {
        ConfigurationDialog cf = new ConfigurationDialog(null);
        cf.pack();
        cf.setVisible(true);
        cf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

