/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.tools.common.BrowserPane;
import jadex.util.BrowserLauncher2;
import jadex.util.DynamicURLClassLoader;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;

public class BrowserPane
extends JTextPane {
    protected URL url;
    protected String reference;
    protected boolean popup;
    protected Map externals;
    protected boolean inbrowser;

    public BrowserPane() {
        this.setContentType("text/html");
        this.setEditable(false);
        this.setEditorKit(new ClasspathHTMLEditorKit());
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    BrowserPane.this.url = e.getURL();
                    if (BrowserPane.this.url == null && e.getDescription() != null) {
                        if (e.getDescription().startsWith("#")) {
                            BrowserPane.this.reference = e.getDescription().substring(1);
                        } else {
                            File dir = new File(".");
                            try {
                                BrowserPane.this.url = new URL("file:///" + dir.getAbsolutePath() + "/" + e.getDescription());
                            }
                            catch (MalformedURLException ex) {
                                System.out.println("url: file:///" + dir.getAbsolutePath() + "/" + e.getDescription() + ", " + ex);
                            }
                        }
                    }
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    BrowserPane.this.url = null;
                    BrowserPane.this.reference = null;
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                BrowserPane.this.popup = e.isPopupTrigger();
                if (BrowserPane.this.popup) {
                    BrowserPane.this.doPopup(e.getPoint());
                }
            }

            public void mouseReleased(MouseEvent e) {
                BrowserPane.this.popup = e.isPopupTrigger();
                if (BrowserPane.this.popup) {
                    BrowserPane.this.doPopup(e.getPoint());
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (!BrowserPane.this.popup && BrowserPane.this.url != null) {
                    if (BrowserPane.this.inbrowser) {
                        BrowserPane.this.openExternal(BrowserPane.this.url);
                    } else {
                        BrowserPane.this.setPage(BrowserPane.this.url);
                    }
                    BrowserPane.this.url = null;
                }
                if (!BrowserPane.this.popup && BrowserPane.this.reference != null) {
                    if (BrowserPane.this.externals != null && BrowserPane.this.externals.containsKey(BrowserPane.this.reference)) {
                        BrowserPane.this.setText((String)BrowserPane.this.externals.get(BrowserPane.this.reference));
                    } else {
                        BrowserPane.this.scrollToReference(BrowserPane.this.reference);
                    }
                    BrowserPane.this.reference = null;
                }
            }
        });
    }

    public void setStyledDocument(StyledDocument doc) {
        super.setStyledDocument(doc);
        if (doc instanceof HTMLDocument) {
            ((HTMLDocument)doc).setBase(null);
        }
    }

    public void setPage(URL url) {
        try {
            this.setDocument(this.getEditorKit().createDefaultDocument());
            super.setPage(url);
        }
        catch (IOException ex) {
            this.setText("Could not open page: " + ex);
        }
    }

    public void setText(String text) {
        this.setDocument(this.getEditorKit().createDefaultDocument());
        super.setText(text);
        if (this.getDocument() instanceof HTMLDocument) {
            ((HTMLDocument)this.getDocument()).setBase(null);
        }
    }

    public void setExternals(Map externals) {
        this.externals = externals;
    }

    public void setDefaultOpenMode(boolean inbrowser) {
        this.inbrowser = inbrowser;
    }

    protected void doPopup(Point p) {
        JPopupMenu menu = new JPopupMenu();
        if (this.url != null) {
            final URL url = this.url;
            menu.add(new AbstractAction("Open"){

                public void actionPerformed(ActionEvent e) {
                    BrowserPane.this.setPage(url);
                }
            });
            menu.add(new AbstractAction("Open link in external browser"){

                public void actionPerformed(ActionEvent e) {
                    BrowserPane.this.openExternal(url);
                }
            });
        }
        if (menu.getComponentCount() > 0) {
            menu.show(this, p.x, p.y);
        }
    }

    protected void openExternal(URL url) {
        try {
            BrowserLauncher2.openURL((String)url.toString());
        }
        catch (IOException e) {
            this.setText("Could not start browser: " + e);
        }
    }

    public static class ClasspathHTMLEditorKit
    extends HTMLEditorKit {
        protected ViewFactory thefactory = new HTMLEditorKit.HTMLFactory(this){
            private final /* synthetic */ ClasspathHTMLEditorKit this$0;
            {
                this.this$0 = this$0;
            }

            public View create(Element elem) {
                Object attr = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                View ret = attr == HTML.Tag.IMG ? new ImageView(this, elem){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public URL getImageURL() {
                        String src;
                        URL ret = super.getImageURL();
                        if (ret == null && (src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC)) != null) {
                            ret = DynamicURLClassLoader.getInstance().getResource(src.startsWith("/") ? src.substring(1) : src);
                        }
                        return ret;
                    }
                } : super.create(elem);
                return ret;
            }
        };

        public ViewFactory getViewFactory() {
            return this.thefactory;
        }
    }
}

