/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.config.Configuration;
import jadex.tools.common.jtreetable.DefaultTreeTableCellRenderer;
import jadex.tools.common.jtreetable.DefaultTreeTableModel;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.tools.common.jtreetable.JTreeTable;
import jadex.tools.common.jtreetable.TreeTableNodeType;
import jadex.tools.common.jtreetable.TreeTablePopupListener;
import jadex.util.SGUI;
import jadex.util.SUtil;
import jadex.util.jtable.ResizeableTableHeader;
import jadex.util.jtable.VisibilityTableColumnModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class AgentTreeTable
extends JScrollPane {
    public static String NODE_PLATFORM = "platform_node";
    public static String NODE_AGENT = "agent_node";
    public static UIDefaults icons = new UIDefaults(new Object[]{NODE_AGENT, SGUI.makeIcon((Class)AgentTreeTable.class, (String)"/jadex/tools/common/images/new_agent.png"), NODE_PLATFORM, SGUI.makeIcon((Class)AgentTreeTable.class, (String)"/jadex/tools/common/images/new_platform.png")});
    protected Map nodetypes = new HashMap();
    protected DefaultTreeTableNode platform;
    protected JTreeTable treetable;
    protected ResizeableTableHeader header;

    public AgentTreeTable() {
        this.addNodeType(new TreeTableNodeType(NODE_PLATFORM, new Icon[]{icons.getIcon(NODE_PLATFORM)}, new String[]{"name"}, new String[]{"Name"}));
        this.addNodeType(new TreeTableNodeType(NODE_AGENT, new Icon[]{icons.getIcon(NODE_AGENT)}, new String[]{"name", "address"}, new String[]{"Name", "Address"}));
        this.getViewport().setBackground(UIManager.getColor("List.background"));
        DefaultTreeTableCellRenderer renderer = new DefaultTreeTableCellRenderer();
        String platname = Configuration.getConfiguration().getProperty("platformname");
        this.platform = new DefaultTreeTableNode(this.getNodeType(NODE_PLATFORM), platname != null ? platname : "Local Platform");
        this.treetable = new JTreeTable(new DefaultTreeTableModel(this.platform, this.getNodeType(NODE_AGENT).getColumnNames()));
        this.treetable.getTree().setShowsRootHandles(true);
        this.treetable.getTree().setCellRenderer(renderer);
        this.treetable.addMouseListener(new TreeTablePopupListener());
        this.treetable.setAutoResizeMode(0);
        this.treetable.setBackground(UIManager.getColor("List.background"));
        VisibilityTableColumnModel columnmodel = new VisibilityTableColumnModel();
        this.treetable.setColumnModel((TableColumnModel)columnmodel);
        this.treetable.createDefaultColumnsFromModel();
        columnmodel.addMouseListener((JTable)this.treetable);
        columnmodel.setColumnChangeable(columnmodel.getColumn(0), false);
        this.header = new ResizeableTableHeader();
        this.header.setColumnModel(this.treetable.getColumnModel());
        this.header.setIncludeHeaderWidth(false);
        this.treetable.setTableHeader((JTableHeader)this.header);
        this.setViewportView(this.treetable);
    }

    public void adjustColumnWidths() {
        this.header.resizeAllColumns();
    }

    public void addAgent(AMSAgentDescription description) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("name", description.getName().getName());
        values.put("state", description.getState());
        String[] addresses = description.getName().getAddresses();
        if (addresses.length > 0) {
            values.put("address", addresses[0]);
        }
        this.platform.add(new DefaultTreeTableNode(this.getNodeType(NODE_AGENT), description, values));
        if (this.platform.getChildCount() == 1) {
            this.treetable.getTree().expandPath(new TreePath(this.platform.getPath()));
        }
    }

    protected void printColumnWidths(String msg) {
        TableColumnModel tcm = this.treetable.getColumnModel();
        int[] widths = new int[tcm.getColumnCount()];
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            widths[i] = tcm.getColumn(i).getWidth();
        }
        System.out.println(msg + ", column widths: " + SUtil.arrayToString((Object)widths));
    }

    public void updateAgent(AMSAgentDescription description) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("name", description.getName().getName());
        values.put("state", description.getState());
        String[] addresses = description.getName().getAddresses();
        if (addresses.length > 0) {
            values.put("address", addresses[0]);
        }
        DefaultTreeTableNode node = this.platform.getChild(description);
        node.setValues(values);
        node.setUserObject(description);
    }

    public void removeAgent(AMSAgentDescription description) {
        DefaultTreeTableNode child = this.platform.getChild(description);
        if (child != null) {
            this.platform.remove(child);
        }
    }

    public void removeAgents() {
        this.platform.removeAllChildren();
    }

    public TreeTableNodeType getNodeType(String name) {
        return (TreeTableNodeType)this.nodetypes.get(name);
    }

    public void addNodeType(TreeTableNodeType type) {
        this.nodetypes.put(type.getName(), type);
    }

    public JTreeTable getTreetable() {
        return this.treetable;
    }

    public DefaultMutableTreeNode getPlatform() {
        return this.platform;
    }
}

